/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class DoubleArgumentInfo
implements ArgumentTypeInfo<DoubleArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
        boolean var2 = var0.min != -1.7976931348623157E308;
        boolean var3 = var0.max != Double.MAX_VALUE;
        var1.writeByte(ArgumentUtils.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeDouble(var0.min);
        }
        if (var3) {
            var1.writeDouble(var0.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf var0) {
        byte var1 = var0.readByte();
        double var2 = ArgumentUtils.numberHasMin(var1) ? var0.readDouble() : -1.7976931348623157E308;
        double var4 = ArgumentUtils.numberHasMax(var1) ? var0.readDouble() : Double.MAX_VALUE;
        return new Template(var2, var4);
    }

    @Override
    public void serializeToJson(Template var0, JsonObject var1) {
        if (var0.min != -1.7976931348623157E308) {
            var1.addProperty("min", (Number)var0.min);
        }
        if (var0.max != Double.MAX_VALUE) {
            var1.addProperty("max", (Number)var0.max);
        }
    }

    @Override
    public Template unpack(DoubleArgumentType var0) {
        return new Template(var0.getMinimum(), var0.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        return this.deserializeFromNetwork(friendlyByteBuf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<DoubleArgumentType> {
        final double min;
        final double max;

        Template(double var1, double var3) {
            this.min = var1;
            this.max = var3;
        }

        @Override
        public DoubleArgumentType instantiate(CommandBuildContext var0) {
            return DoubleArgumentType.doubleArg((double)this.min, (double)this.max);
        }

        @Override
        public ArgumentTypeInfo<DoubleArgumentType, ?> type() {
            return DoubleArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return this.instantiate(commandBuildContext);
        }
    }
}

