/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;

public class ColorParticleOption
implements ParticleOptions {
    private final ParticleType<ColorParticleOption> type;
    private final int color;

    public static MapCodec<ColorParticleOption> codec(ParticleType<ColorParticleOption> var02) {
        return ExtraCodecs.ARGB_COLOR_CODEC.xmap(var1 -> new ColorParticleOption(var02, (int)var1), var0 -> var0.color).fieldOf("color");
    }

    public static StreamCodec<? super ByteBuf, ColorParticleOption> streamCodec(ParticleType<ColorParticleOption> var02) {
        return ByteBufCodecs.INT.map(var1 -> new ColorParticleOption(var02, (int)var1), var0 -> var0.color);
    }

    private ColorParticleOption(ParticleType<ColorParticleOption> var0, int var1) {
        this.type = var0;
        this.color = var1;
    }

    public ParticleType<ColorParticleOption> getType() {
        return this.type;
    }

    public float getRed() {
        return (float)ARGB.red(this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)ARGB.green(this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)ARGB.blue(this.color) / 255.0f;
    }

    public float getAlpha() {
        return (float)ARGB.alpha(this.color) / 255.0f;
    }

    public static ColorParticleOption create(ParticleType<ColorParticleOption> var0, int var1) {
        return new ColorParticleOption(var0, var1);
    }

    public static ColorParticleOption create(ParticleType<ColorParticleOption> var0, float var1, float var2, float var3) {
        return ColorParticleOption.create(var0, ARGB.colorFromFloat(1.0f, var1, var2, var3));
    }
}

