/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public record ChatTypeDecoration(String translationKey, List<Parameter> parameters, Style style) {
    public static final Codec<ChatTypeDecoration> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("translation_key").forGetter(ChatTypeDecoration::translationKey), (App)Parameter.CODEC.listOf().fieldOf("parameters").forGetter(ChatTypeDecoration::parameters), (App)Style.Serializer.CODEC.optionalFieldOf("style", (Object)Style.EMPTY).forGetter(ChatTypeDecoration::style)).apply((Applicative)var0, ChatTypeDecoration::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChatTypeDecoration> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, ChatTypeDecoration::translationKey, Parameter.STREAM_CODEC.apply(ByteBufCodecs.list()), ChatTypeDecoration::parameters, Style.Serializer.TRUSTED_STREAM_CODEC, ChatTypeDecoration::style, ChatTypeDecoration::new);

    public static ChatTypeDecoration withSender(String var0) {
        return new ChatTypeDecoration(var0, List.of(Parameter.SENDER, Parameter.CONTENT), Style.EMPTY);
    }

    public static ChatTypeDecoration incomingDirectMessage(String var0) {
        Style var1 = Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(true);
        return new ChatTypeDecoration(var0, List.of(Parameter.SENDER, Parameter.CONTENT), var1);
    }

    public static ChatTypeDecoration outgoingDirectMessage(String var0) {
        Style var1 = Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(true);
        return new ChatTypeDecoration(var0, List.of(Parameter.TARGET, Parameter.CONTENT), var1);
    }

    public static ChatTypeDecoration teamMessage(String var0) {
        return new ChatTypeDecoration(var0, List.of(Parameter.TARGET, Parameter.SENDER, Parameter.CONTENT), Style.EMPTY);
    }

    public Component decorate(Component var0, ChatType.Bound var1) {
        Object[] var2 = this.resolveParameters(var0, var1);
        return Component.translatable(this.translationKey, var2).withStyle(this.style);
    }

    private Component[] resolveParameters(Component var0, ChatType.Bound var1) {
        Component[] var2 = new Component[this.parameters.size()];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            Parameter var4 = this.parameters.get(var3);
            var2[var3] = var4.select(var0, var1);
        }
        return var2;
    }

    public static enum Parameter implements StringRepresentable
    {
        SENDER(0, "sender", (var0, var1) -> var1.name()),
        TARGET(1, "target", (var0, var1) -> var1.targetName().orElse(CommonComponents.EMPTY)),
        CONTENT(2, "content", (var0, var1) -> var0);

        private static final IntFunction<Parameter> BY_ID;
        public static final Codec<Parameter> CODEC;
        public static final StreamCodec<ByteBuf, Parameter> STREAM_CODEC;
        private final int id;
        private final String name;
        private final Selector selector;

        private Parameter(int var2, String var3, Selector var4) {
            this.id = var2;
            this.name = var3;
            this.selector = var4;
        }

        public Component select(Component var0, ChatType.Bound var1) {
            return this.selector.select(var0, var1);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(var0 -> var0.id, Parameter.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Parameter::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, var0 -> var0.id);
        }

        public static interface Selector {
            public Component select(Component var1, ChatType.Bound var2);
        }
    }
}

