/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.util.Either;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;

public interface Component
extends Message,
FormattedText,
Iterable<Component> {
    default public Stream<Component> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.getSiblings().stream().flatMap(Component::stream)});
    }

    @Override
    default public Iterator<Component> iterator() {
        return this.stream().iterator();
    }

    public Style getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String getString(int i) {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(s -> {
            int j = i - stringbuilder.length();
            if (j <= 0) {
                return STOP_ITERATION;
            }
            stringbuilder.append(s.length() <= j ? s : s.substring(0, j));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<Component> getSiblings();

    @Nullable
    default public String tryCollapseToString() {
        ComponentContents componentcontents = this.getContents();
        if (componentcontents instanceof PlainTextContents) {
            PlainTextContents literalcontents = (PlainTextContents)componentcontents;
            if (this.getSiblings().isEmpty() && this.getStyle().isEmpty()) {
                return literalcontents.text();
            }
        }
        return null;
    }

    default public MutableComponent plainCopy() {
        return MutableComponent.create(this.getContents());
    }

    default public MutableComponent copy() {
        return new MutableComponent(this.getContents(), new ArrayList<Component>(this.getSiblings()), this.getStyle());
    }

    public FormattedCharSequence getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> ichatformatted_b, Style chatmodifier) {
        Style chatmodifier1 = this.getStyle().applyTo(chatmodifier);
        Optional<T> optional = this.getContents().visit(ichatformatted_b, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component ichatbasecomponent : this.getSiblings()) {
            Optional<T> optional1 = ichatbasecomponent.visit(ichatformatted_b, chatmodifier1);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> visit(FormattedText.ContentConsumer<T> ichatformatted_a) {
        Optional<T> optional = this.getContents().visit(ichatformatted_a);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component ichatbasecomponent : this.getSiblings()) {
            Optional<T> optional1 = ichatbasecomponent.visit(ichatformatted_a);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public List<Component> toFlatList() {
        return this.toFlatList(Style.EMPTY);
    }

    default public List<Component> toFlatList(Style chatmodifier) {
        ArrayList list = Lists.newArrayList();
        this.visit((chatmodifier1, s) -> {
            if (!s.isEmpty()) {
                list.add(Component.literal(s).withStyle(chatmodifier1));
            }
            return Optional.empty();
        }, chatmodifier);
        return list;
    }

    default public boolean contains(Component ichatbasecomponent) {
        List<Component> list1;
        if (this.equals(ichatbasecomponent)) {
            return true;
        }
        List<Component> list = this.toFlatList();
        return Collections.indexOfSubList(list, list1 = ichatbasecomponent.toFlatList(this.getStyle())) != -1;
    }

    public static Component nullToEmpty(@Nullable String s) {
        return s != null ? Component.literal(s) : CommonComponents.EMPTY;
    }

    public static MutableComponent literal(String s) {
        return MutableComponent.create(PlainTextContents.create(s));
    }

    public static MutableComponent translatable(String s) {
        return MutableComponent.create(new TranslatableContents(s, null, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatable(String s, Object ... aobject) {
        return MutableComponent.create(new TranslatableContents(s, null, aobject));
    }

    public static MutableComponent translatableEscape(String s, Object ... aobject) {
        for (int i = 0; i < aobject.length; ++i) {
            Object object = aobject[i];
            if (TranslatableContents.isAllowedPrimitiveArgument(object) || object instanceof Component) continue;
            aobject[i] = String.valueOf(object);
        }
        return Component.translatable(s, aobject);
    }

    public static MutableComponent translatableWithFallback(String s, @Nullable String s1) {
        return MutableComponent.create(new TranslatableContents(s, s1, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatableWithFallback(String s, @Nullable String s1, Object ... aobject) {
        return MutableComponent.create(new TranslatableContents(s, s1, aobject));
    }

    public static MutableComponent empty() {
        return MutableComponent.create(PlainTextContents.EMPTY);
    }

    public static MutableComponent keybind(String s) {
        return MutableComponent.create(new KeybindContents(s));
    }

    public static MutableComponent nbt(String s, boolean flag, Optional<Component> optional, DataSource datasource) {
        return MutableComponent.create(new NbtContents(s, flag, optional, datasource));
    }

    public static MutableComponent score(SelectorPattern selectorpattern, String s) {
        return MutableComponent.create(new ScoreContents((Either<SelectorPattern, String>)Either.left((Object)selectorpattern), s));
    }

    public static MutableComponent score(String s, String s1) {
        return MutableComponent.create(new ScoreContents((Either<SelectorPattern, String>)Either.right((Object)s), s1));
    }

    public static MutableComponent selector(SelectorPattern selectorpattern, Optional<Component> optional) {
        return MutableComponent.create(new SelectorContents(selectorpattern, optional));
    }

    public static Component translationArg(Date date) {
        return Component.literal(date.toString());
    }

    public static Component translationArg(Message message) {
        Component object;
        if (message instanceof Component) {
            Component ichatbasecomponent = (Component)message;
            object = ichatbasecomponent;
        } else {
            object = Component.literal(message.getString());
        }
        return object;
    }

    public static Component translationArg(UUID uuid) {
        return Component.literal(uuid.toString());
    }

    public static Component translationArg(ResourceLocation minecraftkey) {
        return Component.literal(minecraftkey.toString());
    }

    public static Component translationArg(ChunkPos chunkcoordintpair) {
        return Component.literal(chunkcoordintpair.toString());
    }

    public static Component translationArg(URI uri) {
        return Component.literal(uri.toString());
    }
}

