/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public record StructuresDebugPayload(ResourceKey<Level> dimension, BoundingBox mainBB, List<PieceInfo> pieces) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, StructuresDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(StructuresDebugPayload::write, StructuresDebugPayload::new);
    public static final CustomPacketPayload.Type<StructuresDebugPayload> TYPE = CustomPacketPayload.createType("debug/structures");

    private StructuresDebugPayload(FriendlyByteBuf var0) {
        this(var0.readResourceKey(Registries.DIMENSION), StructuresDebugPayload.readBoundingBox(var0), var0.readList(PieceInfo::new));
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeResourceKey(this.dimension);
        StructuresDebugPayload.writeBoundingBox(var0, this.mainBB);
        var0.writeCollection(this.pieces, (var1, var2) -> var2.write(var0));
    }

    public CustomPacketPayload.Type<StructuresDebugPayload> type() {
        return TYPE;
    }

    static BoundingBox readBoundingBox(FriendlyByteBuf var0) {
        return new BoundingBox(var0.readInt(), var0.readInt(), var0.readInt(), var0.readInt(), var0.readInt(), var0.readInt());
    }

    static void writeBoundingBox(FriendlyByteBuf var0, BoundingBox var1) {
        var0.writeInt(var1.minX());
        var0.writeInt(var1.minY());
        var0.writeInt(var1.minZ());
        var0.writeInt(var1.maxX());
        var0.writeInt(var1.maxY());
        var0.writeInt(var1.maxZ());
    }

    public record PieceInfo(BoundingBox boundingBox, boolean isStart) {
        public PieceInfo(FriendlyByteBuf var0) {
            this(StructuresDebugPayload.readBoundingBox(var0), var0.readBoolean());
        }

        public void write(FriendlyByteBuf var0) {
            StructuresDebugPayload.writeBoundingBox(var0, this.boundingBox);
            var0.writeBoolean(this.isStart);
        }
    }
}

