/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;

public class CompositePackResources
implements PackResources {
    private final PackResources primaryPackResources;
    private final List<PackResources> packResourcesStack;

    public CompositePackResources(PackResources var0, List<PackResources> var1) {
        this.primaryPackResources = var0;
        ArrayList<PackResources> var2 = new ArrayList<PackResources>(var1.size() + 1);
        var2.addAll(Lists.reverse(var1));
        var2.add(var0);
        this.packResourcesStack = List.copyOf(var2);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... var0) {
        return this.primaryPackResources.getRootResource(var0);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getResource(PackType var0, ResourceLocation var1) {
        for (PackResources var3 : this.packResourcesStack) {
            IoSupplier<InputStream> var4 = var3.getResource(var0, var1);
            if (var4 == null) continue;
            return var4;
        }
        return null;
    }

    @Override
    public void listResources(PackType var0, String var1, String var2, PackResources.ResourceOutput var3) {
        HashMap<ResourceLocation, IoSupplier<InputStream>> var4 = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
        for (PackResources var6 : this.packResourcesStack) {
            var6.listResources(var0, var1, var2, var4::putIfAbsent);
        }
        var4.forEach(var3);
    }

    @Override
    public Set<String> getNamespaces(PackType var0) {
        HashSet<String> var1 = new HashSet<String>();
        for (PackResources var3 : this.packResourcesStack) {
            var1.addAll(var3.getNamespaces(var0));
        }
        return var1;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> var0) throws IOException {
        return this.primaryPackResources.getMetadataSection(var0);
    }

    @Override
    public PackLocationInfo location() {
        return this.primaryPackResources.location();
    }

    @Override
    public void close() {
        this.packResourcesStack.forEach(PackResources::close);
    }
}

