/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public abstract class BlockRenameFix
extends DataFix {
    private final String name;

    public BlockRenameFix(Schema var0, String var1) {
        super(var0, false);
        this.name = var1;
    }

    public TypeRewriteRule makeRule() {
        Type var1;
        Type var03 = this.getInputSchema().getType(References.BLOCK_NAME);
        if (!Objects.equals(var03, var1 = DSL.named((String)References.BLOCK_NAME.typeName(), NamespacedSchema.namespacedString()))) {
            throw new IllegalStateException("block type is not what was expected.");
        }
        TypeRewriteRule var2 = this.fixTypeEverywhere(this.name + " for block", var1, var02 -> var0 -> var0.mapSecond(this::renameBlock));
        TypeRewriteRule var3 = this.fixTypeEverywhereTyped(this.name + " for block_state", this.getInputSchema().getType(References.BLOCK_STATE), var0 -> var0.update(DSL.remainderFinder(), this::fixBlockState));
        TypeRewriteRule var4 = this.fixTypeEverywhereTyped(this.name + " for flat_block_state", this.getInputSchema().getType(References.FLAT_BLOCK_STATE), var02 -> var02.update(DSL.remainderFinder(), var0 -> (Dynamic)DataFixUtils.orElse(var0.asString().result().map(this::fixFlatBlockState).map(arg_0 -> ((Dynamic)var0).createString(arg_0)), (Object)var0)));
        return TypeRewriteRule.seq((TypeRewriteRule)var2, (TypeRewriteRule[])new TypeRewriteRule[]{var3, var4});
    }

    private Dynamic<?> fixBlockState(Dynamic<?> var0) {
        Optional var1 = var0.get("Name").asString().result();
        if (var1.isPresent()) {
            return var0.set("Name", var0.createString(this.renameBlock((String)var1.get())));
        }
        return var0;
    }

    private String fixFlatBlockState(String var0) {
        int var1 = var0.indexOf(91);
        int var2 = var0.indexOf(123);
        int var3 = var0.length();
        if (var1 > 0) {
            var3 = var1;
        }
        if (var2 > 0) {
            var3 = Math.min(var3, var2);
        }
        String var4 = var0.substring(0, var3);
        String var5 = this.renameBlock(var4);
        return var5 + var0.substring(var3);
    }

    protected abstract String renameBlock(String var1);

    public static DataFix create(Schema var0, String var1, final Function<String, String> var2) {
        return new BlockRenameFix(var0, var1){

            @Override
            protected String renameBlock(String var0) {
                return (String)var2.apply(var0);
            }
        };
    }
}

