/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debugchart;

import net.minecraft.util.debugchart.SampleLogger;

public abstract class AbstractSampleLogger
implements SampleLogger {
    protected final long[] defaults;
    protected final long[] sample;

    protected AbstractSampleLogger(int var0, long[] var1) {
        if (var1.length != var0) {
            throw new IllegalArgumentException("defaults have incorrect length of " + var1.length);
        }
        this.sample = new long[var0];
        this.defaults = var1;
    }

    @Override
    public void logFullSample(long[] var0) {
        System.arraycopy(var0, 0, this.sample, 0, var0.length);
        this.useSample();
        this.resetSample();
    }

    @Override
    public void logSample(long var0) {
        this.sample[0] = var0;
        this.useSample();
        this.resetSample();
    }

    @Override
    public void logPartialSample(long var0, int var2) {
        if (var2 < 1 || var2 >= this.sample.length) {
            throw new IndexOutOfBoundsException(var2 + " out of bounds for dimensions " + this.sample.length);
        }
        this.sample[var2] = var0;
    }

    protected abstract void useSample();

    protected void resetSample() {
        System.arraycopy(this.defaults, 0, this.sample, 0, this.defaults.length);
    }
}

