/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.CustomTimingsHandler;

public abstract class Entity
implements SyncedDataHolder,
Nameable,
EntityAccess,
ScoreHolder,
DataComponentGetter {
    private static final int CURRENT_LEVEL = 2;
    private CraftEntity bukkitEntity;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_ID = "id";
    public static final String TAG_UUID = "UUID";
    public static final String TAG_PASSENGERS = "Passengers";
    public static final String TAG_DATA = "data";
    public static final String TAG_POS = "Pos";
    public static final String TAG_MOTION = "Motion";
    public static final String TAG_ROTATION = "Rotation";
    public static final String TAG_PORTAL_COOLDOWN = "PortalCooldown";
    public static final String TAG_NO_GRAVITY = "NoGravity";
    public static final String TAG_AIR = "Air";
    public static final String TAG_ON_GROUND = "OnGround";
    public static final String TAG_FALL_DISTANCE = "fall_distance";
    public static final String TAG_FIRE = "Fire";
    public static final String TAG_SILENT = "Silent";
    public static final String TAG_GLOWING = "Glowing";
    public static final String TAG_INVULNERABLE = "Invulnerable";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    public static final int CONTENTS_SLOT_INDEX = 0;
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    private static final Codec<List<String>> TAG_LIST_CODEC = Codec.STRING.sizeLimitedListOf(1024);
    public static final float DELTA_AFFECTED_BY_BLOCKS_BELOW_0_2 = 0.2f;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_0_5 = 0.500001;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_1_0 = 0.999999;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    public static final int BASE_SAFE_FALL_DISTANCE = 3;
    private static final ImmutableList<Direction.Axis> YXZ_AXIS_ORDER = ImmutableList.of((Object)Direction.Axis.Y, (Object)Direction.Axis.X, (Object)Direction.Axis.Z);
    private static final ImmutableList<Direction.Axis> YZX_AXIS_ORDER = ImmutableList.of((Object)Direction.Axis.Y, (Object)Direction.Axis.Z, (Object)Direction.Axis.X);
    private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    private static double viewScale = 1.0;
    private final EntityType<?> type;
    private boolean requiresPrecisePosition;
    private int id;
    public boolean blocksBuilding;
    public ImmutableList<Entity> passengers;
    protected int boardingCooldown;
    @Nullable
    private Entity vehicle;
    private Level level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3 position;
    private BlockPos blockPosition;
    private ChunkPos chunkPosition;
    private Vec3 deltaMovement;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AABB bb;
    public boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean verticalCollisionBelow;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3 stuckSpeedMultiplier;
    @Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float moveDist;
    public float flyDist;
    public double fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public boolean noPhysics;
    public final RandomSource random;
    public int tickCount;
    private int remainingFireTicks;
    public boolean wasTouchingWater;
    protected Object2DoubleMap<TagKey<Fluid>> fluidHeight;
    protected boolean wasEyeInWater;
    private final Set<TagKey<Fluid>> fluidOnEyes;
    public int invulnerableTime;
    protected boolean firstTick = true;
    protected final SynchedEntityData entityData;
    protected static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    private static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final EntityDataAccessor<Integer> DATA_AIR_SUPPLY_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<Boolean> DATA_CUSTOM_NAME_VISIBLE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SILENT = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_NO_GRAVITY = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Pose> DATA_POSE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.POSE);
    private static final EntityDataAccessor<Integer> DATA_TICKS_FROZEN = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private EntityInLevelCallback levelCallback;
    private final VecDeltaCodec packetPositionCodec;
    public boolean hasImpulse;
    @Nullable
    public PortalProcessor portalProcess;
    public int portalCooldown;
    private boolean invulnerable;
    protected UUID uuid;
    protected String stringUUID;
    private boolean hasGlowingTag;
    private final Set<String> tags;
    private final double[] pistonDeltas;
    private long pistonDeltasGameTime;
    private EntityDimensions dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public Optional<BlockPos> mainSupportingBlockPos;
    private boolean onGroundNoBlocks = false;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    public boolean hasVisualFire;
    @Nullable
    private BlockState inBlockState = null;
    public static final int MAX_MOVEMENTS_HANDELED_PER_TICK = 100;
    private final ArrayDeque<Movement> movementThisTick;
    private final List<Movement> finalMovementsThisTick;
    private final LongSet visitedBlocks;
    private final InsideBlockEffectApplier.StepBasedCollector insideEffectCollector;
    private CustomData customData;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPos lastLavaContact;
    public boolean pluginRemoved = false;
    public CustomTimingsHandler tickTimer = SpigotTimings.getEntityTimings(this);
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    private final CommandSource commandSource = new CommandSource(){

        @Override
        public void sendSystemMessage(Component ichatbasecomponent) {
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean acceptsSuccess() {
            return ((ServerLevel)Entity.this.level()).getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return true;
        }
    };

    static boolean isLevelAtLeast(ValueInput tag, int level) {
        int updateLevel = tag.getIntOr("Bukkit.updateLevel", -1);
        return updateLevel != -1 && tag.getIntOr("Bukkit.updateLevel", -1) >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.level.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public float getBukkitYaw() {
        return this.yRot;
    }

    public boolean isChunkLoaded() {
        return this.level.hasChunk((int)Math.floor(this.getX()) >> 4, (int)Math.floor(this.getZ()) >> 4);
    }

    public Entity(EntityType<?> entitytypes, Level world) {
        this.id = ENTITY_COUNTER.incrementAndGet();
        this.passengers = ImmutableList.of();
        this.deltaMovement = Vec3.ZERO;
        this.bb = INITIAL_AABB;
        this.stuckSpeedMultiplier = Vec3.ZERO;
        this.random = RandomSource.create();
        this.fluidHeight = new Object2DoubleArrayMap(2);
        this.fluidOnEyes = new HashSet<TagKey<Fluid>>();
        this.levelCallback = EntityInLevelCallback.NULL;
        this.packetPositionCodec = new VecDeltaCodec();
        this.uuid = Mth.createInsecureUUID(this.random);
        this.stringUUID = this.uuid.toString();
        this.tags = Sets.newHashSet();
        this.pistonDeltas = new double[]{0.0, 0.0, 0.0};
        this.mainSupportingBlockPos = Optional.empty();
        this.movementThisTick = new ArrayDeque(100);
        this.finalMovementsThisTick = new ObjectArrayList();
        this.visitedBlocks = new LongOpenHashSet();
        this.insideEffectCollector = new InsideBlockEffectApplier.StepBasedCollector();
        this.customData = CustomData.EMPTY;
        this.type = entitytypes;
        this.level = world;
        this.dimensions = entitytypes.getDimensions();
        this.position = Vec3.ZERO;
        this.blockPosition = BlockPos.ZERO;
        this.chunkPosition = ChunkPos.ZERO;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        SynchedEntityData.Builder datawatcher_a = new SynchedEntityData.Builder(this);
        datawatcher_a.define(DATA_SHARED_FLAGS_ID, (byte)0);
        datawatcher_a.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        datawatcher_a.define(DATA_CUSTOM_NAME_VISIBLE, false);
        datawatcher_a.define(DATA_CUSTOM_NAME, Optional.empty());
        datawatcher_a.define(DATA_SILENT, false);
        datawatcher_a.define(DATA_NO_GRAVITY, false);
        datawatcher_a.define(DATA_POSE, Pose.STANDING);
        datawatcher_a.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData(datawatcher_a);
        this.entityData = datawatcher_a.build();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.dimensions.eyeHeight();
    }

    public boolean isColliding(BlockPos blockposition, BlockState iblockdata) {
        VoxelShape voxelshape = iblockdata.getCollisionShape(this.level(), blockposition, CollisionContext.of(this)).move(blockposition);
        return Shapes.joinIsNotEmpty(voxelshape, Shapes.create(this.getBoundingBox()), BooleanOp.AND);
    }

    public int getTeamColor() {
        PlayerTeam scoreboardteambase = this.getTeam();
        return scoreboardteambase != null && ((Team)scoreboardteambase).getColor().getColor() != null ? ((Team)scoreboardteambase).getColor().getColor() : 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void syncPacketPositionCodec(double d0, double d1, double d2) {
        this.packetPositionCodec.setBase(new Vec3(d0, d1, d2));
    }

    public VecDeltaCodec getPositionCodec() {
        return this.packetPositionCodec;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    public boolean getRequiresPrecisePosition() {
        return this.requiresPrecisePosition;
    }

    public void setRequiresPrecisePosition(boolean flag) {
        this.requiresPrecisePosition = flag;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = i;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String s) {
        return this.tags.size() >= 1024 ? false : this.tags.add(s);
    }

    public boolean removeTag(String s) {
        return this.tags.remove(s);
    }

    public void kill(ServerLevel worldserver) {
        this.remove(RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    public final void discard() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.DISCARDED, cause);
    }

    protected abstract void defineSynchedData(SynchedEntityData.Builder var1);

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public void refreshEntityData(ServerPlayer to) {
        List<SynchedEntityData.DataValue<?>> list = this.getEntityData().getNonDefaultValues();
        if (list != null) {
            to.connection.send(new ClientboundSetEntityDataPacket(this.getId(), list));
        }
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).id == this.id : false;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void onClientRemoval() {
    }

    public void onRemoval(RemovalReason entity_removalreason) {
    }

    public void setPose(Pose entitypose) {
        if (entitypose == this.getPose()) {
            return;
        }
        this.level.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), org.bukkit.entity.Pose.values()[entitypose.ordinal()]));
        this.entityData.set(DATA_POSE, entitypose);
    }

    public Pose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean hasPose(Pose entitypose) {
        return this.getPose() == entitypose;
    }

    public boolean closerThan(Entity entity, double d0) {
        return this.position().closerThan(entity.position(), d0);
    }

    public boolean closerThan(Entity entity, double d0, double d1) {
        double d2 = entity.getX() - this.getX();
        double d3 = entity.getY() - this.getY();
        double d4 = entity.getZ() - this.getZ();
        return Mth.lengthSquared(d2, d4) < Mth.square(d0) && Mth.square(d3) < Mth.square(d1);
    }

    protected void setRot(float f, float f1) {
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
            if (this instanceof ServerPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            f = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        if (f1 == Float.POSITIVE_INFINITY || f1 == Float.NEGATIVE_INFINITY) {
            if (this instanceof ServerPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            f1 = 0.0f;
        }
        this.setYRot(f % 360.0f);
        this.setXRot(f1 % 360.0f);
    }

    public final void setPos(Vec3 vec3d) {
        this.setPos(vec3d.x(), vec3d.y(), vec3d.z());
    }

    public void setPos(double d0, double d1, double d2) {
        this.setPosRaw(d0, d1, d2);
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected final AABB makeBoundingBox() {
        return this.makeBoundingBox(this.position);
    }

    protected AABB makeBoundingBox(Vec3 vec3d) {
        return this.dimensions.makeBoundingBox(vec3d);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double d0, double d1) {
        float f = (float)d1 * 0.15f;
        float f1 = (float)d0 * 0.15f;
        this.setXRot(this.getXRot() + f);
        this.setYRot(this.getYRot() + f1);
        this.setXRot(Mth.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += f;
        this.yRotO += f1;
        this.xRotO = Mth.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void postTick() {
        if (!(this instanceof ServerPlayer)) {
            this.handlePortal();
        }
    }

    public void baseTick() {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("entityBaseTick");
        this.inBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        if (this instanceof ServerPlayer) {
            this.handlePortal();
        }
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (this.remainingFireTicks > 0) {
                if (this.fireImmune()) {
                    this.setRemainingFireTicks(this.remainingFireTicks - 4);
                } else {
                    if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                        this.hurtServer(worldserver, this.damageSources().onFire(), 1.0f);
                    }
                    this.setRemainingFireTicks(this.remainingFireTicks - 1);
                }
            }
        } else {
            this.clearFire();
        }
        if (this.isInLava()) {
            this.fallDistance *= 0.5;
        } else {
            this.lastLavaContact = null;
        }
        this.checkBelowWorld();
        if (!this.level().isClientSide) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver1 = (ServerLevel)world;
            if (this instanceof Leashable) {
                Leashable.tickLeash(worldserver1, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        gameprofilerfiller.pop();
    }

    public void setSharedFlagOnFire(boolean flag) {
        this.setSharedFlag(0, flag || this.hasVisualFire);
    }

    public void checkBelowWorld() {
        if (this.getY() < (double)(this.level().getMinY() - 64)) {
            this.onBelowWorld();
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public void setPortalCooldown(int i) {
        this.portalCooldown = i;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public void lavaIgnite() {
        if (!this.fireImmune()) {
            if (this instanceof LivingEntity && this.remainingFireTicks <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.level, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.level.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
        }
    }

    public void lavaHurt() {
        ServerLevel worldserver;
        Level world;
        if (!this.fireImmune() && (world = this.level()) instanceof ServerLevel && this.hurtServer(worldserver = (ServerLevel)world, this.damageSources().lava().directBlock(this.level, this.lastLavaContact), 4.0f) && this.shouldPlayLavaHurtSound() && !this.isSilent()) {
            worldserver.playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_BURN, this.getSoundSource(), 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
    }

    protected boolean shouldPlayLavaHurtSound() {
        return true;
    }

    public final void igniteForSeconds(float f) {
        this.igniteForSeconds(f, true);
    }

    public final void igniteForSeconds(float f, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f);
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f = event.getDuration();
        }
        this.igniteForTicks(Mth.floor(f * 20.0f));
    }

    public void igniteForTicks(int i) {
        if (this.remainingFireTicks < i) {
            this.setRemainingFireTicks(i);
        }
        this.clearFreeze();
    }

    public void setRemainingFireTicks(int i) {
        this.remainingFireTicks = i;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(0);
    }

    protected void onBelowWorld() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean isFree(double d0, double d1, double d2) {
        return this.isFree(this.getBoundingBox().move(d0, d1, d2));
    }

    private boolean isFree(AABB axisalignedbb) {
        return this.level().noCollision(this, axisalignedbb) && !this.level().containsAnyLiquid(axisalignedbb);
    }

    public void setOnGround(boolean flag) {
        this.onGround = flag;
        this.checkSupportingBlock(flag, null);
    }

    public void setOnGroundWithMovement(boolean flag, Vec3 vec3d) {
        this.setOnGroundWithMovement(flag, this.horizontalCollision, vec3d);
    }

    public void setOnGroundWithMovement(boolean flag, boolean flag1, Vec3 vec3d) {
        this.onGround = flag;
        this.horizontalCollision = flag1;
        this.checkSupportingBlock(flag, vec3d);
    }

    public boolean isSupportedBy(BlockPos blockposition) {
        return this.mainSupportingBlockPos.isPresent() && this.mainSupportingBlockPos.get().equals(blockposition);
    }

    protected void checkSupportingBlock(boolean flag, @Nullable Vec3 vec3d) {
        if (flag) {
            AABB axisalignedbb = this.getBoundingBox();
            AABB axisalignedbb1 = new AABB(axisalignedbb.minX, axisalignedbb.minY - 1.0E-6, axisalignedbb.minZ, axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
            Optional<BlockPos> optional = this.level.findSupportingBlock(this, axisalignedbb1);
            if (!optional.isPresent() && !this.onGroundNoBlocks) {
                if (vec3d != null) {
                    AABB axisalignedbb2 = axisalignedbb1.move(-vec3d.x, 0.0, -vec3d.z);
                    optional = this.level.findSupportingBlock(this, axisalignedbb2);
                    this.mainSupportingBlockPos = optional;
                }
            } else {
                this.mainSupportingBlockPos = optional;
            }
            this.onGroundNoBlocks = optional.isEmpty();
        } else {
            this.onGroundNoBlocks = false;
            if (this.mainSupportingBlockPos.isPresent()) {
                this.mainSupportingBlockPos = Optional.empty();
            }
        }
    }

    public boolean onGround() {
        return this.onGround;
    }

    public void move(MoverType enummovetype, Vec3 vec3d) {
        SpigotTimings.entityMoveTimer.startTiming();
        if (this.noPhysics) {
            this.setPos(this.getX() + vec3d.x, this.getY() + vec3d.y, this.getZ() + vec3d.z);
        } else {
            Vec3 vec3d1;
            double d0;
            if (enummovetype == MoverType.PISTON && (vec3d = this.limitPistonMovement(vec3d)).equals(Vec3.ZERO)) {
                return;
            }
            ProfilerFiller gameprofilerfiller = Profiler.get();
            gameprofilerfiller.push("move");
            if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
                vec3d = vec3d.multiply(this.stuckSpeedMultiplier);
                this.stuckSpeedMultiplier = Vec3.ZERO;
                this.setDeltaMovement(Vec3.ZERO);
            }
            if ((d0 = (vec3d1 = this.collide(vec3d = this.maybeBackOffFromEdge(vec3d, enummovetype))).lengthSqr()) > 1.0E-7 || vec3d.lengthSqr() - d0 < 1.0E-7) {
                BlockHitResult movingobjectpositionblock;
                if (this.fallDistance != 0.0 && d0 >= 1.0 && (movingobjectpositionblock = this.level().clip(new ClipContext(this.position(), this.position().add(vec3d1), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, this))).getType() != HitResult.Type.MISS) {
                    this.resetFallDistance();
                }
                Vec3 vec3d2 = this.position();
                Vec3 vec3d3 = vec3d2.add(vec3d1);
                this.addMovementThisTick(new Movement(vec3d2, vec3d3, true));
                this.setPos(vec3d3);
            }
            gameprofilerfiller.pop();
            gameprofilerfiller.push("rest");
            boolean flag = !Mth.equal(vec3d.x, vec3d1.x);
            boolean flag1 = !Mth.equal(vec3d.z, vec3d1.z);
            boolean bl = this.horizontalCollision = flag || flag1;
            if (Math.abs(vec3d.y) > 0.0 || this.isLocalInstanceAuthoritative()) {
                this.verticalCollision = vec3d.y != vec3d1.y;
                this.verticalCollisionBelow = this.verticalCollision && vec3d.y < 0.0;
                this.setOnGroundWithMovement(this.verticalCollisionBelow, this.horizontalCollision, vec3d1);
            }
            this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(vec3d1) : false;
            BlockPos blockposition = this.getOnPosLegacy();
            BlockState iblockdata = this.level().getBlockState(blockposition);
            if (this.isLocalInstanceAuthoritative()) {
                this.checkFallDamage(vec3d1.y, this.onGround(), iblockdata, blockposition);
            }
            if (this.isRemoved()) {
                gameprofilerfiller.pop();
            } else {
                MovementEmission entity_movementemission;
                if (this.horizontalCollision) {
                    Vec3 vec3d4 = this.getDeltaMovement();
                    this.setDeltaMovement(flag ? 0.0 : vec3d4.x, vec3d4.y, flag1 ? 0.0 : vec3d4.z);
                }
                if (this.canSimulateMovement()) {
                    Block block = iblockdata.getBlock();
                    if (vec3d.y != vec3d1.y) {
                        block.updateEntityMovementAfterFallOn(this.level(), this);
                    }
                }
                if (this.horizontalCollision && this.getBukkitEntity() instanceof Vehicle) {
                    Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                    org.bukkit.block.Block bl2 = this.level.getWorld().getBlockAt(Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ()));
                    if (vec3d.x > vec3d1.x) {
                        bl2 = bl2.getRelative(BlockFace.EAST);
                    } else if (vec3d.x < vec3d1.x) {
                        bl2 = bl2.getRelative(BlockFace.WEST);
                    } else if (vec3d.z > vec3d1.z) {
                        bl2 = bl2.getRelative(BlockFace.SOUTH);
                    } else if (vec3d.z < vec3d1.z) {
                        bl2 = bl2.getRelative(BlockFace.NORTH);
                    }
                    if (!bl2.getType().isAir()) {
                        VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl2);
                        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                }
                if ((!this.level().isClientSide() || this.isLocalInstanceAuthoritative()) && (entity_movementemission = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
                    this.applyMovementEmissionAndPlaySound(entity_movementemission, vec3d1, blockposition, iblockdata);
                }
                float f = this.getBlockSpeedFactor();
                this.setDeltaMovement(this.getDeltaMovement().multiply(f, 1.0, f));
                gameprofilerfiller.pop();
            }
        }
        SpigotTimings.entityMoveTimer.stopTiming();
    }

    private void applyMovementEmissionAndPlaySound(MovementEmission entity_movementemission, Vec3 vec3d, BlockPos blockposition, BlockState iblockdata) {
        float f = 0.6f;
        float f1 = (float)(vec3d.length() * (double)0.6f);
        float f2 = (float)(vec3d.horizontalDistance() * (double)0.6f);
        BlockPos blockposition1 = this.getOnPos();
        BlockState iblockdata1 = this.level().getBlockState(blockposition1);
        boolean flag = this.isStateClimbable(iblockdata1);
        this.moveDist += flag ? f1 : f2;
        this.flyDist += f1;
        if (this.moveDist > this.nextStep && !iblockdata1.isAir()) {
            boolean flag1 = blockposition1.equals(blockposition);
            boolean flag2 = this.vibrationAndSoundEffectsFromBlock(blockposition, iblockdata, entity_movementemission.emitsSounds(), flag1, vec3d);
            if (!flag1) {
                flag2 |= this.vibrationAndSoundEffectsFromBlock(blockposition1, iblockdata1, false, entity_movementemission.emitsEvents(), vec3d);
            }
            if (flag2) {
                this.nextStep = this.nextStep();
            } else if (this.isInWater()) {
                this.nextStep = this.nextStep();
                if (entity_movementemission.emitsSounds()) {
                    this.waterSwimSound();
                }
                if (entity_movementemission.emitsEvents()) {
                    this.gameEvent(GameEvent.SWIM);
                }
            }
        } else if (iblockdata1.isAir()) {
            this.processFlappingMovement();
        }
    }

    protected void applyEffectsFromBlocks() {
        this.finalMovementsThisTick.clear();
        this.finalMovementsThisTick.addAll(this.movementThisTick);
        this.movementThisTick.clear();
        if (this.finalMovementsThisTick.isEmpty()) {
            this.finalMovementsThisTick.add(new Movement(this.oldPosition(), this.position(), false));
        } else if (this.finalMovementsThisTick.getLast().to.distanceToSqr(this.position()) > 9.999999439624929E-11) {
            this.finalMovementsThisTick.add(new Movement(this.finalMovementsThisTick.getLast().to, this.position(), false));
        }
        this.applyEffectsFromBlocks(this.finalMovementsThisTick);
    }

    private void addMovementThisTick(Movement entity_c) {
        if (this.movementThisTick.size() >= 100) {
            Movement entity_c1 = this.movementThisTick.removeFirst();
            Movement entity_c2 = this.movementThisTick.removeFirst();
            Movement entity_c3 = new Movement(entity_c1.from(), entity_c2.to(), false);
            this.movementThisTick.addFirst(entity_c3);
        }
        this.movementThisTick.add(entity_c);
    }

    public void removeLatestMovementRecording() {
        if (!this.movementThisTick.isEmpty()) {
            this.movementThisTick.removeLast();
        }
    }

    protected void clearMovementThisTick() {
        this.movementThisTick.clear();
    }

    public void applyEffectsFromBlocks(Vec3 vec3d, Vec3 vec3d1) {
        this.applyEffectsFromBlocks(List.of(new Movement(vec3d, vec3d1, false)));
    }

    private void applyEffectsFromBlocks(List<Movement> list) {
        if (this.isAffectedByBlocks()) {
            boolean flag2;
            if (this.onGround()) {
                BlockPos blockposition = this.getOnPosLegacy();
                BlockState iblockdata = this.level().getBlockState(blockposition);
                iblockdata.getBlock().stepOn(this.level(), blockposition, iblockdata, this);
            }
            boolean flag = this.isOnFire();
            boolean flag1 = this.isFreezing();
            int i = this.getRemainingFireTicks();
            this.checkInsideBlocks(list, this.insideEffectCollector);
            this.insideEffectCollector.applyAndClear(this);
            if (this.isInRain()) {
                this.clearFire();
            }
            if (flag && !this.isOnFire() || flag1 && !this.isFreezing()) {
                this.playEntityOnFireExtinguishedSound();
            }
            boolean bl = flag2 = this.getRemainingFireTicks() > i;
            if (!(this.level.isClientSide || this.isOnFire() || flag2)) {
                this.setRemainingFireTicks(-this.getFireImmuneTicks());
            }
        }
    }

    protected boolean isAffectedByBlocks() {
        return !this.isRemoved() && !this.noPhysics;
    }

    private boolean isStateClimbable(BlockState iblockdata) {
        return iblockdata.is(BlockTags.CLIMBABLE) || iblockdata.is(Blocks.POWDER_SNOW);
    }

    private boolean vibrationAndSoundEffectsFromBlock(BlockPos blockposition, BlockState iblockdata, boolean flag, boolean flag1, Vec3 vec3d) {
        if (iblockdata.isAir()) {
            return false;
        }
        boolean flag2 = this.isStateClimbable(iblockdata);
        if ((this.onGround() || flag2 || this.isCrouching() && vec3d.y == 0.0 || this.isOnRails()) && !this.isSwimming()) {
            if (flag) {
                this.walkingStepSound(blockposition, iblockdata);
            }
            if (flag1) {
                this.level().gameEvent(GameEvent.STEP, this.position(), GameEvent.Context.of(this, iblockdata));
            }
            return true;
        }
        return false;
    }

    protected boolean isHorizontalCollisionMinor(Vec3 vec3d) {
        return false;
    }

    protected void playEntityOnFireExtinguishedSound() {
        if (!this.level.isClientSide()) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EXTINGUISH_FIRE, this.getSoundSource(), 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
    }

    public void extinguishFire() {
        if (this.isOnFire()) {
            this.playEntityOnFireExtinguishedSound();
        }
        this.clearFire();
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    @Deprecated
    public BlockPos getOnPosLegacy() {
        return this.getOnPos(0.2f);
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.500001f);
    }

    public BlockPos getOnPos() {
        return this.getOnPos(1.0E-5f);
    }

    protected BlockPos getOnPos(float f) {
        if (this.mainSupportingBlockPos.isPresent()) {
            BlockPos blockposition = this.mainSupportingBlockPos.get();
            if (f <= 1.0E-5f) {
                return blockposition;
            }
            BlockState iblockdata = this.level().getBlockState(blockposition);
            return ((double)f > 0.5 || !iblockdata.is(BlockTags.FENCES)) && !iblockdata.is(BlockTags.WALLS) && !(iblockdata.getBlock() instanceof FenceGateBlock) ? blockposition.atY(Mth.floor(this.position.y - (double)f)) : blockposition;
        }
        int i = Mth.floor(this.position.x);
        int j = Mth.floor(this.position.y - (double)f);
        int k = Mth.floor(this.position.z);
        return new BlockPos(i, j, k);
    }

    protected float getBlockJumpFactor() {
        float f = this.level().getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float f1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)f == 1.0 ? f1 : f;
    }

    protected float getBlockSpeedFactor() {
        BlockState iblockdata = this.level().getBlockState(this.blockPosition());
        float f = iblockdata.getBlock().getSpeedFactor();
        return !iblockdata.is(Blocks.WATER) && !iblockdata.is(Blocks.BUBBLE_COLUMN) ? ((double)f == 1.0 ? this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : f) : f;
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 vec3d, MoverType enummovetype) {
        return vec3d;
    }

    protected Vec3 limitPistonMovement(Vec3 vec3d) {
        if (vec3d.lengthSqr() <= 1.0E-7) {
            return vec3d;
        }
        long i = this.level().getGameTime();
        if (i != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = i;
        }
        if (vec3d.x != 0.0) {
            double d0 = this.applyPistonMovementRestriction(Direction.Axis.X, vec3d.x);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(d0, 0.0, 0.0);
        }
        if (vec3d.y != 0.0) {
            double d1 = this.applyPistonMovementRestriction(Direction.Axis.Y, vec3d.y);
            return Math.abs(d1) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, d1, 0.0);
        }
        if (vec3d.z != 0.0) {
            double d2 = this.applyPistonMovementRestriction(Direction.Axis.Z, vec3d.z);
            return Math.abs(d2) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, 0.0, d2);
        }
        return Vec3.ZERO;
    }

    private double applyPistonMovementRestriction(Direction.Axis enumdirection_enumaxis, double d0) {
        int i = enumdirection_enumaxis.ordinal();
        double d1 = Mth.clamp(d0 + this.pistonDeltas[i], -0.51, 0.51);
        d0 = d1 - this.pistonDeltas[i];
        this.pistonDeltas[i] = d1;
        return d0;
    }

    private Vec3 collide(Vec3 vec3d) {
        boolean flag3;
        AABB axisalignedbb = this.getBoundingBox();
        List<VoxelShape> list = this.level().getEntityCollisions(this, axisalignedbb.expandTowards(vec3d));
        Vec3 vec3d1 = vec3d.lengthSqr() == 0.0 ? vec3d : Entity.collideBoundingBox(this, vec3d, axisalignedbb, this.level(), list);
        boolean flag = vec3d.x != vec3d1.x;
        boolean flag1 = vec3d.y != vec3d1.y;
        boolean flag2 = vec3d.z != vec3d1.z;
        boolean bl = flag3 = flag1 && vec3d.y < 0.0;
        if (this.maxUpStep() > 0.0f && (flag3 || this.onGround()) && (flag || flag2)) {
            float[] afloat;
            AABB axisalignedbb1 = flag3 ? axisalignedbb.move(0.0, vec3d1.y, 0.0) : axisalignedbb;
            AABB axisalignedbb2 = axisalignedbb1.expandTowards(vec3d.x, this.maxUpStep(), vec3d.z);
            if (!flag3) {
                axisalignedbb2 = axisalignedbb2.expandTowards(0.0, -1.0E-5f, 0.0);
            }
            List<VoxelShape> list1 = Entity.collectColliders(this, this.level, list, axisalignedbb2);
            float f = (float)vec3d1.y;
            for (float f1 : afloat = Entity.collectCandidateStepUpHeights(axisalignedbb1, list1, this.maxUpStep(), f)) {
                Vec3 vec3d2 = Entity.collideWithShapes(new Vec3(vec3d.x, f1, vec3d.z), axisalignedbb1, list1);
                if (!(vec3d2.horizontalDistanceSqr() > vec3d1.horizontalDistanceSqr())) continue;
                double d0 = axisalignedbb.minY - axisalignedbb1.minY;
                return vec3d2.subtract(0.0, d0, 0.0);
            }
        }
        return vec3d1;
    }

    private static float[] collectCandidateStepUpHeights(AABB axisalignedbb, List<VoxelShape> list, float f, float f1) {
        FloatArraySet floatset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : list) {
            DoubleList doublelist = voxelshape.getCoords(Direction.Axis.Y);
            DoubleListIterator doublelistiterator = doublelist.iterator();
            while (doublelistiterator.hasNext()) {
                double d0 = doublelistiterator.next();
                float f2 = (float)(d0 - axisalignedbb.minY);
                if (!(f2 >= 0.0f) || f2 == f1) continue;
                if (f2 > f) continue block0;
                floatset.add(f2);
            }
        }
        float[] afloat = floatset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3 collideBoundingBox(@Nullable Entity entity, Vec3 vec3d, AABB axisalignedbb, Level world, List<VoxelShape> list) {
        List<VoxelShape> list1 = Entity.collectColliders(entity, world, list, axisalignedbb.expandTowards(vec3d));
        return Entity.collideWithShapes(vec3d, axisalignedbb, list1);
    }

    private static List<VoxelShape> collectColliders(@Nullable Entity entity, Level world, List<VoxelShape> list, AABB axisalignedbb) {
        boolean flag;
        ImmutableList.Builder immutablelist_builder = ImmutableList.builderWithExpectedSize((int)(list.size() + 1));
        if (!list.isEmpty()) {
            immutablelist_builder.addAll(list);
        }
        WorldBorder worldborder = world.getWorldBorder();
        boolean bl = flag = entity != null && worldborder.isInsideCloseToBorder(entity, axisalignedbb);
        if (flag) {
            immutablelist_builder.add((Object)worldborder.getCollisionShape());
        }
        immutablelist_builder.addAll(world.getBlockCollisions(entity, axisalignedbb));
        return immutablelist_builder.build();
    }

    private static Vec3 collideWithShapes(Vec3 vec3d, AABB axisalignedbb, List<VoxelShape> list) {
        if (list.isEmpty()) {
            return vec3d;
        }
        Vec3 vec3d1 = Vec3.ZERO;
        for (Direction.Axis enumdirection_enumaxis : Entity.axisStepOrder(vec3d)) {
            double d0 = vec3d.get(enumdirection_enumaxis);
            if (d0 == 0.0) continue;
            double d1 = Shapes.collide(enumdirection_enumaxis, axisalignedbb.move(vec3d1), list, d0);
            vec3d1 = vec3d1.with(enumdirection_enumaxis, d1);
        }
        return vec3d1;
    }

    private static Iterable<Direction.Axis> axisStepOrder(Vec3 vec3d) {
        return Math.abs(vec3d.x) < Math.abs(vec3d.z) ? YZX_AXIS_ORDER : YXZ_AXIS_ORDER;
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    public SoundEvent getSwimSound0() {
        return this.getSwimSound();
    }

    public SoundEvent getSwimSplashSound0() {
        return this.getSwimSplashSound();
    }

    public SoundEvent getSwimHighSpeedSplashSound0() {
        return this.getSwimHighSpeedSplashSound();
    }

    private void checkInsideBlocks(List<Movement> list, InsideBlockEffectApplier.StepBasedCollector insideblockeffectapplier_a) {
        if (this.isAffectedByBlocks()) {
            LongSet longset = this.visitedBlocks;
            for (Movement entity_c : list) {
                Vec3 vec3d = entity_c.from;
                Vec3 vec3d1 = entity_c.to().subtract(entity_c.from());
                if (entity_c.axisIndependant && vec3d1.lengthSqr() > 0.0) {
                    for (Direction.Axis enumdirection_enumaxis : Entity.axisStepOrder(vec3d1)) {
                        double d0 = vec3d1.get(enumdirection_enumaxis);
                        if (d0 == 0.0) continue;
                        Vec3 vec3d2 = vec3d.relative(enumdirection_enumaxis.getPositive(), d0);
                        this.checkInsideBlocks(vec3d, vec3d2, insideblockeffectapplier_a, longset);
                        vec3d = vec3d2;
                    }
                    continue;
                }
                this.checkInsideBlocks(entity_c.from(), entity_c.to(), insideblockeffectapplier_a, longset);
            }
            longset.clear();
        }
    }

    private void checkInsideBlocks(Vec3 vec3d, Vec3 vec3d1, InsideBlockEffectApplier.StepBasedCollector insideblockeffectapplier_a, LongSet longset) {
        AABB axisalignedbb = this.makeBoundingBox(vec3d1).deflate(1.0E-5f);
        BlockGetter.forEachBlockIntersectedBetween(vec3d, vec3d1, axisalignedbb, (blockposition, i) -> {
            boolean flag1;
            boolean flag;
            if (!this.isAlive()) {
                return false;
            }
            BlockState iblockdata = this.level().getBlockState(blockposition);
            if (iblockdata.isAir()) {
                this.debugBlockIntersection(blockposition, false, false);
                return true;
            }
            if (!longset.add(blockposition.asLong())) {
                return true;
            }
            VoxelShape voxelshape = iblockdata.getEntityInsideCollisionShape(this.level(), blockposition, this);
            boolean bl = flag = voxelshape == Shapes.block() || this.collidedWithShapeMovingFrom(vec3d, vec3d1, voxelshape.move(new Vec3(blockposition)).toAabbs());
            if (flag) {
                try {
                    insideblockeffectapplier_a.advanceStep(i);
                    iblockdata.entityInside(this.level(), blockposition, this, insideblockeffectapplier_a);
                    this.onInsideBlock(iblockdata);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Colliding entity with block");
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Block being collided with");
                    CrashReportCategory.populateBlockDetails(crashreportsystemdetails, this.level(), blockposition, iblockdata);
                    CrashReportCategory crashreportsystemdetails1 = crashreport.addCategory("Entity being checked for collision");
                    this.fillCrashReportCategory(crashreportsystemdetails1);
                    throw new ReportedException(crashreport);
                }
            }
            if (flag1 = this.collidedWithFluid(iblockdata.getFluidState(), blockposition, vec3d, vec3d1)) {
                insideblockeffectapplier_a.advanceStep(i);
                iblockdata.getFluidState().entityInside(this.level(), blockposition, this, insideblockeffectapplier_a);
            }
            this.debugBlockIntersection(blockposition, flag, flag1);
            return true;
        });
    }

    private void debugBlockIntersection(BlockPos blockposition, boolean flag, boolean flag1) {
    }

    public boolean collidedWithFluid(FluidState fluid, BlockPos blockposition, Vec3 vec3d, Vec3 vec3d1) {
        AABB axisalignedbb = fluid.getAABB(this.level(), blockposition);
        return axisalignedbb != null && this.collidedWithShapeMovingFrom(vec3d, vec3d1, List.of(axisalignedbb));
    }

    public boolean collidedWithShapeMovingFrom(Vec3 vec3d, Vec3 vec3d1, List<AABB> list) {
        AABB axisalignedbb = this.makeBoundingBox(vec3d);
        Vec3 vec3d2 = vec3d1.subtract(vec3d);
        return axisalignedbb.collidedAlongVector(vec3d2, list);
    }

    protected void onInsideBlock(BlockState iblockdata) {
    }

    public BlockPos adjustSpawnLocation(ServerLevel worldserver, BlockPos blockposition) {
        BlockPos blockposition1 = worldserver.getSharedSpawnPos();
        Vec3 vec3d = blockposition1.getCenter();
        int i = worldserver.getChunkAt(blockposition1).getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockposition1.getX(), blockposition1.getZ()) + 1;
        return BlockPos.containing(vec3d.x, i, vec3d.z);
    }

    public void gameEvent(Holder<GameEvent> holder, @Nullable Entity entity) {
        this.level().gameEvent(entity, holder, this.position);
    }

    public void gameEvent(Holder<GameEvent> holder) {
        this.gameEvent(holder, this);
    }

    private void walkingStepSound(BlockPos blockposition, BlockState iblockdata) {
        this.playStepSound(blockposition, iblockdata);
        if (this.shouldPlayAmethystStepSound(iblockdata)) {
            this.playAmethystStepSound();
        }
    }

    protected void waterSwimSound() {
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f = entity == this ? 0.35f : 0.4f;
        Vec3 vec3d = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.x * vec3d.x * (double)0.2f + vec3d.y * vec3d.y + vec3d.z * vec3d.z * (double)0.2f) * f);
        this.playSwimSound(f1);
    }

    protected BlockPos getPrimaryStepSoundBlockPos(BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.above();
        BlockState iblockdata = this.level().getBlockState(blockposition1);
        return !iblockdata.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) && !iblockdata.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS) ? blockposition : blockposition1;
    }

    protected void playCombinationStepSounds(BlockState iblockdata, BlockState iblockdata1) {
        SoundType soundeffecttype = iblockdata.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
        this.playMuffledStepSound(iblockdata1);
    }

    protected void playMuffledStepSound(BlockState iblockdata) {
        SoundType soundeffecttype = iblockdata.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.05f, soundeffecttype.getPitch() * 0.8f);
    }

    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
        SoundType soundeffecttype = iblockdata.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
    }

    private boolean shouldPlayAmethystStepSound(BlockState iblockdata) {
        return iblockdata.is(BlockTags.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20;
    }

    private void playAmethystStepSound() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.tickCount - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float f = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
        float f1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.playSound(SoundEvents.AMETHYST_BLOCK_CHIME, f1, f);
        this.lastCrystalSoundPlayTick = this.tickCount;
    }

    protected void playSwimSound(float f) {
        this.playSound(this.getSwimSound(), f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEvent soundeffect, float f, float f1) {
        if (!this.isSilent()) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), soundeffect, this.getSoundSource(), f, f1);
        }
    }

    public void playSound(SoundEvent soundeffect) {
        if (!this.isSilent()) {
            this.playSound(soundeffect, 1.0f, 1.0f);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean flag) {
        this.entityData.set(DATA_SILENT, flag);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean flag) {
        this.entityData.set(DATA_NO_GRAVITY, flag);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public final double getGravity() {
        return this.isNoGravity() ? 0.0 : this.getDefaultGravity();
    }

    protected void applyGravity() {
        double d0 = this.getGravity();
        if (d0 != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d0, 0.0));
        }
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean dampensVibrations() {
        return false;
    }

    public final void doCheckFallDamage(double d0, double d1, double d2, boolean flag) {
        if (!this.touchingUnloadedChunk()) {
            this.checkSupportingBlock(flag, new Vec3(d0, d1, d2));
            BlockPos blockposition = this.getOnPosLegacy();
            BlockState iblockdata = this.level().getBlockState(blockposition);
            this.checkFallDamage(d1, flag, iblockdata, blockposition);
        }
    }

    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
        if (!this.isInWater() && d0 < 0.0) {
            this.fallDistance -= (double)((float)d0);
        }
        if (flag) {
            if (this.fallDistance > 0.0) {
                iblockdata.getBlock().fallOn(this.level(), iblockdata, blockposition, this, this.fallDistance);
                this.level().gameEvent(GameEvent.HIT_GROUND, this.position, GameEvent.Context.of(this, this.mainSupportingBlockPos.map(blockposition1 -> this.level().getBlockState((BlockPos)blockposition1)).orElse(iblockdata)));
            }
            this.resetFallDistance();
        }
    }

    public boolean fireImmune() {
        return this.getType().fireImmune();
    }

    public boolean causeFallDamage(double d0, float f, DamageSource damagesource) {
        if (this.type.is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return false;
        }
        this.propagateFallToPassengers(d0, f, damagesource);
        return false;
    }

    protected void propagateFallToPassengers(double d0, float f, DamageSource damagesource) {
        if (this.isVehicle()) {
            for (Entity entity : this.getPassengers()) {
                entity.causeFallDamage(d0, f, damagesource);
            }
        }
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    boolean isInRain() {
        BlockPos blockposition = this.blockPosition();
        return this.level().isRainingAt(blockposition) || this.level().isRainingAt(BlockPos.containing(blockposition.getX(), this.getBoundingBox().maxY, blockposition.getZ()));
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInLiquid() {
        return this.isInWater() || this.isInLava();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public boolean isInClouds() {
        Optional<Integer> optional = this.level.dimensionType().cloudHeight();
        if (optional.isEmpty()) {
            return false;
        }
        int i = optional.get();
        if (this.getY() + (double)this.getBbHeight() < (double)i) {
            return false;
        }
        int j = i + 4;
        return this.getY() <= (double)j;
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level().getFluidState(this.blockPosition).is(FluidTags.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double d0 = this.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.updateFluidHeightAndDoFluidPushing(FluidTags.LAVA, d0);
        return this.isInWater() || flag;
    }

    void updateInWaterStateAndDoWaterCurrentPushing() {
        AbstractBoat abstractboat;
        Entity entity = this.getVehicle();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).isUnderWater()) {
            this.wasTouchingWater = false;
            return;
        }
        if (this.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        AbstractBoat abstractboat;
        this.wasEyeInWater = this.isEyeInFluid(FluidTags.WATER);
        this.fluidOnEyes.clear();
        double d0 = this.getEyeY();
        Entity entity = this.getVehicle();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).isUnderWater() && abstractboat.getBoundingBox().maxY >= d0 && abstractboat.getBoundingBox().minY <= d0) {
            return;
        }
        BlockPos blockposition = BlockPos.containing(this.getX(), d0, this.getZ());
        FluidState fluid = this.level().getFluidState(blockposition);
        double d1 = (float)blockposition.getY() + fluid.getHeight(this.level(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<Fluid>> stream = fluid.getTags();
            Set<TagKey<Fluid>> set = this.fluidOnEyes;
            Objects.requireNonNull(this.fluidOnEyes);
            stream.forEach(set::add);
        }
    }

    protected void doWaterSplashEffect() {
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f = entity == this ? 0.2f : 0.9f;
        Vec3 vec3d = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.x * vec3d.x * (double)0.2f + vec3d.y * vec3d.y + vec3d.z * vec3d.z * (double)0.2f) * f);
        if (f1 < 0.25f) {
            this.playSound(this.getSwimSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float f2 = Mth.floor(this.getY());
        int i = 0;
        while ((float)i < 1.0f + this.dimensions.width() * 20.0f) {
            double d0 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            double d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + d0, f2 + 1.0f, this.getZ() + d1, vec3d.x, vec3d.y - this.random.nextDouble() * (double)0.2f, vec3d.z);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + this.dimensions.width() * 20.0f) {
            double d2 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            double d3 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.SPLASH, this.getX() + d2, f2 + 1.0f, this.getZ() + d3, vec3d.x, vec3d.y, vec3d.z);
            ++j;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    @Deprecated
    protected BlockState getBlockStateOnLegacy() {
        return this.level().getBlockState(this.getOnPosLegacy());
    }

    public BlockState getBlockStateOn() {
        return this.level().getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        BlockPos blockposition = this.getOnPosLegacy();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (iblockdata.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3d = this.getDeltaMovement();
            BlockPos blockposition1 = this.blockPosition();
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            double d1 = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            if (blockposition1.getX() != blockposition.getX()) {
                d0 = Mth.clamp(d0, (double)blockposition.getX(), (double)blockposition.getX() + 1.0);
            }
            if (blockposition1.getZ() != blockposition.getZ()) {
                d1 = Mth.clamp(d1, (double)blockposition.getZ(), (double)blockposition.getZ() + 1.0);
            }
            this.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, iblockdata), d0, this.getY() + 0.1, d1, vec3d.x * -4.0, 1.5, vec3d.z * -4.0);
        }
    }

    public boolean isEyeInFluid(TagKey<Fluid> tagkey) {
        return this.fluidOnEyes.contains(tagkey);
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(FluidTags.LAVA) > 0.0;
    }

    public void moveRelative(float f, Vec3 vec3d) {
        Vec3 vec3d1 = Entity.getInputVector(vec3d, f, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add(vec3d1));
    }

    protected static Vec3 getInputVector(Vec3 vec3d, float f, float f1) {
        double d0 = vec3d.lengthSqr();
        if (d0 < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 vec3d1 = (d0 > 1.0 ? vec3d.normalize() : vec3d).scale(f);
        float f2 = Mth.sin(f1 * ((float)Math.PI / 180));
        float f3 = Mth.cos(f1 * ((float)Math.PI / 180));
        return new Vec3(vec3d1.x * (double)f3 - vec3d1.z * (double)f2, vec3d1.y, vec3d1.z * (double)f3 + vec3d1.x * (double)f2);
    }

    @Deprecated
    public float getLightLevelDependentMagicValue() {
        return this.level().hasChunkAt(this.getBlockX(), this.getBlockZ()) ? this.level().getLightLevelDependentMagicValue(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())) : 0.0f;
    }

    public void absSnapTo(double d0, double d1, double d2, float f, float f1) {
        this.absSnapTo(d0, d1, d2);
        this.absSnapRotationTo(f, f1);
    }

    public void absSnapRotationTo(float f, float f1) {
        this.setYRot(f % 360.0f);
        this.setXRot(Mth.clamp(f1, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void absSnapTo(double d0, double d1, double d2) {
        double d3 = Mth.clamp(d0, -3.0E7, 3.0E7);
        double d4 = Mth.clamp(d2, -3.0E7, 3.0E7);
        this.xo = d3;
        this.yo = d1;
        this.zo = d4;
        this.setPos(d3, d1, d4);
        if (this.valid) {
            this.level.getChunk((int)Math.floor(this.getX()) >> 4, (int)Math.floor(this.getZ()) >> 4);
        }
    }

    public void snapTo(Vec3 vec3d) {
        this.snapTo(vec3d.x, vec3d.y, vec3d.z);
    }

    public void snapTo(double d0, double d1, double d2) {
        this.snapTo(d0, d1, d2, this.getYRot(), this.getXRot());
    }

    public void snapTo(BlockPos blockposition, float f, float f1) {
        this.snapTo(blockposition.getBottomCenter(), f, f1);
    }

    public void snapTo(Vec3 vec3d, float f, float f1) {
        this.snapTo(vec3d.x, vec3d.y, vec3d.z, f, f1);
    }

    public void snapTo(double d0, double d1, double d2, float f, float f1) {
        this.setPosRaw(d0, d1, d2);
        this.setYRot(f);
        this.setXRot(f1);
        this.setOldPosAndRot();
        this.reapplyPosition();
    }

    public final void setOldPosAndRot() {
        this.setOldPos();
        this.setOldRot();
    }

    public final void setOldPosAndRot(Vec3 vec3d, float f, float f1) {
        this.setOldPos(vec3d);
        this.setOldRot(f, f1);
    }

    protected void setOldPos() {
        this.setOldPos(this.position);
    }

    public void setOldRot() {
        this.setOldRot(this.getYRot(), this.getXRot());
    }

    private void setOldPos(Vec3 vec3d) {
        this.xo = this.xOld = vec3d.x;
        this.yo = this.yOld = vec3d.y;
        this.zo = this.zOld = vec3d.z;
    }

    private void setOldRot(float f, float f1) {
        this.yRotO = f;
        this.xRotO = f1;
    }

    public final Vec3 oldPosition() {
        return new Vec3(this.xOld, this.yOld, this.zOld);
    }

    public float distanceTo(Entity entity) {
        float f = (float)(this.getX() - entity.getX());
        float f1 = (float)(this.getY() - entity.getY());
        float f2 = (float)(this.getZ() - entity.getZ());
        return Mth.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public double distanceToSqr(double d0, double d1, double d2) {
        double d3 = this.getX() - d0;
        double d4 = this.getY() - d1;
        double d5 = this.getZ() - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double distanceToSqr(Entity entity) {
        return this.distanceToSqr(entity.position());
    }

    public double distanceToSqr(Vec3 vec3d) {
        double d0 = this.getX() - vec3d.x;
        double d1 = this.getY() - vec3d.y;
        double d2 = this.getZ() - vec3d.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void playerTouch(Player entityhuman) {
    }

    public void push(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.isPassengerOfSameVehicle(entity) && !entity.noPhysics && !this.noPhysics && (d2 = Mth.absMax(d0 = entity.getX() - this.getX(), d1 = entity.getZ() - this.getZ())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle() && this.isPushable()) {
                this.push(-d0, 0.0, -d1);
            }
            if (!entity.isVehicle() && entity.isPushable()) {
                entity.push(d0, 0.0, d1);
            }
        }
    }

    public void push(Vec3 vec3d) {
        this.push(vec3d.x, vec3d.y, vec3d.z);
    }

    public void push(double d0, double d1, double d2) {
        this.setDeltaMovement(this.getDeltaMovement().add(d0, d1, d2));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    @Deprecated
    public final void hurt(DamageSource damagesource, float f) {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.hurtServer(worldserver, damagesource, f);
        }
    }

    @Deprecated
    public final boolean hurtOrSimulate(DamageSource damagesource, float f) {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            return this.hurtServer(worldserver, damagesource, f);
        }
        return this.hurtClient(damagesource);
    }

    public abstract boolean hurtServer(ServerLevel var1, DamageSource var2, float var3);

    public boolean hurtClient(DamageSource damagesource) {
        return false;
    }

    public final Vec3 getViewVector(float f) {
        return this.calculateViewVector(this.getViewXRot(f), this.getViewYRot(f));
    }

    public Direction getNearestViewDirection() {
        return Direction.getApproximateNearest(this.getViewVector(1.0f));
    }

    public float getViewXRot(float f) {
        return this.getXRot(f);
    }

    public float getViewYRot(float f) {
        return this.getYRot(f);
    }

    public float getXRot(float f) {
        return f == 1.0f ? this.getXRot() : Mth.lerp(f, this.xRotO, this.getXRot());
    }

    public float getYRot(float f) {
        return f == 1.0f ? this.getYRot() : Mth.rotLerp(f, this.yRotO, this.getYRot());
    }

    public final Vec3 calculateViewVector(float f, float f1) {
        float f2 = f * ((float)Math.PI / 180);
        float f3 = -f1 * ((float)Math.PI / 180);
        float f4 = Mth.cos(f3);
        float f5 = Mth.sin(f3);
        float f6 = Mth.cos(f2);
        float f7 = Mth.sin(f2);
        return new Vec3(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3 getUpVector(float f) {
        return this.calculateUpVector(this.getViewXRot(f), this.getViewYRot(f));
    }

    protected final Vec3 calculateUpVector(float f, float f1) {
        return this.calculateViewVector(f - 90.0f, f1);
    }

    public final Vec3 getEyePosition() {
        return new Vec3(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3 getEyePosition(float f) {
        double d0 = Mth.lerp((double)f, this.xo, this.getX());
        double d1 = Mth.lerp((double)f, this.yo, this.getY()) + (double)this.getEyeHeight();
        double d2 = Mth.lerp((double)f, this.zo, this.getZ());
        return new Vec3(d0, d1, d2);
    }

    public Vec3 getLightProbePosition(float f) {
        return this.getEyePosition(f);
    }

    public final Vec3 getPosition(float f) {
        double d0 = Mth.lerp((double)f, this.xo, this.getX());
        double d1 = Mth.lerp((double)f, this.yo, this.getY());
        double d2 = Mth.lerp((double)f, this.zo, this.getZ());
        return new Vec3(d0, d1, d2);
    }

    public HitResult pick(double d0, float f, boolean flag) {
        Vec3 vec3d = this.getEyePosition(f);
        Vec3 vec3d1 = this.getViewVector(f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * d0, vec3d1.y * d0, vec3d1.z * d0);
        return this.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, flag ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, this));
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive() && this.isPickable();
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable();
    }

    public void awardKillScore(Entity entity, DamageSource damagesource) {
        if (entity instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_KILLED_PLAYER.trigger((ServerPlayer)entity, this, damagesource);
        }
    }

    public boolean shouldRender(double d0, double d1, double d2) {
        double d3 = this.getX() - d0;
        double d4 = this.getY() - d1;
        double d5 = this.getZ() - d2;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.shouldRenderAtSqrDistance(d6);
    }

    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * viewScale) * d1;
    }

    public boolean saveAsPassenger(ValueOutput valueoutput) {
        return this.saveAsPassenger(valueoutput, true);
    }

    public boolean saveAsPassenger(ValueOutput valueoutput, boolean includeAll) {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        String s = this.getEncodeId();
        if (!this.persist || s == null) {
            return false;
        }
        valueoutput.putString(TAG_ID, s);
        this.saveWithoutId(valueoutput, includeAll);
        return true;
    }

    public boolean save(ValueOutput valueoutput) {
        return this.isPassenger() ? false : this.saveAsPassenger(valueoutput);
    }

    public void saveWithoutId(ValueOutput valueoutput) {
        this.saveWithoutId(valueoutput, true);
    }

    public void saveWithoutId(ValueOutput valueoutput, boolean includeAll) {
        try {
            int i;
            if (includeAll) {
                if (this.vehicle != null) {
                    valueoutput.store(TAG_POS, Vec3.CODEC, new Vec3(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
                } else {
                    valueoutput.store(TAG_POS, Vec3.CODEC, this.position());
                }
            }
            valueoutput.store(TAG_MOTION, Vec3.CODEC, this.getDeltaMovement());
            if (Float.isNaN(this.yRot)) {
                this.yRot = 0.0f;
            }
            if (Float.isNaN(this.xRot)) {
                this.xRot = 0.0f;
            }
            valueoutput.store(TAG_ROTATION, Vec2.CODEC, new Vec2(this.getYRot(), this.getXRot()));
            valueoutput.putDouble(TAG_FALL_DISTANCE, this.fallDistance);
            valueoutput.putShort(TAG_FIRE, (short)this.remainingFireTicks);
            valueoutput.putShort(TAG_AIR, (short)this.getAirSupply());
            valueoutput.putBoolean(TAG_ON_GROUND, this.onGround());
            valueoutput.putBoolean(TAG_INVULNERABLE, this.invulnerable);
            valueoutput.putInt(TAG_PORTAL_COOLDOWN, this.portalCooldown);
            if (includeAll) {
                valueoutput.store(TAG_UUID, UUIDUtil.CODEC, this.getUUID());
                valueoutput.putLong("WorldUUIDLeast", ((ServerLevel)this.level).getWorld().getUID().getLeastSignificantBits());
                valueoutput.putLong("WorldUUIDMost", ((ServerLevel)this.level).getWorld().getUID().getMostSignificantBits());
            }
            valueoutput.putInt("Bukkit.updateLevel", 2);
            if (!this.persist) {
                valueoutput.putBoolean("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                valueoutput.putBoolean("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                valueoutput.putBoolean("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                valueoutput.putInt("Bukkit.MaxAirSupply", this.getMaxAirSupply());
            }
            valueoutput.putInt("Spigot.ticksLived", this.tickCount);
            valueoutput.storeNullable("CustomName", ComponentSerialization.CODEC, this.getCustomName());
            if (this.isCustomNameVisible()) {
                valueoutput.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                valueoutput.putBoolean(TAG_SILENT, this.isSilent());
            }
            if (this.isNoGravity()) {
                valueoutput.putBoolean(TAG_NO_GRAVITY, this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                valueoutput.putBoolean(TAG_GLOWING, true);
            }
            if ((i = this.getTicksFrozen()) > 0) {
                valueoutput.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                valueoutput.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                valueoutput.store("Tags", TAG_LIST_CODEC, List.copyOf(this.tags));
            }
            if (!this.customData.isEmpty()) {
                valueoutput.store(TAG_DATA, CustomData.CODEC, this.customData);
            }
            this.addAdditionalSaveData(valueoutput, includeAll);
            if (this.isVehicle()) {
                ValueOutput.ValueOutputList valueoutput_b = valueoutput.childrenList(TAG_PASSENGERS);
                for (Entity entity : this.getPassengers()) {
                    ValueOutput valueoutput1;
                    if (entity.saveAsPassenger(valueoutput1 = valueoutput_b.addChild(), includeAll)) continue;
                    valueoutput_b.discardLast();
                }
                if (valueoutput_b.isEmpty()) {
                    valueoutput.discard(TAG_PASSENGERS);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(valueoutput);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Saving entity NBT");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Entity being saved");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(ValueInput valueinput) {
        try {
            Vec3 vec3d = valueinput.read(TAG_POS, Vec3.CODEC).orElse(Vec3.ZERO);
            Vec3 vec3d1 = valueinput.read(TAG_MOTION, Vec3.CODEC).orElse(Vec3.ZERO);
            Vec2 vec2f = valueinput.read(TAG_ROTATION, Vec2.CODEC).orElse(Vec2.ZERO);
            this.setDeltaMovement(Math.abs(vec3d1.x) > 10.0 ? 0.0 : vec3d1.x, Math.abs(vec3d1.y) > 10.0 ? 0.0 : vec3d1.y, Math.abs(vec3d1.z) > 10.0 ? 0.0 : vec3d1.z);
            this.hasImpulse = true;
            double d0 = 3.0000512E7;
            this.setPosRaw(Mth.clamp(vec3d.x, -3.0000512E7, 3.0000512E7), Mth.clamp(vec3d.y, -2.0E7, 2.0E7), Mth.clamp(vec3d.z, -3.0000512E7, 3.0000512E7));
            this.setYRot(vec2f.x);
            this.setXRot(vec2f.y);
            this.setOldPosAndRot();
            this.setYHeadRot(this.getYRot());
            this.setYBodyRot(this.getYRot());
            this.fallDistance = valueinput.getDoubleOr(TAG_FALL_DISTANCE, 0.0);
            this.remainingFireTicks = valueinput.getShortOr(TAG_FIRE, (short)0);
            this.setAirSupply(valueinput.getIntOr(TAG_AIR, this.getMaxAirSupply()));
            this.onGround = valueinput.getBooleanOr(TAG_ON_GROUND, false);
            this.invulnerable = valueinput.getBooleanOr(TAG_INVULNERABLE, false);
            this.portalCooldown = valueinput.getIntOr(TAG_PORTAL_COOLDOWN, 0);
            valueinput.read(TAG_UUID, UUIDUtil.CODEC).ifPresent(uuid -> {
                this.uuid = uuid;
                this.stringUUID = this.uuid.toString();
            });
            if (!Double.isFinite(this.getX()) || !Double.isFinite(this.getY()) || !Double.isFinite(this.getZ())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.getYRot()) || !Double.isFinite(this.getXRot())) throw new IllegalStateException("Entity has invalid rotation");
            this.reapplyPosition();
            this.setRot(this.getYRot(), this.getXRot());
            this.setCustomName(valueinput.read("CustomName", ComponentSerialization.CODEC).orElse(null));
            this.setCustomNameVisible(valueinput.getBooleanOr("CustomNameVisible", false));
            this.setSilent(valueinput.getBooleanOr(TAG_SILENT, false));
            this.setNoGravity(valueinput.getBooleanOr(TAG_NO_GRAVITY, false));
            this.setGlowingTag(valueinput.getBooleanOr(TAG_GLOWING, false));
            this.setTicksFrozen(valueinput.getIntOr("TicksFrozen", 0));
            this.hasVisualFire = valueinput.getBooleanOr("HasVisualFire", false);
            this.customData = valueinput.read(TAG_DATA, CustomData.CODEC).orElse(CustomData.EMPTY);
            this.tags.clear();
            Optional<List<String>> optional = valueinput.read("Tags", TAG_LIST_CODEC);
            Set<String> set = this.tags;
            Objects.requireNonNull(this.tags);
            optional.ifPresent(set::addAll);
            this.readAdditionalSaveData(valueinput);
            if (this.repositionEntityAfterLoad()) {
                this.reapplyPosition();
            }
            if (this instanceof LivingEntity) {
                this.tickCount = valueinput.getIntOr("Spigot.ticksLived", this.tickCount);
            }
            this.persist = valueinput.getBooleanOr("Bukkit.persist", this.persist);
            this.visibleByDefault = valueinput.getBooleanOr("Bukkit.visibleByDefault", this.visibleByDefault);
            this.maxAirTicks = valueinput.getIntOr("Bukkit.MaxAirSupply", this.maxAirTicks);
            if (this instanceof ServerPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = valueinput.getStringOr("world", "");
                Optional<Long> most = valueinput.getLong("WorldUUIDMost");
                Optional<Long> least = valueinput.getLong("WorldUUIDLeast");
                if (most.isPresent() && least.isPresent()) {
                    UUID uid = new UUID(most.get(), least.get());
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                if (bworld == null) {
                    bworld = ((CraftServer)server).getServer().getLevel(Level.OVERWORLD).getWorld();
                }
                ((ServerPlayer)this).setLevel(bworld == null ? null : ((CraftWorld)bworld).getHandle());
            }
            this.getBukkitEntity().readBukkitValues(valueinput);
            boolean bukkitInvisible = valueinput.getBooleanOr("Bukkit.invisible", false);
            if (!bukkitInvisible) return;
            this.setInvisible(bukkitInvisible);
            this.persistentInvisibility = bukkitInvisible;
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Loading entity NBT");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Entity being loaded");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @Nullable
    public final String getEncodeId() {
        EntityType<?> entitytypes = this.getType();
        ResourceLocation minecraftkey = EntityType.getKey(entitytypes);
        return entitytypes.canSerialize() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected void addAdditionalSaveData(ValueOutput valueoutput, boolean includeAll) {
        this.addAdditionalSaveData(valueoutput);
    }

    protected abstract void readAdditionalSaveData(ValueInput var1);

    protected abstract void addAdditionalSaveData(ValueOutput var1);

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel worldserver, ItemLike imaterial) {
        return this.spawnAtLocation(worldserver, imaterial, 0);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel worldserver, ItemLike imaterial, int i) {
        return this.spawnAtLocation(worldserver, new ItemStack(imaterial), (float)i);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel worldserver, ItemStack itemstack) {
        return this.spawnAtLocation(worldserver, itemstack, 0.0f);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel worldserver, ItemStack itemstack, Vec3 vec3d) {
        if (itemstack.isEmpty()) {
            return null;
        }
        if (this instanceof LivingEntity && !((LivingEntity)this).forceDrops) {
            ((LivingEntity)this).drops.add(CraftItemStack.asBukkitCopy(itemstack));
            return null;
        }
        ItemEntity entityitem = new ItemEntity(worldserver, this.getX() + vec3d.x, this.getY() + vec3d.y, this.getZ() + vec3d.z, itemstack);
        entityitem.setDefaultPickUpDelay();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        worldserver.addFreshEntity(entityitem);
        return entityitem;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel worldserver, ItemStack itemstack, float f) {
        return this.spawnAtLocation(worldserver, itemstack, new Vec3(0.0, f, 0.0));
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        float f = this.dimensions.width() * 0.8f;
        AABB axisalignedbb = AABB.ofSize(this.getEyePosition(), f, 1.0E-6, f);
        return BlockPos.betweenClosedStream(axisalignedbb).anyMatch(blockposition -> {
            BlockState iblockdata = this.level().getBlockState((BlockPos)blockposition);
            return !iblockdata.isAir() && iblockdata.isSuffocating(this.level(), (BlockPos)blockposition) && Shapes.joinIsNotEmpty(iblockdata.getCollisionShape(this.level(), (BlockPos)blockposition).move((Vec3i)blockposition), Shapes.create(axisalignedbb), BooleanOp.AND);
        });
    }

    public InteractionResult interact(Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack;
        List<Leashable> list;
        LivingEntity entityliving;
        Leashable leashable;
        Entity entity;
        if (!this.level().isClientSide && entityhuman.isSecondaryUseActive() && (entity = this) instanceof Leashable && (leashable = (Leashable)((Object)entity)).canBeLeashed() && this.isAlive() && (!(this instanceof LivingEntity) || !(entityliving = (LivingEntity)this).isBaby()) && !(list = Leashable.leashableInArea(this, leashable1 -> leashable1.getLeashHolder() == entityhuman)).isEmpty()) {
            boolean flag = false;
            for (Leashable leashable12 : list) {
                if (!leashable12.canHaveALeashAttachedTo(this)) continue;
                leashable12.setLeashedTo(this, true);
                flag = true;
            }
            if (flag) {
                this.level().gameEvent(GameEvent.ENTITY_ACTION, this.blockPosition(), GameEvent.Context.of(entityhuman));
                this.playSound(SoundEvents.LEAD_TIED);
                return InteractionResult.SUCCESS_SERVER.withoutItem();
            }
        }
        if ((itemstack = entityhuman.getItemInHand(enumhand)).is(Items.SHEARS) && this.shearOffAllLeashConnections(entityhuman)) {
            itemstack.hurtAndBreak(1, (LivingEntity)entityhuman, enumhand);
            return InteractionResult.SUCCESS;
        }
        if (this instanceof Mob) {
            Mob entityinsentient = (Mob)this;
            if (itemstack.is(Items.SHEARS) && entityinsentient.canShearEquipment(entityhuman) && !entityhuman.isSecondaryUseActive() && this.attemptToShearEquipment(entityhuman, enumhand, itemstack, entityinsentient)) {
                return InteractionResult.SUCCESS;
            }
        }
        if (this.isAlive() && this instanceof Leashable) {
            Leashable leashable2 = (Leashable)((Object)this);
            if (leashable2.getLeashHolder() == entityhuman) {
                if (!this.level().isClientSide()) {
                    if (CraftEventFactory.callPlayerUnleashEntityEvent(this, entityhuman, enumhand).isCancelled()) {
                        ((ServerPlayer)entityhuman).connection.send(new ClientboundSetEntityLinkPacket(this, leashable2.getLeashHolder()));
                        return InteractionResult.PASS;
                    }
                    if (entityhuman.hasInfiniteMaterials()) {
                        leashable2.removeLeash();
                    } else {
                        leashable2.dropLeash();
                    }
                    this.gameEvent(GameEvent.ENTITY_INTERACT, entityhuman);
                    this.playSound(SoundEvents.LEAD_UNTIED);
                }
                return InteractionResult.SUCCESS.withoutItem();
            }
            ItemStack itemstack1 = entityhuman.getItemInHand(enumhand);
            if (itemstack1.is(Items.LEAD) && !(leashable2.getLeashHolder() instanceof Player)) {
                if (!this.level().isClientSide() && leashable2.canHaveALeashAttachedTo(entityhuman)) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, entityhuman, entityhuman, enumhand).isCancelled()) {
                        ((ServerPlayer)entityhuman).resendItemInHands();
                        ((ServerPlayer)entityhuman).connection.send(new ClientboundSetEntityLinkPacket(this, leashable2.getLeashHolder()));
                        return InteractionResult.PASS;
                    }
                    if (leashable2.isLeashed()) {
                        leashable2.dropLeash();
                    }
                    leashable2.setLeashedTo(entityhuman, true);
                    this.playSound(SoundEvents.LEAD_TIED);
                    itemstack1.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean shearOffAllLeashConnections(@Nullable Player entityhuman) {
        Level world;
        boolean flag = this.dropAllLeashConnections(entityhuman, EntityUnleashEvent.UnleashReason.SHEAR);
        if (flag && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            worldserver.playSound(null, this.blockPosition(), SoundEvents.SHEARS_SNIP, entityhuman != null ? entityhuman.getSoundSource() : this.getSoundSource());
        }
        return flag;
    }

    public boolean dropAllLeashConnections(@Nullable Player entityhuman) {
        return this.dropAllLeashConnections(entityhuman, EntityUnleashEvent.UnleashReason.UNKNOWN);
    }

    public boolean dropAllLeashConnections(@Nullable Player entityhuman, EntityUnleashEvent.UnleashReason reason) {
        Leashable leashable;
        List<Leashable> list = Leashable.leashableLeashedTo(this);
        boolean flag = !list.isEmpty();
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).isLeashed()) {
            this.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), reason));
            leashable.dropLeash();
            flag = true;
        }
        for (Leashable leashable1 : list) {
            if (leashable1 instanceof Entity) {
                Entity entity2 = (Entity)((Object)leashable1);
                this.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)entity2.getBukkitEntity(), reason));
            }
            leashable1.dropLeash();
        }
        if (flag) {
            this.gameEvent(GameEvent.SHEAR, entityhuman);
            return true;
        }
        return false;
    }

    private boolean attemptToShearEquipment(Player entityhuman, InteractionHand enumhand, ItemStack itemstack, Mob entityinsentient) {
        for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
            ItemStack itemstack1 = entityinsentient.getItemBySlot(enumitemslot);
            Equippable equippable = itemstack1.get(DataComponents.EQUIPPABLE);
            if (equippable == null || !equippable.canBeSheared() || EnchantmentHelper.has(itemstack1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !entityhuman.isCreative()) continue;
            itemstack.hurtAndBreak(1, (LivingEntity)entityhuman, LivingEntity.getSlotForHand(enumhand));
            Vec3 vec3d = this.dimensions.attachments().getAverage(EntityAttachment.PASSENGER);
            entityinsentient.setItemSlotAndDropWhenKilled(enumitemslot, ItemStack.EMPTY);
            this.gameEvent(GameEvent.SHEAR, entityhuman);
            this.playSound(equippable.shearingSound().value());
            Level world = this.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                this.forceDrops = true;
                this.spawnAtLocation(worldserver, itemstack1, vec3d);
                this.forceDrops = false;
                CriteriaTriggers.PLAYER_SHEARED_EQUIPMENT.trigger((ServerPlayer)entityhuman, itemstack1, entityinsentient);
            }
            return true;
        }
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return entity.canBeCollidedWith(this) && !this.isPassengerOfSameVehicle(entity);
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3.ZERO);
        this.tick();
        if (this.isPassenger()) {
            this.getVehicle().positionRider(this);
        }
    }

    public final void positionRider(Entity entity) {
        if (this.hasPassenger(entity)) {
            this.positionRider(entity, Entity::setPos);
        }
    }

    protected void positionRider(Entity entity, MoveFunction entity_movefunction) {
        Vec3 vec3d = this.getPassengerRidingPosition(entity);
        Vec3 vec3d1 = entity.getVehicleAttachmentPoint(this);
        entity_movefunction.accept(entity, vec3d.x - vec3d1.x, vec3d.y - vec3d1.y, vec3d.z - vec3d1.z);
    }

    public void onPassengerTurned(Entity entity) {
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        return this.getAttachments().get(EntityAttachment.VEHICLE, 0, this.yRot);
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.dimensions, 1.0f));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entitysize, float f) {
        return Entity.getDefaultPassengerAttachmentPoint(this, entity, entitysize.attachments());
    }

    protected static Vec3 getDefaultPassengerAttachmentPoint(Entity entity, Entity entity1, EntityAttachments entityattachments) {
        int i = entity.getPassengers().indexOf(entity1);
        return entityattachments.getClamped(EntityAttachment.PASSENGER, i, entity.yRot);
    }

    public boolean startRiding(Entity entity) {
        return this.startRiding(entity, false);
    }

    public boolean showVehicleHealth() {
        return this instanceof LivingEntity;
    }

    public boolean startRiding(Entity entity, boolean flag) {
        if (entity == this.vehicle) {
            return false;
        }
        if (!entity.couldAcceptPassenger()) {
            return false;
        }
        if (!(flag || this.level().isClientSide() || entity.type.canSerialize())) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.vehicle != null) {
            if (entity1.vehicle == this) {
                return false;
            }
            entity1 = entity1.vehicle;
        }
        if (flag || this.canRide(entity) && entity.canAddPassenger(this)) {
            EntityMountEvent event;
            if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof org.bukkit.entity.LivingEntity) {
                event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
                if (this.valid) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return false;
                }
            }
            event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
            if (this.isPassenger()) {
                this.stopRiding();
            }
            this.setPose(Pose.STANDING);
            this.vehicle = entity;
            this.vehicle.addPassenger(this);
            entity.getIndirectPassengersStream().filter(entity2 -> entity2 instanceof ServerPlayer).forEach(entity2 -> CriteriaTriggers.START_RIDING_TRIGGER.trigger((ServerPlayer)entity2));
            return true;
        }
        return false;
    }

    protected boolean canRide(Entity entity) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    public void ejectPassengers() {
        for (int i = this.passengers.size() - 1; i >= 0; --i) {
            ((Entity)this.passengers.get(i)).stopRiding();
        }
    }

    public void removeVehicle() {
        if (this.vehicle != null) {
            Entity entity = this.vehicle;
            this.vehicle = null;
            if (!entity.removePassenger(this)) {
                this.vehicle = entity;
            }
        }
    }

    public void stopRiding() {
        this.removeVehicle();
    }

    protected void addPassenger(Entity entity) {
        if (entity.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.passengers);
            if (!this.level().isClientSide && entity instanceof Player && !(this.getFirstPassenger() instanceof Player)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.passengers = ImmutableList.copyOf((Collection)list);
        }
        this.gameEvent(GameEvent.ENTITY_MOUNT, entity);
    }

    protected boolean removePassenger(Entity entity) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof org.bukkit.entity.LivingEntity) {
            CraftEntity craftn;
            Entity n;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.LivingEntity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.boardingCooldown = 60;
        this.gameEvent(GameEvent.ENTITY_DISMOUNT, entity);
        return true;
    }

    protected boolean canAddPassenger(Entity entity) {
        return this.passengers.isEmpty();
    }

    protected boolean couldAcceptPassenger() {
        return true;
    }

    public final boolean isInterpolating() {
        return this.getInterpolation() != null && this.getInterpolation().hasActiveInterpolation();
    }

    public final void moveOrInterpolateTo(Vec3 vec3d, float f, float f1) {
        InterpolationHandler interpolationhandler = this.getInterpolation();
        if (interpolationhandler != null) {
            interpolationhandler.interpolateTo(vec3d, f, f1);
        } else {
            this.setPos(vec3d);
            this.setRot(f, f1);
        }
    }

    @Nullable
    public InterpolationHandler getInterpolation() {
        return null;
    }

    public void lerpHeadTo(float f, int i) {
        this.setYHeadRot(f);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3 getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec3 getHandHoldingItemAngle(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof Player)) {
            return Vec3.ZERO;
        }
        Player entityhuman = (Player)entity;
        boolean flag = entityhuman.getOffhandItem().is(item) && !entityhuman.getMainHandItem().is(item);
        HumanoidArm enummainhand = flag ? entityhuman.getMainArm().getOpposite() : entityhuman.getMainArm();
        return this.calculateViewVector(0.0f, this.getYRot() + (float)(enummainhand == HumanoidArm.RIGHT ? 80 : -80)).scale(0.5);
    }

    public Vec2 getRotationVector() {
        return new Vec2(this.getXRot(), this.getYRot());
    }

    public Vec3 getForward() {
        return Vec3.directionFromRotation(this.getRotationVector());
    }

    public void setAsInsidePortal(Portal portal, BlockPos blockposition) {
        if (this.isOnPortalCooldown()) {
            this.setPortalCooldown();
        } else if (this.portalProcess != null && this.portalProcess.isSamePortal(portal)) {
            if (!this.portalProcess.isInsidePortalThisTick()) {
                this.portalProcess.updateEntryPosition(blockposition.immutable());
                this.portalProcess.setAsInsidePortalThisTick(true);
            }
        } else {
            this.portalProcess = new PortalProcessor(portal, blockposition.immutable());
        }
    }

    protected void handlePortal() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.processPortalCooldown();
            if (this.portalProcess != null) {
                if (this.portalProcess.processPortalTeleportation(worldserver, this, this.canUsePortal(false))) {
                    ProfilerFiller gameprofilerfiller = Profiler.get();
                    gameprofilerfiller.push("portal");
                    this.setPortalCooldown();
                    TeleportTransition teleporttransition = this.portalProcess.getPortalDestination(worldserver, this);
                    if (teleporttransition != null) {
                        ServerLevel worldserver1 = teleporttransition.newLevel();
                        if (this instanceof ServerPlayer || worldserver1 != null && (worldserver1.dimension() == worldserver.dimension() || this.canTeleport(worldserver, worldserver1))) {
                            this.teleport(teleporttransition);
                        }
                    }
                    gameprofilerfiller.pop();
                } else if (this.portalProcess.hasExpired()) {
                    this.portalProcess = null;
                }
            }
        }
    }

    public int getDimensionChangingDelay() {
        Entity entity = this.getFirstPassenger();
        return entity instanceof ServerPlayer ? entity.getDimensionChangingDelay() : 300;
    }

    public void lerpMotion(double d0, double d1, double d2) {
        this.setDeltaMovement(d0, d1, d2);
    }

    public void handleDamageEvent(DamageSource damagesource) {
    }

    public void handleEntityEvent(byte b0) {
        switch (b0) {
            case 53: {
                HoneyBlock.showSlideParticles(this);
            }
        }
    }

    public void animateHurt(float f) {
    }

    public boolean isOnFire() {
        boolean flag = this.level() != null && this.level().isClientSide;
        return !this.fireImmune() && (this.remainingFireTicks > 0 || flag && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean dismountsUnderwater() {
        return this.getType().is(EntityTypeTags.DISMOUNTS_UNDERWATER);
    }

    public boolean canControlVehicle() {
        return !this.getType().is(EntityTypeTags.NON_CONTROLLING_RIDER);
    }

    public void setShiftKeyDown(boolean flag) {
        this.setSharedFlag(1, flag);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.hasPose(Pose.CROUCHING);
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean flag) {
        this.setSharedFlag(3, flag);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.hasPose(Pose.SWIMMING);
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean flag) {
        if (this.valid && this.isSwimming() != flag && this instanceof LivingEntity && CraftEventFactory.callToggleSwimEvent((LivingEntity)this, flag).isCancelled()) {
            return;
        }
        this.setSharedFlag(4, flag);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean flag) {
        this.hasGlowingTag = flag;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        return this.level().isClientSide() ? this.getSharedFlag(6) : this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(Player entityhuman) {
        if (entityhuman.isSpectator()) {
            return false;
        }
        PlayerTeam scoreboardteambase = this.getTeam();
        return scoreboardteambase != null && entityhuman != null && entityhuman.getTeam() == scoreboardteambase && ((Team)scoreboardteambase).canSeeFriendlyInvisibles() ? false : this.isInvisible();
    }

    public boolean isOnRails() {
        return false;
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> biconsumer) {
    }

    @Nullable
    public PlayerTeam getTeam() {
        return this.level().getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public final boolean isAlliedTo(@Nullable Entity entity) {
        return entity == null ? false : this == entity || this.considersEntityAsAlly(entity) || entity.considersEntityAsAlly(this);
    }

    protected boolean considersEntityAsAlly(Entity entity) {
        return this.isAlliedTo(entity.getTeam());
    }

    public boolean isAlliedTo(@Nullable Team scoreboardteambase) {
        return this.getTeam() != null ? this.getTeam().isAlliedTo(scoreboardteambase) : false;
    }

    public void setInvisible(boolean flag) {
        if (!this.persistentInvisibility) {
            this.setSharedFlag(5, flag);
        }
    }

    public boolean getSharedFlag(int i) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << i) != 0;
    }

    public void setSharedFlag(int i, boolean flag) {
        byte b0 = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (flag) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 | 1 << i));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 & ~(1 << i)));
        }
    }

    public int getMaxAirSupply() {
        return this.maxAirTicks;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int i) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.getAirSupply() != i) {
            this.entityData.markDirty(DATA_AIR_SUPPLY_ID);
            return;
        }
        this.entityData.set(DATA_AIR_SUPPLY_ID, event.getAmount());
    }

    public void clearFreeze() {
        this.setTicksFrozen(0);
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int i) {
        this.entityData.set(DATA_TICKS_FROZEN, i);
    }

    public float getPercentFrozen() {
        int i = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), i) / (float)i;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(ServerLevel worldserver, LightningBolt entitylightning) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = entitylightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.remainingFireTicks == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.fireImmune()) {
            return;
        }
        if (!this.hurtServer(worldserver, this.damageSources().lightningBolt().customEntityDamager(entitylightning), 5.0f)) {
            return;
        }
    }

    public void onAboveBubbleColumn(boolean flag, BlockPos blockposition) {
        Entity.handleOnAboveBubbleColumn(this, flag, blockposition);
    }

    protected static void handleOnAboveBubbleColumn(Entity entity, boolean flag, BlockPos blockposition) {
        Vec3 vec3d = entity.getDeltaMovement();
        double d0 = flag ? Math.max(-0.9, vec3d.y - 0.03) : Math.min(1.8, vec3d.y + 0.1);
        entity.setDeltaMovement(vec3d.x, d0, vec3d.z);
        Entity.sendBubbleColumnParticles(entity.level, blockposition);
    }

    protected static void sendBubbleColumnParticles(Level world, BlockPos blockposition) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            for (int i = 0; i < 2; ++i) {
                worldserver.sendParticles(ParticleTypes.SPLASH, (double)blockposition.getX() + world.random.nextDouble(), blockposition.getY() + 1, (double)blockposition.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                worldserver.sendParticles(ParticleTypes.BUBBLE, (double)blockposition.getX() + world.random.nextDouble(), blockposition.getY() + 1, (double)blockposition.getZ() + world.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
            }
        }
    }

    public void onInsideBubbleColumn(boolean flag) {
        Entity.handleOnInsideBubbleColumn(this, flag);
    }

    protected static void handleOnInsideBubbleColumn(Entity entity, boolean flag) {
        Vec3 vec3d = entity.getDeltaMovement();
        double d0 = flag ? Math.max(-0.3, vec3d.y - 0.03) : Math.min(0.7, vec3d.y + 0.06);
        entity.setDeltaMovement(vec3d.x, d0, vec3d.z);
        entity.resetFallDistance();
    }

    public boolean killedEntity(ServerLevel worldserver, LivingEntity entityliving) {
        return true;
    }

    public void checkFallDistanceAccumulation() {
        if (this.getDeltaMovement().y() > -0.5 && this.fallDistance > 1.0) {
            this.fallDistance = 1.0;
        }
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0;
    }

    protected void moveTowardsClosestSpace(double d0, double d1, double d2) {
        BlockPos blockposition = BlockPos.containing(d0, d1, d2);
        Vec3 vec3d = new Vec3(d0 - (double)blockposition.getX(), d1 - (double)blockposition.getY(), d2 - (double)blockposition.getZ());
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        Direction enumdirection = Direction.UP;
        double d3 = Double.MAX_VALUE;
        for (Direction enumdirection1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d5;
            blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection1);
            if (this.level().getBlockState(blockposition_mutableblockposition).isCollisionShapeFullBlock(this.level(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.get(enumdirection1.getAxis());
            double d = d5 = enumdirection1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f = this.random.nextFloat() * 0.2f + 0.1f;
        float f1 = enumdirection.getAxisDirection().getStep();
        Vec3 vec3d1 = this.getDeltaMovement().scale(0.75);
        if (enumdirection.getAxis() == Direction.Axis.X) {
            this.setDeltaMovement(f1 * f, vec3d1.y, vec3d1.z);
        } else if (enumdirection.getAxis() == Direction.Axis.Y) {
            this.setDeltaMovement(vec3d1.x, f1 * f, vec3d1.z);
        } else if (enumdirection.getAxis() == Direction.Axis.Z) {
            this.setDeltaMovement(vec3d1.x, vec3d1.y, f1 * f);
        }
    }

    public void makeStuckInBlock(BlockState iblockdata, Vec3 vec3d) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = vec3d;
    }

    private static Component removeAction(Component ichatbasecomponent) {
        MutableComponent ichatmutablecomponent = ichatbasecomponent.plainCopy().setStyle(ichatbasecomponent.getStyle().withClickEvent(null));
        for (Component ichatbasecomponent1 : ichatbasecomponent.getSiblings()) {
            ichatmutablecomponent.append(Entity.removeAction(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public Component getName() {
        Component ichatbasecomponent = this.getCustomName();
        return ichatbasecomponent != null ? Entity.removeAction(ichatbasecomponent) : this.getTypeName();
    }

    protected Component getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity entity) {
        return this == entity;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float f) {
    }

    public void setYBodyRot(float f) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity entity) {
        return false;
    }

    public String toString() {
        String s = this.level() == null ? "~NULL~" : this.level().toString();
        return this.removalReason != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.id, s, this.getX(), this.getY(), this.getZ(), this.removalReason}) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getName().getString(), this.id, s, this.getX(), this.getY(), this.getZ());
    }

    public final boolean isInvulnerableToBase(DamageSource damagesource) {
        return this.isRemoved() || this.invulnerable && !damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damagesource.isCreativePlayer() || damagesource.is(DamageTypeTags.IS_FIRE) && this.fireImmune() || damagesource.is(DamageTypeTags.IS_FALL) && this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean flag) {
        this.invulnerable = flag;
    }

    public void copyPosition(Entity entity) {
        this.snapTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
    }

    public void restoreFrom(Entity entity) {
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, entity.registryAccess());
            entity.saveWithoutId(tagvalueoutput);
            this.load(TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)this.registryAccess(), tagvalueoutput.buildResult()));
        }
        this.portalCooldown = entity.portalCooldown;
        this.portalProcess = entity.portalProcess;
    }

    @Nullable
    public Entity teleport(TeleportTransition teleporttransition) {
        ServerLevel worldserver = (ServerLevel)this.level();
        if (worldserver instanceof ServerLevel) {
            ServerLevel worldserver1 = worldserver;
            if (!this.isRemoved()) {
                boolean flag;
                PositionMoveRotation absolutePosition = PositionMoveRotation.calculateAbsolute(PositionMoveRotation.of(this), PositionMoveRotation.of(teleporttransition), teleporttransition.relatives());
                Location to = CraftLocation.toBukkit(absolutePosition.position(), (World)teleporttransition.newLevel().getWorld(), absolutePosition.yRot(), absolutePosition.xRot());
                EntityTeleportEvent teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                if (teleEvent.isCancelled()) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleporttransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), Vec3.ZERO, to.getYaw(), to.getPitch(), teleporttransition.missingRespawnBlock(), teleporttransition.asPassenger(), Set.of(), teleporttransition.postTeleportTransition(), teleporttransition.cause());
                }
                boolean bl = flag = (worldserver = teleporttransition.newLevel()).dimension() != worldserver1.dimension();
                if (!teleporttransition.asPassenger()) {
                    this.stopRiding();
                }
                if (flag) {
                    return this.teleportCrossDimension(worldserver1, worldserver, teleporttransition);
                }
                return this.teleportSameDimension(worldserver1, teleporttransition);
            }
        }
        return null;
    }

    private Entity teleportSameDimension(ServerLevel worldserver, TeleportTransition teleporttransition) {
        for (Entity entity : this.getPassengers()) {
            entity.teleport(this.calculatePassengerTransition(teleporttransition, entity));
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("teleportSameDimension");
        this.teleportSetPosition(PositionMoveRotation.of(teleporttransition), teleporttransition.relatives());
        if (!teleporttransition.asPassenger()) {
            this.sendTeleportTransitionToRidingPlayers(teleporttransition);
        }
        teleporttransition.postTeleportTransition().onTransition(this);
        gameprofilerfiller.pop();
        return this;
    }

    private Entity teleportCrossDimension(ServerLevel worldserver, ServerLevel worldserver1, TeleportTransition teleporttransition) {
        List<Entity> list = this.getPassengers();
        ArrayList<Entity> list1 = new ArrayList<Entity>(list.size());
        this.ejectPassengers();
        for (Entity entity : list) {
            Entity entity1 = entity.teleport(this.calculatePassengerTransition(teleporttransition, entity));
            if (entity1 == null) continue;
            list1.add(entity1);
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("teleportCrossDimension");
        Object entity2 = this.getType().create(worldserver1, EntitySpawnReason.DIMENSION_TRAVEL);
        if (entity2 == null) {
            gameprofilerfiller.pop();
            return null;
        }
        ((Entity)entity2).restoreFrom(this);
        this.removeAfterChangingDimensions();
        this.getBukkitEntity().setHandle((Entity)entity2);
        ((Entity)entity2).bukkitEntity = this.getBukkitEntity();
        ((Entity)entity2).teleportSetPosition(PositionMoveRotation.of(teleporttransition), teleporttransition.relatives());
        if (this.inWorld) {
            worldserver1.addDuringTeleport((Entity)entity2);
        }
        for (Entity entity3 : list1) {
            entity3.startRiding((Entity)entity2, true);
        }
        worldserver1.resetEmptyTime();
        teleporttransition.postTeleportTransition().onTransition((Entity)entity2);
        this.teleportSpectators(teleporttransition, worldserver);
        gameprofilerfiller.pop();
        return entity2;
    }

    protected void teleportSpectators(TeleportTransition teleporttransition, ServerLevel worldserver) {
        for (ServerPlayer entityplayer : List.copyOf(worldserver.players())) {
            if (entityplayer.getCamera() != this) continue;
            entityplayer.teleport(teleporttransition);
            entityplayer.setCamera(null);
        }
    }

    private TeleportTransition calculatePassengerTransition(TeleportTransition teleporttransition, Entity entity) {
        float f = teleporttransition.yRot() + (teleporttransition.relatives().contains((Object)Relative.Y_ROT) ? 0.0f : entity.getYRot() - this.getYRot());
        float f1 = teleporttransition.xRot() + (teleporttransition.relatives().contains((Object)Relative.X_ROT) ? 0.0f : entity.getXRot() - this.getXRot());
        Vec3 vec3d = entity.position().subtract(this.position());
        Vec3 vec3d1 = teleporttransition.position().add(teleporttransition.relatives().contains((Object)Relative.X) ? 0.0 : vec3d.x(), teleporttransition.relatives().contains((Object)Relative.Y) ? 0.0 : vec3d.y(), teleporttransition.relatives().contains((Object)Relative.Z) ? 0.0 : vec3d.z());
        return teleporttransition.withPosition(vec3d1).withRotation(f, f1).transitionAsPassenger();
    }

    private void sendTeleportTransitionToRidingPlayers(TeleportTransition teleporttransition) {
        LivingEntity entity = this.getControllingPassenger();
        for (Entity entity1 : this.getIndirectPassengers()) {
            if (!(entity1 instanceof ServerPlayer)) continue;
            ServerPlayer entityplayer = (ServerPlayer)entity1;
            if (entity != null && entityplayer.getId() == entity.getId()) {
                entityplayer.connection.send(ClientboundTeleportEntityPacket.teleport(this.getId(), PositionMoveRotation.of(teleporttransition), teleporttransition.relatives(), this.onGround));
                continue;
            }
            entityplayer.connection.send(ClientboundTeleportEntityPacket.teleport(this.getId(), PositionMoveRotation.of(this), Set.of(), this.onGround));
        }
    }

    public void teleportSetPosition(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        PositionMoveRotation positionmoverotation1 = PositionMoveRotation.of(this);
        PositionMoveRotation positionmoverotation2 = PositionMoveRotation.calculateAbsolute(positionmoverotation1, positionmoverotation, set);
        this.setPosRaw(positionmoverotation2.position().x, positionmoverotation2.position().y, positionmoverotation2.position().z);
        this.setYRot(positionmoverotation2.yRot());
        this.setYHeadRot(positionmoverotation2.yRot());
        this.setXRot(positionmoverotation2.xRot());
        this.reapplyPosition();
        this.setOldPosAndRot();
        this.setDeltaMovement(positionmoverotation2.deltaMovement());
        this.clearMovementThisTick();
    }

    public void forceSetRotation(float f, float f1) {
        this.setYRot(f);
        this.setYHeadRot(f);
        this.setXRot(f1);
        this.setOldRot();
    }

    public void placePortalTicket(BlockPos blockposition) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            worldserver.getChunkSource().addTicketWithRadius(TicketType.PORTAL, new ChunkPos(blockposition), 3);
        }
    }

    protected void removeAfterChangingDimensions() {
        this.setRemoved(RemovalReason.CHANGED_DIMENSION, null);
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            this.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            leashable.removeLeash();
        }
        if ((entity = this) instanceof WaypointTransmitter) {
            WaypointTransmitter waypointtransmitter = (WaypointTransmitter)((Object)entity);
            Level world = this.level;
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                worldserver.getWaypointManager().untrackWaypoint(waypointtransmitter);
            }
        }
    }

    public Vec3 getRelativePortalPosition(Direction.Axis enumdirection_enumaxis, BlockUtil.FoundRectangle blockutil_rectangle) {
        return PortalShape.getRelativePosition(blockutil_rectangle, enumdirection_enumaxis, this.position(), this.getDimensions(this.getPose()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.isAlive()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean canUsePortal(boolean flag) {
        return (flag || !this.isPassenger()) && this.isAlive();
    }

    public boolean canTeleport(Level world, Level world1) {
        if (world.dimension() == Level.END && world1.dimension() == Level.OVERWORLD) {
            for (Entity entity : this.getPassengers()) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer entityplayer = (ServerPlayer)entity;
                if (entityplayer.seenCredits) continue;
                return false;
            }
        }
        return true;
    }

    public float getBlockExplosionResistance(Explosion explosion, BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, FluidState fluid, float f) {
        return f;
    }

    public boolean shouldBlockExplode(Explosion explosion, BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, float f) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory crashreportsystemdetails) {
        crashreportsystemdetails.setDetail("Entity Type", () -> {
            String s = String.valueOf(EntityType.getKey(this.getType()));
            return s + " (" + this.getClass().getCanonicalName() + ")";
        });
        crashreportsystemdetails.setDetail("Entity ID", this.id);
        crashreportsystemdetails.setDetail("Entity Name", () -> this.getName().getString());
        crashreportsystemdetails.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        crashreportsystemdetails.setDetail("Entity's Block location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level(), Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ())));
        Vec3 vec3d = this.getDeltaMovement();
        crashreportsystemdetails.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.x, vec3d.y, vec3d.z));
        crashreportsystemdetails.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        crashreportsystemdetails.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    @Override
    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double d0) {
        viewScale = d0;
    }

    @Override
    public Component getDisplayName() {
        return PlayerTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@Nullable Component ichatbasecomponent) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(ichatbasecomponent));
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean flag) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, flag);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public final boolean teleportTo(ServerLevel worldserver, double d0, double d1, double d2, Set<Relative> set, float f, float f1, boolean flag) {
        return this.teleportTo(worldserver, d0, d1, d2, set, f, f1, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(ServerLevel worldserver, double d0, double d1, double d2, Set<Relative> set, float f, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        Entity entity = this.teleport(new TeleportTransition(worldserver, new Vec3(d0, d1, d2), Vec3.ZERO, f, f1, set, TeleportTransition.DO_NOTHING, cause));
        return entity != null;
    }

    public void dismountTo(double d0, double d1, double d2) {
        this.teleportTo(d0, d1, d2);
    }

    public void teleportTo(double d0, double d1, double d2) {
        if (this.level() instanceof ServerLevel) {
            this.snapTo(d0, d1, d2, this.getYRot(), this.getXRot());
            this.teleportPassengers();
        }
    }

    private void teleportPassengers() {
        this.getSelfAndPassengers().forEach(entity -> {
            for (Entity entity1 : entity.passengers) {
                entity.positionRider(entity1, Entity::snapTo);
            }
        });
    }

    public void teleportRelative(double d0, double d1, double d2) {
        this.teleportTo(this.getX() + d0, this.getY() + d1, this.getZ() + d2);
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    @Override
    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> list) {
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (DATA_POSE.equals(datawatcherobject)) {
            this.refreshDimensions();
        }
    }

    @Deprecated
    protected void fixupDimensions() {
        EntityDimensions entitysize;
        Pose entitypose = this.getPose();
        this.dimensions = entitysize = this.getDimensions(entitypose);
        this.eyeHeight = entitysize.eyeHeight();
    }

    public void refreshDimensions() {
        boolean flag;
        EntityDimensions entitysize1;
        EntityDimensions entitysize = this.dimensions;
        Pose entitypose = this.getPose();
        this.dimensions = entitysize1 = this.getDimensions(entitypose);
        this.eyeHeight = entitysize1.eyeHeight();
        this.reapplyPosition();
        boolean bl = flag = entitysize1.width() <= 4.0f && entitysize1.height() <= 4.0f;
        if (!(this.level.isClientSide || this.firstTick || this.noPhysics || !flag || !(entitysize1.width() > entitysize.width()) && !(entitysize1.height() > entitysize.height()) || this instanceof Player)) {
            this.fudgePositionAfterSizeChange(entitysize);
        }
    }

    public boolean fudgePositionAfterSizeChange(EntityDimensions entitysize) {
        VoxelShape voxelshape1;
        Optional<Vec3> optional1;
        double d1;
        double d0;
        EntityDimensions entitysize1 = this.getDimensions(this.getPose());
        Vec3 vec3d = this.position().add(0.0, (double)entitysize.height() / 2.0, 0.0);
        VoxelShape voxelshape = Shapes.create(AABB.ofSize(vec3d, d0 = (double)Math.max(0.0f, entitysize1.width() - entitysize.width()) + 1.0E-6, d1 = (double)Math.max(0.0f, entitysize1.height() - entitysize.height()) + 1.0E-6, d0));
        Optional<Vec3> optional = this.level.findFreePosition(this, voxelshape, vec3d, entitysize1.width(), entitysize1.height(), entitysize1.width());
        if (optional.isPresent()) {
            this.setPos(optional.get().add(0.0, (double)(-entitysize1.height()) / 2.0, 0.0));
            return true;
        }
        if (entitysize1.width() > entitysize.width() && entitysize1.height() > entitysize.height() && (optional1 = this.level.findFreePosition(this, voxelshape1 = Shapes.create(AABB.ofSize(vec3d, d0, 1.0E-6, d0)), vec3d, entitysize1.width(), entitysize.height(), entitysize1.width())).isPresent()) {
            this.setPos(optional1.get().add(0.0, (double)(-entitysize.height()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return Direction.fromYRot(this.getYRot());
    }

    public Direction getMotionDirection() {
        return this.getDirection();
    }

    protected HoverEvent createHoverEvent() {
        return new HoverEvent.ShowEntity(new HoverEvent.EntityTooltipInfo(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(ServerPlayer entityplayer) {
        return true;
    }

    @Override
    public final AABB getBoundingBox() {
        return this.bb;
    }

    public final void setBoundingBox(AABB axisalignedbb) {
        double minX = axisalignedbb.minX;
        double minY = axisalignedbb.minY;
        double minZ = axisalignedbb.minZ;
        double maxX = axisalignedbb.maxX;
        double maxY = axisalignedbb.maxY;
        double maxZ = axisalignedbb.maxZ;
        double len = axisalignedbb.maxX - axisalignedbb.minX;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = axisalignedbb.maxY - axisalignedbb.minY) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = axisalignedbb.maxZ - axisalignedbb.minZ) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.bb = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float getEyeHeight(Pose entitypose) {
        return this.getDimensions(entitypose).eyeHeight();
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public SlotAccess getSlot(int i) {
        return SlotAccess.NULL;
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.level().getServer();
    }

    public InteractionResult interactAt(Player entityhuman, Vec3 vec3d, InteractionHand enumhand) {
        return InteractionResult.PASS;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer entityplayer) {
    }

    public void stopSeenByPlayer(ServerPlayer entityplayer) {
    }

    public float rotate(Rotation enumblockrotation) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float mirror(Mirror enumblockmirror) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (enumblockmirror) {
            case FRONT_BACK: {
                return -f;
            }
            case LEFT_RIGHT: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public ProjectileDeflection deflection(Projectile iprojectile) {
        return this.getType().is(EntityTypeTags.DEFLECTS_PROJECTILES) ? ProjectileDeflection.REVERSE : ProjectileDeflection.NONE;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public final boolean hasControllingPassenger() {
        return this.getControllingPassenger() != null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity entity) {
        return this.passengers.contains((Object)entity);
    }

    public boolean hasPassenger(Predicate<Entity> predicate) {
        for (Entity entity : this.passengers) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        return () -> this.getIndirectPassengersStream().iterator();
    }

    public int countPlayerPassengers() {
        return (int)this.getIndirectPassengersStream().filter(entity -> entity instanceof Player).count();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        return this.countPlayerPassengers() == 1;
    }

    public Entity getRootVehicle() {
        Entity entity = this;
        while (entity.isPassenger()) {
            entity = entity.getVehicle();
        }
        return entity;
    }

    public boolean isPassengerOfSameVehicle(Entity entity) {
        return this.getRootVehicle() == entity.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity entity) {
        if (!entity.isPassenger()) {
            return false;
        }
        Entity entity1 = entity.getVehicle();
        return entity1 == this ? true : this.hasIndirectPassenger(entity1);
    }

    public final boolean isLocalInstanceAuthoritative() {
        return this.level.isClientSide() ? this.isLocalClientAuthoritative() : !this.isClientAuthoritative();
    }

    protected boolean isLocalClientAuthoritative() {
        LivingEntity entityliving = this.getControllingPassenger();
        return entityliving != null && entityliving.isLocalClientAuthoritative();
    }

    public boolean isClientAuthoritative() {
        LivingEntity entityliving = this.getControllingPassenger();
        return entityliving != null && entityliving.isClientAuthoritative();
    }

    public boolean canSimulateMovement() {
        return this.isLocalInstanceAuthoritative();
    }

    public boolean isEffectiveAi() {
        return this.isLocalInstanceAuthoritative();
    }

    protected static Vec3 getCollisionHorizontalEscapeVector(double d0, double d1, float f) {
        double d2 = (d0 + d1 + (double)1.0E-5f) / 2.0;
        float f1 = -Mth.sin(f * ((float)Math.PI / 180));
        float f2 = Mth.cos(f * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f2));
        return new Vec3((double)f1 * d2 / (double)f3, 0.0, (double)f2 * d2 / (double)f3);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity entityliving) {
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    @Nullable
    public Entity getControlledVehicle() {
        return this.vehicle != null && this.vehicle.getControllingPassenger() == this ? this.vehicle : null;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.NORMAL;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public int getFireImmuneTicks() {
        return 0;
    }

    public CommandSourceStack createCommandSourceStackForNameResolution(ServerLevel worldserver) {
        return new CommandSourceStack(this.commandSource, this.position(), this.getRotationVector(), worldserver, 0, this.getName().getString(), this.getDisplayName(), worldserver.getServer(), this);
    }

    public void lookAt(EntityAnchorArgument.Anchor argumentanchor_anchor, Vec3 vec3d) {
        Vec3 vec3d1 = argumentanchor_anchor.apply(this);
        double d0 = vec3d.x - vec3d1.x;
        double d1 = vec3d.y - vec3d1.y;
        double d2 = vec3d.z - vec3d1.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.setXRot(Mth.wrapDegrees((float)(-(Mth.atan2(d1, d3) * 57.2957763671875))));
        this.setYRot(Mth.wrapDegrees((float)(Mth.atan2(d2, d0) * 57.2957763671875) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public float getPreciseBodyRotation(float f) {
        return Mth.lerp(f, this.yRotO, this.yRot);
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AABB axisalignedbb = this.getBoundingBox().deflate(0.001);
        int i = Mth.floor(axisalignedbb.minX);
        int j = Mth.ceil(axisalignedbb.maxX);
        int k = Mth.floor(axisalignedbb.minY);
        int l = Mth.ceil(axisalignedbb.maxY);
        int i1 = Mth.floor(axisalignedbb.minZ);
        int j1 = Mth.ceil(axisalignedbb.maxZ);
        double d1 = 0.0;
        boolean flag = this.isPushedByFluid();
        boolean flag1 = false;
        Vec3 vec3d = Vec3.ZERO;
        int k1 = 0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = k; i2 < l; ++i2) {
                for (int j2 = i1; j2 < j1; ++j2) {
                    double d2;
                    blockposition_mutableblockposition.set(l1, i2, j2);
                    FluidState fluid = this.level().getFluidState(blockposition_mutableblockposition);
                    if (!fluid.is(tagkey) || !((d2 = (double)((float)i2 + fluid.getHeight(this.level(), blockposition_mutableblockposition))) >= axisalignedbb.minY)) continue;
                    flag1 = true;
                    d1 = Math.max(d2 - axisalignedbb.minY, d1);
                    if (flag) {
                        Vec3 vec3d1 = fluid.getFlow(this.level(), blockposition_mutableblockposition);
                        if (d1 < 0.4) {
                            vec3d1 = vec3d1.scale(d1);
                        }
                        vec3d = vec3d.add(vec3d1);
                        ++k1;
                    }
                    if (tagkey != FluidTags.LAVA) continue;
                    this.lastLavaContact = blockposition_mutableblockposition.immutable();
                }
            }
        }
        if (vec3d.length() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.scale(1.0 / (double)k1);
            }
            if (!(this instanceof Player)) {
                vec3d = vec3d.normalize();
            }
            Vec3 vec3d2 = this.getDeltaMovement();
            vec3d = vec3d.scale(d0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.x) < 0.003 && Math.abs(vec3d2.z) < 0.003 && vec3d.length() < 0.0045000000000000005) {
                vec3d = vec3d.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(vec3d));
        }
        this.fluidHeight.put(tagkey, d1);
        return flag1;
    }

    public boolean touchingUnloadedChunk() {
        AABB axisalignedbb = this.getBoundingBox().inflate(1.0);
        int i = Mth.floor(axisalignedbb.minX);
        int j = Mth.ceil(axisalignedbb.maxX);
        int k = Mth.floor(axisalignedbb.minZ);
        int l = Mth.ceil(axisalignedbb.maxZ);
        return !this.level().hasChunksAt(i, k, j, l);
    }

    public double getFluidHeight(TagKey<Fluid> tagkey) {
        return this.fluidHeight.getDouble(tagkey);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width();
    }

    public final float getBbHeight() {
        return this.dimensions.height();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entitytrackerentry) {
        return new ClientboundAddEntityPacket(this, entitytrackerentry);
    }

    public EntityDimensions getDimensions(Pose entitypose) {
        return this.type.getDimensions();
    }

    public final EntityAttachments getAttachments() {
        return this.dimensions.attachments();
    }

    public Vec3 position() {
        return this.position;
    }

    public Vec3 trackingPosition() {
        return this.position();
    }

    @Override
    public BlockPos blockPosition() {
        return this.blockPosition;
    }

    public BlockState getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.level().getBlockState(this.blockPosition());
        }
        return this.inBlockState;
    }

    public ChunkPos chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3 getDeltaMovement() {
        return this.deltaMovement;
    }

    public void setDeltaMovement(Vec3 vec3d) {
        this.deltaMovement = vec3d;
    }

    public void addDeltaMovement(Vec3 vec3d) {
        this.setDeltaMovement(this.getDeltaMovement().add(vec3d));
    }

    public void setDeltaMovement(double d0, double d1, double d2) {
        this.setDeltaMovement(new Vec3(d0, d1, d2));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double d0) {
        return this.position.x + (double)this.getBbWidth() * d0;
    }

    public double getRandomX(double d0) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * d0);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double d0) {
        return this.position.y + (double)this.getBbHeight() * d0;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double d0) {
        return this.position.z + (double)this.getBbWidth() * d0;
    }

    public double getRandomZ(double d0) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * d0);
    }

    public final void setPosRaw(double d0, double d1, double d2) {
        if (this.position.x != d0 || this.position.y != d1 || this.position.z != d2) {
            Level world;
            this.position = new Vec3(d0, d1, d2);
            int i = Mth.floor(d0);
            int j = Mth.floor(d1);
            int k = Mth.floor(d2);
            if (i != this.blockPosition.getX() || j != this.blockPosition.getY() || k != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPos(i, j, k);
                this.inBlockState = null;
                if (SectionPos.blockToSectionCoord(i) != this.chunkPosition.x || SectionPos.blockToSectionCoord(k) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkPos(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
            if (!this.firstTick && (world = this.level) instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (!this.isRemoved()) {
                    ServerPlayer entityplayer;
                    WaypointTransmitter waypointtransmitter;
                    if (this instanceof WaypointTransmitter && (waypointtransmitter = (WaypointTransmitter)((Object)this)).isTransmittingWaypoint()) {
                        worldserver.getWaypointManager().updateWaypoint(waypointtransmitter);
                    }
                    if (this instanceof ServerPlayer && (entityplayer = (ServerPlayer)this).isReceivingWaypoints() && entityplayer.connection != null) {
                        worldserver.getWaypointManager().updatePlayer(entityplayer);
                    }
                }
            }
        }
    }

    public void checkDespawn() {
    }

    public Vec3[] getQuadLeashHolderOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.0, 0.5, 0.5, 0.0);
    }

    public boolean supportQuadLeashAsHolder() {
        return false;
    }

    public void notifyLeashHolder(Leashable leashable) {
    }

    public void notifyLeasheeRemoved(Leashable leashable) {
    }

    public Vec3 getRopeHoldPosition(float f) {
        return this.getPosition(f).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        int i = packetplayoutspawnentity.getId();
        double d0 = packetplayoutspawnentity.getX();
        double d1 = packetplayoutspawnentity.getY();
        double d2 = packetplayoutspawnentity.getZ();
        this.syncPacketPositionCodec(d0, d1, d2);
        this.snapTo(d0, d1, d2, packetplayoutspawnentity.getYRot(), packetplayoutspawnentity.getXRot());
        this.setId(i);
        this.setUUID(packetplayoutspawnentity.getUUID());
        Vec3 vec3d = new Vec3(packetplayoutspawnentity.getXa(), packetplayoutspawnentity.getYa(), packetplayoutspawnentity.getZa());
        this.setDeltaMovement(vec3d);
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean flag) {
        this.isInPowderSnow = flag;
    }

    public boolean canFreeze() {
        return !this.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES);
    }

    public boolean isFreezing() {
        return this.getTicksFrozen() > 0;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public void setYRot(float f) {
        if (!Float.isFinite(f)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + f + ", discarding.");
        } else {
            this.yRot = f;
        }
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float f) {
        if (!Float.isFinite(f)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + f + ", discarding.");
        } else {
            this.xRot = Math.clamp(f % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean canSprint() {
        return false;
    }

    public float maxUpStep() {
        return 0.0f;
    }

    public void onExplosionHit(@Nullable Entity entity) {
    }

    @Override
    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        if (this.removalReason == null) {
            this.removalReason = entity_removalreason;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        this.getPassengers().forEach(Entity::stopRiding);
        this.levelCallback.onRemove(entity_removalreason);
        this.onRemoval(entity_removalreason);
    }

    public void unsetRemoved() {
        this.removalReason = null;
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback entityinlevelcallback) {
        this.levelCallback = entityinlevelcallback;
    }

    @Override
    public boolean shouldBeSaved() {
        return this.removalReason != null && !this.removalReason.shouldSave() ? false : (this.isPassenger() ? false : !this.isVehicle() || !this.hasExactlyOnePlayerPassenger());
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(ServerLevel worldserver, BlockPos blockposition) {
        return true;
    }

    public boolean isFlyingVehicle() {
        return false;
    }

    public Level level() {
        return this.level;
    }

    protected void setLevel(Level world) {
        this.level = world;
    }

    public DamageSources damageSources() {
        return this.level().damageSources();
    }

    public RegistryAccess registryAccess() {
        return this.level().registryAccess();
    }

    protected void lerpPositionAndRotationStep(int i, double d0, double d1, double d2, double d3, double d4) {
        double d5 = 1.0 / (double)i;
        double d6 = Mth.lerp(d5, this.getX(), d0);
        double d7 = Mth.lerp(d5, this.getY(), d1);
        double d8 = Mth.lerp(d5, this.getZ(), d2);
        float f = (float)Mth.rotLerp(d5, (double)this.getYRot(), d3);
        float f1 = (float)Mth.lerp(d5, (double)this.getXRot(), d4);
        this.setPos(d6, d7, d8);
        this.setRot(f, f1);
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public Vec3 getKnownMovement() {
        LivingEntity entityliving = this.getControllingPassenger();
        if (entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            if (this.isAlive()) {
                return entityhuman.getKnownMovement();
            }
        }
        return this.getDeltaMovement();
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> getLootTable() {
        return this.type.getDefaultLootTable();
    }

    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.CUSTOM_NAME);
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.CUSTOM_DATA);
    }

    public final void applyComponentsFromItemStack(ItemStack itemstack) {
        this.applyImplicitComponents(itemstack.getComponents());
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> datacomponenttype) {
        return (T)(datacomponenttype == DataComponents.CUSTOM_NAME ? Entity.castComponentValue(datacomponenttype, this.getCustomName()) : (datacomponenttype == DataComponents.CUSTOM_DATA ? Entity.castComponentValue(datacomponenttype, this.customData) : null));
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    protected static <T> T castComponentValue(DataComponentType<T> datacomponenttype, @Nullable Object object) {
        return (T)object;
    }

    public <T> void setComponent(DataComponentType<T> datacomponenttype, T t0) {
        this.applyImplicitComponent(datacomponenttype, t0);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.CUSTOM_NAME) {
            this.setCustomName(Entity.castComponentValue(DataComponents.CUSTOM_NAME, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.CUSTOM_DATA) {
            this.customData = Entity.castComponentValue(DataComponents.CUSTOM_DATA, t0);
            return true;
        }
        return false;
    }

    protected <T> boolean applyImplicitComponentIfPresent(DataComponentGetter datacomponentgetter, DataComponentType<T> datacomponenttype) {
        T t0 = datacomponentgetter.get(datacomponenttype);
        return t0 != null ? this.applyImplicitComponent(datacomponenttype, t0) : false;
    }

    public ProblemReporter.PathElement problemPath() {
        return new EntityPathElement(this);
    }

    public static enum RemovalReason {
        KILLED(true, false),
        DISCARDED(true, false),
        UNLOADED_TO_CHUNK(false, true),
        UNLOADED_WITH_PLAYER(false, false),
        CHANGED_DIMENSION(false, false);

        private final boolean destroy;
        private final boolean save;

        private RemovalReason(boolean flag, boolean flag1) {
            this.destroy = flag;
            this.save = flag1;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }
    }

    private record Movement(Vec3 from, Vec3 to, boolean axisIndependant) {
    }

    public static enum MovementEmission {
        NONE(false, false),
        SOUNDS(true, false),
        EVENTS(false, true),
        ALL(true, true);

        final boolean sounds;
        final boolean events;

        private MovementEmission(boolean flag, boolean flag1) {
            this.sounds = flag;
            this.events = flag1;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private record EntityPathElement(Entity entity) implements ProblemReporter.PathElement
    {
        @Override
        public String get() {
            return this.entity.toString();
        }
    }
}

