/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EntityEquipment {
    public static final Codec<EntityEquipment> CODEC = Codec.unboundedMap(EquipmentSlot.CODEC, ItemStack.CODEC).xmap(var0 -> {
        EnumMap<EquipmentSlot, ItemStack> var1 = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        var1.putAll((Map<EquipmentSlot, ItemStack>)var0);
        return new EntityEquipment(var1);
    }, var0 -> {
        EnumMap<EquipmentSlot, ItemStack> var1 = new EnumMap<EquipmentSlot, ItemStack>(var0.items);
        var1.values().removeIf(ItemStack::isEmpty);
        return var1;
    });
    private final EnumMap<EquipmentSlot, ItemStack> items;

    private EntityEquipment(EnumMap<EquipmentSlot, ItemStack> var0) {
        this.items = var0;
    }

    public EntityEquipment() {
        this(new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class));
    }

    public ItemStack set(EquipmentSlot var0, ItemStack var1) {
        var1.getItem().verifyComponentsAfterLoad(var1);
        return Objects.requireNonNullElse(this.items.put(var0, var1), ItemStack.EMPTY);
    }

    public ItemStack get(EquipmentSlot var0) {
        return this.items.getOrDefault(var0, ItemStack.EMPTY);
    }

    public boolean isEmpty() {
        for (ItemStack var1 : this.items.values()) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void tick(Entity var0) {
        for (Map.Entry<EquipmentSlot, ItemStack> var2 : this.items.entrySet()) {
            ItemStack var3 = var2.getValue();
            if (var3.isEmpty()) continue;
            var3.inventoryTick(var0.level(), var0, var2.getKey());
        }
    }

    public void setAll(EntityEquipment var0) {
        this.items.clear();
        this.items.putAll(var0.items);
    }

    public void dropAll(LivingEntity var0) {
        for (ItemStack var2 : this.items.values()) {
            var0.drop(var2, true, false);
        }
        this.clear();
    }

    public void clear() {
        this.items.replaceAll((var0, var1) -> ItemStack.EMPTY);
    }
}

