/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class UseBonemeal
extends Behavior<Villager> {
    private static final int BONEMEALING_DURATION = 80;
    private long nextWorkCycleTime;
    private long lastBonemealingSession;
    private int timeWorkedSoFar;
    private Optional<BlockPos> cropPos = Optional.empty();

    public UseBonemeal() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Villager var1) {
        if (var1.tickCount % 10 != 0 || this.lastBonemealingSession != 0L && this.lastBonemealingSession + 160L > (long)var1.tickCount) {
            return false;
        }
        if (var1.getInventory().countItem(Items.BONE_MEAL) <= 0) {
            return false;
        }
        this.cropPos = this.pickNextTarget(var0, var1);
        return this.cropPos.isPresent();
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return this.timeWorkedSoFar < 80 && this.cropPos.isPresent();
    }

    private Optional<BlockPos> pickNextTarget(ServerLevel var0, Villager var1) {
        BlockPos.MutableBlockPos var2 = new BlockPos.MutableBlockPos();
        Optional<BlockPos> var3 = Optional.empty();
        int var4 = 0;
        for (int var5 = -1; var5 <= 1; ++var5) {
            for (int var6 = -1; var6 <= 1; ++var6) {
                for (int var7 = -1; var7 <= 1; ++var7) {
                    var2.setWithOffset(var1.blockPosition(), var5, var6, var7);
                    if (!this.validPos(var2, var0) || var0.random.nextInt(++var4) != 0) continue;
                    var3 = Optional.of(var2.immutable());
                }
            }
        }
        return var3;
    }

    private boolean validPos(BlockPos var0, ServerLevel var1) {
        BlockState var2 = var1.getBlockState(var0);
        Block var3 = var2.getBlock();
        return var3 instanceof CropBlock && !((CropBlock)var3).isMaxAge(var2);
    }

    @Override
    protected void start(ServerLevel var0, Villager var1, long var2) {
        this.setCurrentCropAsTarget(var1);
        var1.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.BONE_MEAL));
        this.nextWorkCycleTime = var2;
        this.timeWorkedSoFar = 0;
    }

    private void setCurrentCropAsTarget(Villager var0) {
        this.cropPos.ifPresent(var1 -> {
            BlockPosTracker var2 = new BlockPosTracker((BlockPos)var1);
            var0.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, var2);
            var0.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(var2, 0.5f, 1));
        });
    }

    @Override
    protected void stop(ServerLevel var0, Villager var1, long var2) {
        var1.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.lastBonemealingSession = var1.tickCount;
    }

    @Override
    protected void tick(ServerLevel var0, Villager var1, long var2) {
        BlockPos var4 = this.cropPos.get();
        if (var2 < this.nextWorkCycleTime || !var4.closerToCenterThan(var1.position(), 1.0)) {
            return;
        }
        ItemStack var5 = ItemStack.EMPTY;
        SimpleContainer var6 = var1.getInventory();
        int var7 = var6.getContainerSize();
        for (int var8 = 0; var8 < var7; ++var8) {
            ItemStack var9 = var6.getItem(var8);
            if (!var9.is(Items.BONE_MEAL)) continue;
            var5 = var9;
            break;
        }
        if (!var5.isEmpty() && BoneMealItem.growCrop(var5, var0, var4)) {
            var0.levelEvent(1505, var4, 15);
            this.cropPos = this.pickNextTarget(var0, var1);
            this.setCurrentCropAsTarget(var1);
            this.nextWorkCycleTime = var2 + 40L;
        }
        ++this.timeWorkedSoFar;
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

