/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BoatGoals;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.phys.Vec3;

public class FollowBoatGoal
extends Goal {
    private int timeToRecalcPath;
    private final PathfinderMob mob;
    @Nullable
    private Player following;
    private BoatGoals currentGoal;

    public FollowBoatGoal(PathfinderMob var0) {
        this.mob = var0;
    }

    @Override
    public boolean canUse() {
        List<AbstractBoat> var0 = this.mob.level().getEntitiesOfClass(AbstractBoat.class, this.mob.getBoundingBox().inflate(5.0));
        boolean var1 = false;
        for (AbstractBoat var3 : var0) {
            LivingEntity var4 = var3.getControllingPassenger();
            if (!(var4 instanceof Player)) continue;
            Player var5 = (Player)var4;
            if (!(Mth.abs(var5.xxa) > 0.0f) && !(Mth.abs(var5.zza) > 0.0f)) continue;
            var1 = true;
            break;
        }
        return this.following != null && (Mth.abs(this.following.xxa) > 0.0f || Mth.abs(this.following.zza) > 0.0f) || var1;
    }

    @Override
    public boolean isInterruptable() {
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        return this.following != null && this.following.isPassenger() && (Mth.abs(this.following.xxa) > 0.0f || Mth.abs(this.following.zza) > 0.0f);
    }

    @Override
    public void start() {
        List<AbstractBoat> var0 = this.mob.level().getEntitiesOfClass(AbstractBoat.class, this.mob.getBoundingBox().inflate(5.0));
        for (AbstractBoat var2 : var0) {
            Player var3;
            LivingEntity livingEntity = var2.getControllingPassenger();
            if (!(livingEntity instanceof Player)) continue;
            this.following = var3 = (Player)livingEntity;
            break;
        }
        this.timeToRecalcPath = 0;
        this.currentGoal = BoatGoals.GO_TO_BOAT;
    }

    @Override
    public void stop() {
        this.following = null;
    }

    @Override
    public void tick() {
        boolean var0;
        boolean bl = var0 = Mth.abs(this.following.xxa) > 0.0f || Mth.abs(this.following.zza) > 0.0f;
        float var1 = this.currentGoal == BoatGoals.GO_IN_BOAT_DIRECTION ? (var0 ? 0.01f : 0.0f) : 0.015f;
        this.mob.moveRelative(var1, new Vec3(this.mob.xxa, this.mob.yya, this.mob.zza));
        this.mob.move(MoverType.SELF, this.mob.getDeltaMovement());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        if (this.currentGoal == BoatGoals.GO_TO_BOAT) {
            BlockPos var2 = this.following.blockPosition().relative(this.following.getDirection().getOpposite());
            var2 = var2.offset(0, -1, 0);
            this.mob.getNavigation().moveTo(var2.getX(), var2.getY(), var2.getZ(), 1.0);
            if (this.mob.distanceTo(this.following) < 4.0f) {
                this.timeToRecalcPath = 0;
                this.currentGoal = BoatGoals.GO_IN_BOAT_DIRECTION;
            }
        } else if (this.currentGoal == BoatGoals.GO_IN_BOAT_DIRECTION) {
            Direction var2 = this.following.getMotionDirection();
            BlockPos var3 = this.following.blockPosition().relative(var2, 10);
            this.mob.getNavigation().moveTo(var3.getX(), var3.getY() - 1, var3.getZ(), 1.0);
            if (this.mob.distanceTo(this.following) > 12.0f) {
                this.timeToRecalcPath = 0;
                this.currentGoal = BoatGoals.GO_TO_BOAT;
            }
        }
    }
}

