/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class RemoveBlockGoal
extends MoveToBlockGoal {
    private final Block blockToRemove;
    private final Mob removerMob;
    private int ticksSinceReachedGoal;
    private static final int WAIT_AFTER_BLOCK_FOUND = 20;

    public RemoveBlockGoal(Block block, PathfinderMob entitycreature, double d0, int i) {
        super(entitycreature, d0, 24, i);
        this.blockToRemove = block;
        this.removerMob = entitycreature;
    }

    @Override
    public boolean canUse() {
        if (!RemoveBlockGoal.getServerLevel(this.removerMob).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.findNearestBlock()) {
            this.nextStartTick = RemoveBlockGoal.reducedTickDelay(20);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        this.removerMob.fallDistance = 1.0;
    }

    @Override
    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(LevelAccessor generatoraccess, BlockPos blockposition) {
    }

    public void playBreakSound(Level world, BlockPos blockposition) {
    }

    @Override
    public void tick() {
        super.tick();
        Level world = this.removerMob.level();
        BlockPos blockposition = this.removerMob.blockPosition();
        BlockPos blockposition1 = this.getPosWithBlock(blockposition, world);
        RandomSource randomsource = this.removerMob.getRandom();
        if (this.isReachedTarget() && blockposition1 != null) {
            if (this.ticksSinceReachedGoal > 0) {
                Vec3 vec3d = this.removerMob.getDeltaMovement();
                this.removerMob.setDeltaMovement(vec3d.x, 0.3, vec3d.z);
                if (!world.isClientSide) {
                    double d0 = 0.08;
                    ((ServerLevel)world).sendParticles(new ItemParticleOption(ParticleTypes.ITEM, new ItemStack(Items.EGG)), (double)blockposition1.getX() + 0.5, (double)blockposition1.getY() + 0.7, (double)blockposition1.getZ() + 0.5, 3, ((double)randomsource.nextFloat() - 0.5) * 0.08, ((double)randomsource.nextFloat() - 0.5) * 0.08, ((double)randomsource.nextFloat() - 0.5) * 0.08, 0.15f);
                }
            }
            if (this.ticksSinceReachedGoal % 2 == 0) {
                Vec3 vec3d1 = this.removerMob.getDeltaMovement();
                this.removerMob.setDeltaMovement(vec3d1.x, -0.3, vec3d1.z);
                if (this.ticksSinceReachedGoal % 6 == 0) {
                    this.playDestroyProgressSound(world, this.blockPos);
                }
            }
            if (this.ticksSinceReachedGoal > 60) {
                if (!CraftEventFactory.callEntityInteractEvent(this.removerMob, CraftBlock.at(world, blockposition1))) {
                    return;
                }
                world.removeBlock(blockposition1, false);
                if (!world.isClientSide) {
                    for (int i = 0; i < 20; ++i) {
                        double d1 = randomsource.nextGaussian() * 0.02;
                        double d2 = randomsource.nextGaussian() * 0.02;
                        double d3 = randomsource.nextGaussian() * 0.02;
                        ((ServerLevel)world).sendParticles(ParticleTypes.POOF, (double)blockposition1.getX() + 0.5, blockposition1.getY(), (double)blockposition1.getZ() + 0.5, 1, d1, d2, d3, 0.15f);
                    }
                    this.playBreakSound(world, blockposition1);
                }
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    @Nullable
    private BlockPos getPosWithBlock(BlockPos blockposition, BlockGetter iblockaccess) {
        BlockPos[] ablockposition;
        if (iblockaccess.getBlockState(blockposition).is(this.blockToRemove)) {
            return blockposition;
        }
        for (BlockPos blockposition1 : ablockposition = new BlockPos[]{blockposition.below(), blockposition.west(), blockposition.east(), blockposition.north(), blockposition.south(), blockposition.below().below()}) {
            if (!iblockaccess.getBlockState(blockposition1).is(this.blockToRemove)) continue;
            return blockposition1;
        }
        return null;
    }

    @Override
    protected boolean isValidTarget(LevelReader iworldreader, BlockPos blockposition) {
        ChunkAccess ichunkaccess = iworldreader.getChunk(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ()), ChunkStatus.FULL, false);
        return ichunkaccess == null ? false : ichunkaccess.getBlockState(blockposition).is(this.blockToRemove) && ichunkaccess.getBlockState(blockposition.above()).isAir() && ichunkaccess.getBlockState(blockposition.above(2)).isAir();
    }
}

