/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public class FlyingPathNavigation
extends PathNavigation {
    public FlyingPathNavigation(Mob var0, Level var1) {
        super(var0, var1);
    }

    @Override
    protected PathFinder createPathFinder(int var0) {
        this.nodeEvaluator = new FlyNodeEvaluator();
        return new PathFinder(this.nodeEvaluator, var0);
    }

    @Override
    protected boolean canMoveDirectly(Vec3 var0, Vec3 var1) {
        return FlyingPathNavigation.isClearForMovementBetween(this.mob, var0, var1, true);
    }

    @Override
    protected boolean canUpdatePath() {
        return this.canFloat() && this.mob.isInLiquid() || !this.mob.isPassenger();
    }

    @Override
    protected Vec3 getTempMobPos() {
        return this.mob.position();
    }

    @Override
    public Path createPath(Entity var0, int var1) {
        return this.createPath(var0.blockPosition(), var1);
    }

    @Override
    public void tick() {
        Vec3 var0;
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isDone()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            var0 = this.path.getNextEntityPos(this.mob);
            if (this.mob.getBlockX() == Mth.floor(var0.x) && this.mob.getBlockY() == Mth.floor(var0.y) && this.mob.getBlockZ() == Mth.floor(var0.z)) {
                this.path.advance();
            }
        }
        DebugPackets.sendPathFindingPacket(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
        if (this.isDone()) {
            return;
        }
        var0 = this.path.getNextEntityPos(this.mob);
        this.mob.getMoveControl().setWantedPosition(var0.x, var0.y, var0.z, this.speedModifier);
    }

    @Override
    public boolean isStableDestination(BlockPos var0) {
        return this.level.getBlockState(var0).entityCanStandOn(this.level, var0, this.mob);
    }

    @Override
    public boolean canNavigateGround() {
        return false;
    }
}

