/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.pathfinder.Path;

public class NearestBedSensor
extends Sensor<Mob> {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private static final int RATE = 20;
    private final Long2LongMap batchCache = new Long2LongOpenHashMap();
    private int triedCount;
    private long lastUpdate;

    public NearestBedSensor() {
        super(20);
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_BED);
    }

    @Override
    protected void doTick(ServerLevel var02, Mob var1) {
        Predicate<BlockPos> var3;
        if (!var1.isBaby()) {
            return;
        }
        this.triedCount = 0;
        this.lastUpdate = var02.getGameTime() + (long)var02.getRandom().nextInt(20);
        PoiManager var2 = var02.getPoiManager();
        Set<Pair<Holder<PoiType>, BlockPos>> var4 = var2.findAllWithType(var0 -> var0.is(PoiTypes.HOME), var3 = var0 -> {
            long var1 = var0.asLong();
            if (this.batchCache.containsKey(var1)) {
                return false;
            }
            if (++this.triedCount >= 5) {
                return false;
            }
            this.batchCache.put(var1, this.lastUpdate + 40L);
            return true;
        }, var1.blockPosition(), 48, PoiManager.Occupancy.ANY).collect(Collectors.toSet());
        Path var5 = AcquirePoi.findPathToPois(var1, var4);
        if (var5 != null && var5.canReach()) {
            BlockPos var6 = var5.getTarget();
            Optional<Holder<PoiType>> var7 = var2.getType(var6);
            if (var7.isPresent()) {
                var1.getBrain().setMemory(MemoryModuleType.NEAREST_BED, var6);
            }
        } else if (this.triedCount < 5) {
            this.batchCache.long2LongEntrySet().removeIf(var0 -> var0.getLongValue() < this.lastUpdate);
        }
    }
}

