/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AABB;

public class NearestLivingEntitySensor<T extends LivingEntity>
extends Sensor<T> {
    @Override
    protected void doTick(ServerLevel var0, T var12) {
        double var2 = ((LivingEntity)var12).getAttributeValue(Attributes.FOLLOW_RANGE);
        AABB var4 = ((Entity)var12).getBoundingBox().inflate(var2, var2, var2);
        List<LivingEntity> var5 = var0.getEntitiesOfClass(LivingEntity.class, var4, var1 -> var1 != var12 && var1.isAlive());
        var5.sort(Comparator.comparingDouble(arg_0 -> var12.distanceToSqr(arg_0)));
        Brain<?> var6 = ((LivingEntity)var12).getBrain();
        var6.setMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES, var5);
        var6.setMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, new NearestVisibleLivingEntities(var0, (LivingEntity)var12, var5));
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

