/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.ItemStack;

public class ArmorStand
extends LivingEntity {
    public static final int WOBBLE_TIME = 5;
    private static final boolean ENABLE_ARMS = true;
    public static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.fixed(0.0f, 0.0f);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ARMOR_STAND.getDimensions().scale(0.5f).withEyeHeight(0.9875f);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    private static final Predicate<Entity> RIDABLE_MINECARTS = entity -> {
        AbstractMinecart entityminecartabstract;
        if (entity instanceof AbstractMinecart && (entityminecartabstract = (AbstractMinecart)entity).isRideable()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    };
    private static final boolean DEFAULT_INVISIBLE = false;
    private static final int DEFAULT_DISABLED_SLOTS = 0;
    private static final boolean DEFAULT_SMALL = false;
    private static final boolean DEFAULT_SHOW_ARMS = false;
    private static final boolean DEFAULT_NO_BASE_PLATE = false;
    private static final boolean DEFAULT_MARKER = false;
    private boolean invisible = false;
    public long lastHit;
    public int disabledSlots = 0;

    public ArmorStand(EntityType<? extends ArmorStand> entitytypes, Level world) {
        super((EntityType<? extends LivingEntity>)entitytypes, world);
    }

    public ArmorStand(Level world, double d0, double d1, double d2) {
        this((EntityType<? extends ArmorStand>)EntityType.ARMOR_STAND, world);
        this.setPos(d0, d1, d2);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ArmorStand.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.getYRot();
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_CLIENT_FLAGS, (byte)0);
        datawatcher_a.define(DATA_HEAD_POSE, DEFAULT_HEAD_POSE);
        datawatcher_a.define(DATA_BODY_POSE, DEFAULT_BODY_POSE);
        datawatcher_a.define(DATA_LEFT_ARM_POSE, DEFAULT_LEFT_ARM_POSE);
        datawatcher_a.define(DATA_RIGHT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE);
        datawatcher_a.define(DATA_LEFT_LEG_POSE, DEFAULT_LEFT_LEG_POSE);
        datawatcher_a.define(DATA_RIGHT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot enumitemslot) {
        return enumitemslot != EquipmentSlot.BODY && enumitemslot != EquipmentSlot.SADDLE && !this.isDisabled(enumitemslot);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putBoolean("Invisible", this.isInvisible());
        valueoutput.putBoolean("Small", this.isSmall());
        valueoutput.putBoolean("ShowArms", this.showArms());
        valueoutput.putInt("DisabledSlots", this.disabledSlots);
        valueoutput.putBoolean("NoBasePlate", !this.showBasePlate());
        if (this.isMarker()) {
            valueoutput.putBoolean("Marker", this.isMarker());
        }
        valueoutput.store("Pose", ArmorStandPose.CODEC, this.getArmorStandPose());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.setInvisible(valueinput.getBooleanOr("Invisible", false));
        this.setSmall(valueinput.getBooleanOr("Small", false));
        this.setShowArms(valueinput.getBooleanOr("ShowArms", false));
        this.disabledSlots = valueinput.getIntOr("DisabledSlots", 0);
        this.setNoBasePlate(valueinput.getBooleanOr("NoBasePlate", false));
        this.setMarker(valueinput.getBooleanOr("Marker", false));
        this.noPhysics = !this.hasPhysics();
        valueinput.read("Pose", ArmorStandPose.CODEC).ifPresent(this::setArmorStandPose);
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity entity) {
    }

    @Override
    protected void pushEntities() {
        for (Entity entity : this.level().getEntities(this, this.getBoundingBox(), RIDABLE_MINECARTS)) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push(this);
        }
    }

    @Override
    public InteractionResult interactAt(Player entityhuman, Vec3 vec3d, InteractionHand enumhand) {
        net.minecraft.world.item.ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (!this.isMarker() && !itemstack.is(Items.NAME_TAG)) {
            if (entityhuman.isSpectator()) {
                return InteractionResult.SUCCESS;
            }
            if (entityhuman.level().isClientSide) {
                return InteractionResult.SUCCESS_SERVER;
            }
            EquipmentSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
            if (itemstack.isEmpty()) {
                EquipmentSlot enumitemslot2;
                EquipmentSlot enumitemslot1 = this.getClickedSlot(vec3d);
                EquipmentSlot equipmentSlot = enumitemslot2 = this.isDisabled(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.hasItemInSlot(enumitemslot2) && this.swapItem(entityhuman, enumitemslot2, itemstack, enumhand)) {
                    return InteractionResult.SUCCESS_SERVER;
                }
            } else {
                if (this.isDisabled(enumitemslot)) {
                    return InteractionResult.FAIL;
                }
                if (enumitemslot.getType() == EquipmentSlot.Type.HAND && !this.showArms()) {
                    return InteractionResult.FAIL;
                }
                if (this.swapItem(entityhuman, enumitemslot, itemstack, enumhand)) {
                    return InteractionResult.SUCCESS_SERVER;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 vec3d) {
        EquipmentSlot enumitemslot = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = vec3d.y / (double)(this.getScale() * this.getAgeScale());
        EquipmentSlot enumitemslot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.hasItemInSlot(enumitemslot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.hasItemInSlot(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.hasItemInSlot(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.hasItemInSlot(EquipmentSlot.MAINHAND)) return enumitemslot;
        if (!this.hasItemInSlot(EquipmentSlot.OFFHAND)) return enumitemslot;
        return EquipmentSlot.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlot enumitemslot) {
        return (this.disabledSlots & 1 << enumitemslot.getFilterBit(0)) != 0 || enumitemslot.getType() == EquipmentSlot.Type.HAND && !this.showArms();
    }

    private boolean swapItem(Player entityhuman, EquipmentSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, InteractionHand enumhand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.getItemBySlot(enumitemslot);
        if (!itemstack1.isEmpty() && (this.disabledSlots & 1 << enumitemslot.getFilterBit(8)) != 0) {
            return false;
        }
        if (itemstack1.isEmpty() && (this.disabledSlots & 1 << enumitemslot.getFilterBit(16)) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(itemstack);
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)entityhuman.getBukkitEntity();
        org.bukkit.entity.ArmorStand self = (org.bukkit.entity.ArmorStand)this.getBukkitEntity();
        org.bukkit.inventory.EquipmentSlot slot = CraftEquipmentSlot.getSlot(enumitemslot);
        org.bukkit.inventory.EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot, hand);
        this.level().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (entityhuman.hasInfiniteMaterials() && itemstack1.isEmpty() && !itemstack.isEmpty()) {
            this.setItemSlot(enumitemslot, itemstack.copyWithCount(1));
            return true;
        }
        if (!itemstack.isEmpty() && itemstack.getCount() > 1) {
            if (!itemstack1.isEmpty()) {
                return false;
            }
            this.setItemSlot(enumitemslot, itemstack.split(1));
            return true;
        }
        this.setItemSlot(enumitemslot, itemstack);
        entityhuman.setItemInHand(enumhand, itemstack1);
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isRemoved()) {
            return false;
        }
        if (!worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && damagesource.getEntity() instanceof Mob) {
            return false;
        }
        if (damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f)) {
                return false;
            }
            this.kill(worldserver, damagesource);
            return false;
        }
        if (!this.isInvulnerableTo(worldserver, damagesource) && !this.isMarker()) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f, true, this.invisible)) {
                return false;
            }
            if (damagesource.is(DamageTypeTags.IS_EXPLOSION)) {
                this.brokenByAnything(worldserver, damagesource);
                this.kill(worldserver, damagesource);
                return false;
            }
            if (damagesource.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                if (this.isOnFire()) {
                    this.causeDamage(worldserver, damagesource, 0.15f);
                } else {
                    this.igniteForSeconds(5.0f);
                }
                return false;
            }
            if (damagesource.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                this.causeDamage(worldserver, damagesource, 4.0f);
                return false;
            }
            boolean flag = damagesource.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
            boolean flag1 = damagesource.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
            if (!flag && !flag1) {
                return false;
            }
            Entity entity = damagesource.getEntity();
            if (entity instanceof Player) {
                Player entityhuman = (Player)entity;
                if (!entityhuman.getAbilities().mayBuild) {
                    return false;
                }
            }
            if (damagesource.isCreativePlayer()) {
                this.playBrokenSound();
                this.showBreakingParticles();
                this.kill(worldserver, damagesource);
                return true;
            }
            long i = worldserver.getGameTime();
            if (i - this.lastHit > 5L && !flag1) {
                worldserver.broadcastEntityEvent(this, (byte)32);
                this.gameEvent(GameEvent.ENTITY_DAMAGE, damagesource.getEntity());
                this.lastHit = i;
            } else {
                this.brokenByPlayer(worldserver, damagesource);
                this.showBreakingParticles();
                this.discard(EntityRemoveEvent.Cause.DEATH);
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(b0);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return d0 < (d1 *= 64.0) * d1;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, this.getBbWidth() / 4.0f, this.getBbHeight() / 4.0f, this.getBbWidth() / 4.0f, 0.05);
        }
    }

    private void causeDamage(ServerLevel worldserver, DamageSource damagesource, float f) {
        float f1 = this.getHealth();
        if ((f1 -= f) <= 0.5f) {
            this.brokenByAnything(worldserver, damagesource);
            this.kill(worldserver, damagesource);
        } else {
            this.setHealth(f1);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, damagesource.getEntity());
        }
    }

    private void brokenByPlayer(ServerLevel worldserver, DamageSource damagesource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.ARMOR_STAND);
        itemstack.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        this.drops.add(CraftItemStack.asBukkitCopy(itemstack));
        this.brokenByAnything(worldserver, damagesource);
    }

    private void brokenByAnything(ServerLevel worldserver, DamageSource damagesource) {
        this.playBrokenSound();
        for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
            net.minecraft.world.item.ItemStack itemstack = this.equipment.set(enumitemslot, net.minecraft.world.item.ItemStack.EMPTY);
            if (itemstack.isEmpty()) continue;
            this.drops.add(CraftItemStack.asBukkitCopy(itemstack));
        }
        this.dropAllDeathLoot(worldserver, damagesource);
    }

    private void playBrokenSound() {
        this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    protected void tickHeadTurn(float f) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
    }

    @Override
    public void travel(Vec3 vec3d) {
        if (this.hasPhysics()) {
            super.travel(vec3d);
        }
    }

    @Override
    public void setYBodyRot(float f) {
        this.yBodyRotO = this.yRotO = f;
        this.yHeadRotO = this.yHeadRot = f;
    }

    @Override
    public void setYHeadRot(float f) {
        this.yBodyRotO = this.yRotO = f;
        this.yHeadRotO = this.yHeadRot = f;
    }

    @Override
    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    @Override
    public void setInvisible(boolean flag) {
        this.invisible = flag;
        super.setInvisible(flag);
    }

    @Override
    public boolean isBaby() {
        return this.isSmall();
    }

    @Override
    public boolean shouldDropExperience() {
        return true;
    }

    @Override
    public void kill(ServerLevel worldserver) {
        this.kill(worldserver, null);
    }

    public void kill(ServerLevel worldserver, DamageSource damageSource) {
        CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.damageSources().genericKill() : damageSource, this.drops);
        this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        return explosion.shouldAffectBlocklikeEntities() ? this.isInvisible() : true;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return this.isMarker() ? PushReaction.IGNORE : super.getPistonPushReaction();
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    public void setSmall(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 1, flag));
    }

    public boolean isSmall() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 4, flag));
    }

    public boolean showArms() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setNoBasePlate(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 8, flag));
    }

    public boolean showBasePlate() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 8) == 0;
    }

    public void setMarker(boolean flag) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 16, flag));
    }

    public boolean isMarker() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte b0, int i, boolean flag) {
        b0 = flag ? (byte)(b0 | i) : (byte)(b0 & ~i);
        return b0;
    }

    public void setHeadPose(Rotations vector3f) {
        this.entityData.set(DATA_HEAD_POSE, vector3f);
    }

    public void setBodyPose(Rotations vector3f) {
        this.entityData.set(DATA_BODY_POSE, vector3f);
    }

    public void setLeftArmPose(Rotations vector3f) {
        this.entityData.set(DATA_LEFT_ARM_POSE, vector3f);
    }

    public void setRightArmPose(Rotations vector3f) {
        this.entityData.set(DATA_RIGHT_ARM_POSE, vector3f);
    }

    public void setLeftLegPose(Rotations vector3f) {
        this.entityData.set(DATA_LEFT_LEG_POSE, vector3f);
    }

    public void setRightLegPose(Rotations vector3f) {
        this.entityData.set(DATA_RIGHT_LEG_POSE, vector3f);
    }

    public Rotations getHeadPose() {
        return this.entityData.get(DATA_HEAD_POSE);
    }

    public Rotations getBodyPose() {
        return this.entityData.get(DATA_BODY_POSE);
    }

    public Rotations getLeftArmPose() {
        return this.entityData.get(DATA_LEFT_ARM_POSE);
    }

    public Rotations getRightArmPose() {
        return this.entityData.get(DATA_RIGHT_ARM_POSE);
    }

    public Rotations getLeftLegPose() {
        return this.entityData.get(DATA_LEFT_LEG_POSE);
    }

    public Rotations getRightLegPose() {
        return this.entityData.get(DATA_RIGHT_LEG_POSE);
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    @Override
    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            if (!this.level().mayInteract(entityhuman, this.blockPosition())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    @Override
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    @Override
    public void thunderHit(ServerLevel worldserver, LightningBolt entitylightning) {
    }

    @Override
    public boolean isAffectedByPotions() {
        return false;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (DATA_CLIENT_FLAGS.equals(datawatcherobject)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose entitypose) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean flag) {
        return flag ? MARKER_DIMENSIONS : (this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions());
    }

    @Override
    public Vec3 getLightProbePosition(float f) {
        if (this.isMarker()) {
            AABB axisalignedbb = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPos blockposition = this.blockPosition();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockposition1 : BlockPos.betweenClosed(BlockPos.containing(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ), BlockPos.containing(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ))) {
                int j = Math.max(this.level().getBrightness(LightLayer.BLOCK, blockposition1), this.level().getBrightness(LightLayer.SKY, blockposition1));
                if (j == 15) {
                    return Vec3.atCenterOf(blockposition1);
                }
                if (j <= i) continue;
                i = j;
                blockposition = blockposition1.immutable();
            }
            return Vec3.atCenterOf(blockposition);
        }
        return super.getLightProbePosition(f);
    }

    @Override
    public net.minecraft.world.item.ItemStack getPickResult() {
        return new net.minecraft.world.item.ItemStack(Items.ARMOR_STAND);
    }

    @Override
    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }

    public void setArmorStandPose(ArmorStandPose entityarmorstand_a) {
        this.setHeadPose(entityarmorstand_a.head());
        this.setBodyPose(entityarmorstand_a.body());
        this.setLeftArmPose(entityarmorstand_a.leftArm());
        this.setRightArmPose(entityarmorstand_a.rightArm());
        this.setLeftLegPose(entityarmorstand_a.leftLeg());
        this.setRightLegPose(entityarmorstand_a.rightLeg());
    }

    public ArmorStandPose getArmorStandPose() {
        return new ArmorStandPose(this.getHeadPose(), this.getBodyPose(), this.getLeftArmPose(), this.getRightArmPose(), this.getLeftLegPose(), this.getRightLegPose());
    }

    public record ArmorStandPose(Rotations head, Rotations body, Rotations leftArm, Rotations rightArm, Rotations leftLeg, Rotations rightLeg) {
        public static final ArmorStandPose DEFAULT = new ArmorStandPose(DEFAULT_HEAD_POSE, DEFAULT_BODY_POSE, DEFAULT_LEFT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE, DEFAULT_LEFT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
        public static final Codec<ArmorStandPose> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Rotations.CODEC.optionalFieldOf("Head", (Object)DEFAULT_HEAD_POSE).forGetter(ArmorStandPose::head), (App)Rotations.CODEC.optionalFieldOf("Body", (Object)DEFAULT_BODY_POSE).forGetter(ArmorStandPose::body), (App)Rotations.CODEC.optionalFieldOf("LeftArm", (Object)DEFAULT_LEFT_ARM_POSE).forGetter(ArmorStandPose::leftArm), (App)Rotations.CODEC.optionalFieldOf("RightArm", (Object)DEFAULT_RIGHT_ARM_POSE).forGetter(ArmorStandPose::rightArm), (App)Rotations.CODEC.optionalFieldOf("LeftLeg", (Object)DEFAULT_LEFT_LEG_POSE).forGetter(ArmorStandPose::leftLeg), (App)Rotations.CODEC.optionalFieldOf("RightLeg", (Object)DEFAULT_RIGHT_LEG_POSE).forGetter(ArmorStandPose::rightLeg)).apply((Applicative)instance, ArmorStandPose::new));
    }
}

