/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    private long ticketTimer = 0L;

    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> entitytypes, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)entitytypes, world);
    }

    public ThrownEnderpearl(Level world, LivingEntity entityliving, ItemStack itemstack) {
        super(EntityType.ENDER_PEARL, entityliving, world, itemstack);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void setOwner(@Nullable EntityReference<Entity> entityreference) {
        this.deregisterFromCurrentOwner();
        super.setOwner(entityreference);
        this.registerToCurrentOwner();
    }

    private void deregisterFromCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            entityplayer.deregisterEnderPearl(this);
        }
    }

    private void registerToCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            entityplayer.registerEnderPearl(this);
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        Level world;
        if (this.owner != null && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            return this.owner.getEntity(uuid -> ThrownEnderpearl.findOwnerInAnyDimension(worldserver, uuid), Entity.class);
        }
        return super.getOwner();
    }

    @Nullable
    private static Entity findOwnerInAnyDimension(ServerLevel worldserver, UUID uuid) {
        Entity entity = worldserver.getEntity(uuid);
        if (entity != null) {
            return entity;
        }
        for (ServerLevel worldserver1 : worldserver.getServer().getAllLevels()) {
            if (worldserver1 == worldserver || (entity = worldserver1.getEntity(uuid)) == null) continue;
            return entity;
        }
        return null;
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        movingobjectpositionentity.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(HitResult movingobjectposition) {
        super.onHit(movingobjectposition);
        for (int i = 0; i < 32; ++i) {
            this.level().addParticle(ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!this.isRemoved()) {
                Entity entity = this.getOwner();
                if (entity != null && ThrownEnderpearl.isAllowedToTeleportOwner(entity, worldserver)) {
                    Vec3 vec3d = this.oldPosition();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer entityplayer = (ServerPlayer)entity;
                        if (entityplayer.connection.isAcceptingMessages()) {
                            Endermite entityendermite;
                            ServerPlayer entityplayer1 = entityplayer.teleport(new TeleportTransition(worldserver, vec3d, Vec3.ZERO, 0.0f, 0.0f, Relative.union(Relative.ROTATION, Relative.DELTA), TeleportTransition.DO_NOTHING, PlayerTeleportEvent.TeleportCause.ENDER_PEARL));
                            if (entityplayer1 == null) {
                                this.discard(EntityRemoveEvent.Cause.HIT);
                                return;
                            }
                            if (this.random.nextFloat() < 0.05f && worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (entityendermite = EntityType.ENDERMITE.create(worldserver, EntitySpawnReason.TRIGGERED)) != null) {
                                entityendermite.snapTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                                worldserver.addFreshEntity(entityendermite, CreatureSpawnEvent.SpawnReason.ENDER_PEARL);
                            }
                            if (this.isOnPortalCooldown()) {
                                entity.setPortalCooldown();
                            }
                            if (entityplayer1 != null) {
                                entityplayer1.resetFallDistance();
                                entityplayer1.resetCurrentImpulseContext();
                                entityplayer1.hurtServer(entityplayer.level(), this.damageSources().enderPearl().customEntityDamager(this), 5.0f);
                            }
                            this.playSound(worldserver, vec3d);
                        }
                    } else {
                        Entity entity1 = entity.teleport(new TeleportTransition(worldserver, vec3d, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING));
                        if (entity1 != null) {
                            entity1.resetFallDistance();
                        }
                        this.playSound(worldserver, vec3d);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
        }
    }

    private static boolean isAllowedToTeleportOwner(Entity entity, Level world) {
        if (entity.level().dimension() == world.dimension()) {
            if (!(entity instanceof LivingEntity)) {
                return entity.isAlive();
            }
            LivingEntity entityliving = (LivingEntity)entity;
            return entityliving.isAlive() && !entityliving.isSleeping();
        }
        return entity.canUsePortal(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        i = SectionPos.blockToSectionCoord(this.position().x());
        j = SectionPos.blockToSectionCoord(this.position().z());
        entity = this.getOwner();
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        entityplayer = (ServerPlayer)entity;
        if (!entity.isAlive() && entityplayer.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else lbl-1000:
        // 2 sources

        {
            super.tick();
        }
        if (this.isAlive()) {
            blockposition = BlockPos.containing(this.position());
            if ((--this.ticketTimer <= 0L || i != SectionPos.blockToSectionCoord(blockposition.getX()) || j != SectionPos.blockToSectionCoord(blockposition.getZ())) && entity instanceof ServerPlayer) {
                entityplayer1 = (ServerPlayer)entity;
                this.ticketTimer = entityplayer1.registerAndUpdateEnderPearlTicket(this);
            }
        }
    }

    private void playSound(Level world, Vec3 vec3d) {
        world.playSound((Entity)null, vec3d.x, vec3d.y, vec3d.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition teleporttransition) {
        Entity entity = super.teleport(teleporttransition);
        if (entity != null) {
            entity.placePortalTicket(BlockPos.containing(entity.position()));
        }
        return entity;
    }

    @Override
    public boolean canTeleport(Level world, Level world1) {
        Entity entity;
        if (world.getTypeKey() == LevelStem.END && world1.getTypeKey() == LevelStem.OVERWORLD && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            return super.canTeleport(world, world1) && entityplayer.seenCredits;
        }
        return super.canTeleport(world, world1);
    }

    @Override
    protected void onInsideBlock(BlockState iblockdata) {
        Entity entity;
        super.onInsideBlock(iblockdata);
        if (iblockdata.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            entityplayer.onInsideBlock(iblockdata);
        }
    }

    @Override
    public void onRemoval(Entity.RemovalReason entity_removalreason) {
        if (entity_removalreason != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            this.deregisterFromCurrentOwner();
        }
        super.onRemoval(entity_removalreason);
    }

    @Override
    public void onAboveBubbleColumn(boolean flag, BlockPos blockposition) {
        Entity.handleOnAboveBubbleColumn(this, flag, blockposition);
    }

    @Override
    public void onInsideBubbleColumn(boolean flag) {
        Entity.handleOnInsideBubbleColumn(this, flag);
    }
}

