/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryView;

public class CraftingMenu
extends AbstractCraftingMenu {
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_COUNT = 9;
    private static final int CRAFT_SLOT_END = 10;
    private static final int INV_SLOT_START = 10;
    private static final int INV_SLOT_END = 37;
    private static final int USE_ROW_SLOT_START = 37;
    private static final int USE_ROW_SLOT_END = 46;
    public final ContainerLevelAccess access;
    private final Player player;
    private boolean placingRecipe;
    private CraftInventoryView bukkitEntity = null;

    public CraftingMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, ContainerLevelAccess.NULL);
    }

    public CraftingMenu(int i, Inventory playerinventory, ContainerLevelAccess containeraccess) {
        super(MenuType.CRAFTING, i, 3, 3, playerinventory);
        this.access = containeraccess;
        this.player = playerinventory.player;
        this.addResultSlot(this.player, 124, 35);
        this.addCraftingGridSlots(30, 17);
        this.addStandardInventorySlots(playerinventory, 8, 84);
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu container, ServerLevel worldserver, Player entityhuman, CraftingContainer inventorycrafting, ResultContainer inventorycraftresult, @Nullable RecipeHolder<CraftingRecipe> recipeholder) {
        CraftingInput craftinginput = inventorycrafting.asCraftInput();
        ServerPlayer entityplayer = (ServerPlayer)entityhuman;
        ItemStack itemstack = ItemStack.EMPTY;
        Optional<RecipeHolder<CraftingRecipe>> optional = worldserver.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, craftinginput, (Level)worldserver, recipeholder);
        inventorycrafting.setCurrentRecipe(optional.orElse(null));
        if (optional.isPresent()) {
            ItemStack itemstack1;
            RecipeHolder<CraftingRecipe> recipeholder1 = optional.get();
            CraftingRecipe recipecrafting = recipeholder1.value();
            if (inventorycraftresult.setRecipeUsed(entityplayer, recipeholder1) && (itemstack1 = recipecrafting.assemble(craftinginput, worldserver.registryAccess())).isItemEnabled(worldserver.enabledFeatures())) {
                itemstack = itemstack1;
            }
        }
        itemstack = CraftEventFactory.callPreCraftEvent(inventorycrafting, inventorycraftresult, itemstack, container.getBukkitView(), optional);
        inventorycraftresult.setItem(0, itemstack);
        container.setRemoteSlot(0, itemstack);
        entityplayer.connection.send(new ClientboundContainerSetSlotPacket(container.containerId, container.incrementStateId(), 0, itemstack));
    }

    @Override
    public void slotsChanged(Container iinventory) {
        if (!this.placingRecipe) {
            this.access.execute((world, blockposition) -> {
                if (world instanceof ServerLevel) {
                    ServerLevel worldserver = (ServerLevel)world;
                    CraftingMenu.slotChangedCraftingGrid(this, worldserver, this.player, this.m, this.resultSlots, null);
                }
            });
        }
    }

    @Override
    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    @Override
    public void finishPlacingRecipe(ServerLevel worldserver, RecipeHolder<CraftingRecipe> recipeholder) {
        this.placingRecipe = false;
        CraftingMenu.slotChangedCraftingGrid(this, worldserver, this.player, this.m, this.resultSlots, recipeholder);
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.m));
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return CraftingMenu.stillValid(this.access, entityhuman, Blocks.CRAFTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i == 0) {
                itemstack1.getItem().onCraftedBy(itemstack1, entityhuman);
                if (!this.moveItemStackTo(itemstack1, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i >= 10 && i < 46 ? !this.moveItemStackTo(itemstack1, 1, 10, false) && (i < 37 ? !this.moveItemStackTo(itemstack1, 37, 46, false) : !this.moveItemStackTo(itemstack1, 10, 37, false)) : !this.moveItemStackTo(itemstack1, 10, 46, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
            if (i == 0) {
                entityhuman.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public Slot getResultSlot() {
        return (Slot)this.slots.get(0);
    }

    @Override
    public List<Slot> getInputGridSlots() {
        return this.slots.subList(1, 10);
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @Override
    protected Player owner() {
        return this.player;
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(this.m, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<CraftingMenu, CraftInventoryCrafting>(this.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }
}

