/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.ClientSideMerchant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryMerchant;
import org.bukkit.craftbukkit.v1_21_R5.inventory.view.CraftMerchantView;

public class MerchantMenu
extends AbstractContainerMenu {
    protected static final int PAYMENT1_SLOT = 0;
    protected static final int PAYMENT2_SLOT = 1;
    protected static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private static final int SELLSLOT1_X = 136;
    private static final int SELLSLOT2_X = 162;
    private static final int BUYSLOT_X = 220;
    private static final int ROW_Y = 37;
    private final Merchant trader;
    private final MerchantContainer tradeContainer;
    private int merchantLevel;
    private boolean showProgressBar;
    private boolean canRestock;
    private CraftMerchantView bukkitEntity = null;
    private Inventory player;

    @Override
    public CraftMerchantView getBukkitView() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new CraftMerchantView(this.player.player.getBukkitEntity(), new CraftInventoryMerchant(this.trader, this.tradeContainer), this, this.trader);
        }
        return this.bukkitEntity;
    }

    public MerchantMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, new ClientSideMerchant(playerinventory.player));
    }

    public MerchantMenu(int i, Inventory playerinventory, Merchant imerchant) {
        super(MenuType.MERCHANT, i);
        this.trader = imerchant;
        this.tradeContainer = new MerchantContainer(imerchant);
        this.addSlot(new Slot(this.tradeContainer, 0, 136, 37));
        this.addSlot(new Slot(this.tradeContainer, 1, 162, 37));
        this.addSlot(new MerchantResultSlot(playerinventory.player, imerchant, this.tradeContainer, 2, 220, 37));
        this.player = playerinventory;
        this.addStandardInventorySlots(playerinventory, 108, 84);
    }

    public void setShowProgressBar(boolean flag) {
        this.showProgressBar = flag;
    }

    @Override
    public void slotsChanged(Container iinventory) {
        this.tradeContainer.updateSellItem();
        super.slotsChanged(iinventory);
    }

    public void setSelectionHint(int i) {
        this.tradeContainer.setSelectionHint(i);
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.trader.stillValid(entityhuman);
    }

    public int getTraderXp() {
        return this.trader.getVillagerXp();
    }

    public int getFutureTraderXp() {
        return this.tradeContainer.getFutureXp();
    }

    public void setXp(int i) {
        this.trader.overrideXp(i);
    }

    public int getTraderLevel() {
        return this.merchantLevel;
    }

    public void setMerchantLevel(int i) {
        this.merchantLevel = i;
    }

    public void setCanRestock(boolean flag) {
        this.canRestock = flag;
    }

    public boolean canRestock() {
        return this.canRestock;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return false;
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
                this.playTradeSound();
            } else if (i != 0 && i != 1 ? (i >= 3 && i < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : i >= 30 && i < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    private void playTradeSound() {
        if (!this.trader.isClientSide() && this.trader instanceof Entity) {
            Entity entity = (Entity)((Object)this.trader);
            entity.level().playLocalSound(entity.getX(), entity.getY(), entity.getZ(), this.trader.getNotifyTradeSound(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.trader.setTradingPlayer(null);
        if (!this.trader.isClientSide()) {
            if (!entityhuman.isAlive() || entityhuman instanceof ServerPlayer && ((ServerPlayer)entityhuman).hasDisconnected()) {
                ItemStack itemstack = this.tradeContainer.removeItemNoUpdate(0);
                if (!itemstack.isEmpty()) {
                    entityhuman.drop(itemstack, false);
                }
                if (!(itemstack = this.tradeContainer.removeItemNoUpdate(1)).isEmpty()) {
                    entityhuman.drop(itemstack, false);
                }
            } else if (entityhuman instanceof ServerPlayer) {
                entityhuman.getInventory().placeItemBackInInventory(this.tradeContainer.removeItemNoUpdate(0));
                entityhuman.getInventory().placeItemBackInInventory(this.tradeContainer.removeItemNoUpdate(1));
            }
        }
    }

    public void tryMoveItems(int i) {
        if (i >= 0 && this.getOffers().size() > i) {
            ItemStack itemstack1;
            ItemStack itemstack = this.tradeContainer.getItem(0);
            if (!itemstack.isEmpty()) {
                if (!this.moveItemStackTo(itemstack, 3, 39, true)) {
                    return;
                }
                this.tradeContainer.setItem(0, itemstack);
            }
            if (!(itemstack1 = this.tradeContainer.getItem(1)).isEmpty()) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return;
                }
                this.tradeContainer.setItem(1, itemstack1);
            }
            if (this.tradeContainer.getItem(0).isEmpty() && this.tradeContainer.getItem(1).isEmpty()) {
                MerchantOffer merchantrecipe = (MerchantOffer)this.getOffers().get(i);
                this.moveFromInventoryToPaymentSlot(0, merchantrecipe.getItemCostA());
                merchantrecipe.getItemCostB().ifPresent(itemcost -> this.moveFromInventoryToPaymentSlot(1, (ItemCost)itemcost));
            }
        }
    }

    private void moveFromInventoryToPaymentSlot(int i, ItemCost itemcost) {
        for (int j = 3; j < 39; ++j) {
            ItemStack itemstack1;
            ItemStack itemstack = ((Slot)this.slots.get(j)).getItem();
            if (itemstack.isEmpty() || !itemcost.test(itemstack) || !(itemstack1 = this.tradeContainer.getItem(i)).isEmpty() && !ItemStack.isSameItemSameComponents(itemstack, itemstack1)) continue;
            int k = itemstack.getMaxStackSize();
            int l = Math.min(k - itemstack1.getCount(), itemstack.getCount());
            ItemStack itemstack2 = itemstack.copyWithCount(itemstack1.getCount() + l);
            itemstack.shrink(l);
            this.tradeContainer.setItem(i, itemstack2);
            if (itemstack2.getCount() >= k) break;
        }
    }

    public void setOffers(MerchantOffers merchantrecipelist) {
        this.trader.overrideOffers(merchantrecipelist);
    }

    public MerchantOffers getOffers() {
        return this.trader.getOffers();
    }

    public boolean showProgressBar() {
        return this.showProgressBar;
    }
}

