/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryView;

public class SmithingMenu
extends ItemCombinerMenu {
    public static final int TEMPLATE_SLOT = 0;
    public static final int BASE_SLOT = 1;
    public static final int ADDITIONAL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int TEMPLATE_SLOT_X_PLACEMENT = 8;
    public static final int BASE_SLOT_X_PLACEMENT = 26;
    public static final int ADDITIONAL_SLOT_X_PLACEMENT = 44;
    private static final int RESULT_SLOT_X_PLACEMENT = 98;
    public static final int SLOT_Y_PLACEMENT = 48;
    private final Level level;
    private final RecipePropertySet baseItemTest;
    private final RecipePropertySet templateItemTest;
    private final RecipePropertySet additionItemTest;
    private final DataSlot hasRecipeError = DataSlot.standalone();
    private CraftInventoryView bukkitEntity;

    public SmithingMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, ContainerLevelAccess.NULL);
    }

    public SmithingMenu(int i, Inventory playerinventory, ContainerLevelAccess containeraccess) {
        this(i, playerinventory, containeraccess, playerinventory.player.level());
    }

    private SmithingMenu(int i, Inventory playerinventory, ContainerLevelAccess containeraccess, Level world) {
        super(MenuType.SMITHING, i, playerinventory, containeraccess, SmithingMenu.createInputSlotDefinitions(world.recipeAccess()));
        this.level = world;
        this.baseItemTest = world.recipeAccess().propertySet(RecipePropertySet.SMITHING_BASE);
        this.templateItemTest = world.recipeAccess().propertySet(RecipePropertySet.SMITHING_TEMPLATE);
        this.additionItemTest = world.recipeAccess().propertySet(RecipePropertySet.SMITHING_ADDITION);
        this.addDataSlot(this.hasRecipeError).set(0);
    }

    private static ItemCombinerMenuSlotDefinition createInputSlotDefinitions(RecipeAccess recipeaccess) {
        RecipePropertySet recipepropertyset = recipeaccess.propertySet(RecipePropertySet.SMITHING_BASE);
        RecipePropertySet recipepropertyset1 = recipeaccess.propertySet(RecipePropertySet.SMITHING_TEMPLATE);
        RecipePropertySet recipepropertyset2 = recipeaccess.propertySet(RecipePropertySet.SMITHING_ADDITION);
        ItemCombinerMenuSlotDefinition.Builder itemcombinermenuslotdefinition_a = ItemCombinerMenuSlotDefinition.create();
        Objects.requireNonNull(recipepropertyset1);
        itemcombinermenuslotdefinition_a = itemcombinermenuslotdefinition_a.withSlot(0, 8, 48, recipepropertyset1::test);
        Objects.requireNonNull(recipepropertyset);
        itemcombinermenuslotdefinition_a = itemcombinermenuslotdefinition_a.withSlot(1, 26, 48, recipepropertyset::test);
        Objects.requireNonNull(recipepropertyset2);
        return itemcombinermenuslotdefinition_a.withSlot(2, 44, 48, recipepropertyset2::test).withResultSlot(3, 98, 48).build();
    }

    @Override
    protected boolean isValidBlock(BlockState iblockdata) {
        return iblockdata.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected void onTake(Player entityhuman, ItemStack itemstack) {
        itemstack.onCraftedBy(entityhuman, itemstack.getCount());
        this.resultSlots.awardUsedRecipes(entityhuman, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.access.execute((world, blockposition) -> world.levelEvent(1044, (BlockPos)blockposition, 0));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private SmithingRecipeInput createRecipeInput() {
        return new SmithingRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private void shrinkStackInSlot(int i) {
        ItemStack itemstack = this.inputSlots.getItem(i);
        if (!itemstack.isEmpty()) {
            itemstack.shrink(1);
            this.inputSlots.setItem(i, itemstack);
        }
    }

    @Override
    public void slotsChanged(Container iinventory) {
        super.slotsChanged(iinventory);
        if (this.level instanceof ServerLevel) {
            boolean flag = this.getSlot(0).hasItem() && this.getSlot(1).hasItem() && this.getSlot(2).hasItem() && !this.getSlot(this.getResultSlot()).hasItem();
            this.hasRecipeError.set(flag ? 1 : 0);
        }
    }

    @Override
    public void createResult() {
        Optional<RecipeHolder<Object>> optional;
        SmithingRecipeInput smithingrecipeinput = this.createRecipeInput();
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            optional = worldserver.recipeAccess().getRecipeFor(RecipeType.SMITHING, smithingrecipeinput, worldserver);
        } else {
            optional = Optional.empty();
        }
        optional.ifPresentOrElse(recipeholder -> {
            ItemStack itemstack = ((SmithingRecipe)recipeholder.value()).assemble(smithingrecipeinput, this.level.registryAccess());
            this.resultSlots.setRecipeUsed((RecipeHolder<?>)recipeholder);
            CraftEventFactory.callPrepareSmithingEvent(this.getBukkitView(), itemstack);
        }, () -> {
            this.resultSlots.setRecipeUsed(null);
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        });
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public boolean canMoveIntoInputSlots(ItemStack itemstack) {
        return this.templateItemTest.test(itemstack) && !this.getSlot(0).hasItem() ? true : (this.baseItemTest.test(itemstack) && !this.getSlot(1).hasItem() ? true : this.additionItemTest.test(itemstack) && !this.getSlot(2).hasItem());
    }

    public boolean hasRecipeError() {
        return this.hasRecipeError.get() > 0;
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventorySmithing inventory = new CraftInventorySmithing(this.access.getLocation(), this.inputSlots, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<SmithingMenu, CraftInventorySmithing>(this.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }
}

