/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BrushItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;

    public BrushItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        Player var1 = var0.getPlayer();
        if (var1 != null && this.calculateHitResult(var1).getType() == HitResult.Type.BLOCK) {
            var1.startUsingItem(var0.getHand());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.BRUSH;
    }

    @Override
    public int getUseDuration(ItemStack var0, LivingEntity var1) {
        return 200;
    }

    @Override
    public void onUseTick(Level var0, LivingEntity var1, ItemStack var2, int var3) {
        boolean var8;
        BlockHitResult var6;
        Player var4;
        block11: {
            block10: {
                if (var3 < 0 || !(var1 instanceof Player)) {
                    var1.releaseUsingItem();
                    return;
                }
                var4 = (Player)var1;
                HitResult var5 = this.calculateHitResult(var4);
                if (!(var5 instanceof BlockHitResult)) break block10;
                var6 = (BlockHitResult)var5;
                if (var5.getType() == HitResult.Type.BLOCK) break block11;
            }
            var1.releaseUsingItem();
            return;
        }
        int var7 = this.getUseDuration(var2, var1) - var3 + 1;
        boolean bl = var8 = var7 % 10 == 5;
        if (var8) {
            SoundEvent var12;
            Object var13;
            Block block;
            HumanoidArm var11;
            BlockPos var9 = var6.getBlockPos();
            BlockState var10 = var0.getBlockState(var9);
            HumanoidArm humanoidArm = var11 = var1.getUsedItemHand() == InteractionHand.MAIN_HAND ? var4.getMainArm() : var4.getMainArm().getOpposite();
            if (var10.shouldSpawnTerrainParticles() && var10.getRenderShape() != RenderShape.INVISIBLE) {
                this.spawnDustParticles(var0, var6, var10, var1.getViewVector(0.0f), var11);
            }
            if ((block = var10.getBlock()) instanceof BrushableBlock) {
                var13 = (BrushableBlock)block;
                var12 = ((BrushableBlock)var13).getBrushSound();
            } else {
                var12 = SoundEvents.BRUSH_GENERIC;
            }
            var0.playSound(var4, var9, var12, SoundSource.BLOCKS);
            if (var0 instanceof ServerLevel) {
                BrushableBlockEntity var14;
                boolean var15;
                var13 = (ServerLevel)var0;
                BlockEntity blockEntity = var0.getBlockEntity(var9);
                if (blockEntity instanceof BrushableBlockEntity && (var15 = (var14 = (BrushableBlockEntity)blockEntity).brush(var0.getGameTime(), (ServerLevel)var13, var4, var6.getDirection(), var2))) {
                    EquipmentSlot var16 = var2.equals(var4.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                    var2.hurtAndBreak(1, (LivingEntity)var4, var16);
                }
            }
        }
    }

    private HitResult calculateHitResult(Player var0) {
        return ProjectileUtil.getHitResultOnViewVector(var0, EntitySelector.CAN_BE_PICKED, var0.blockInteractionRange());
    }

    private void spawnDustParticles(Level var0, BlockHitResult var1, BlockState var2, Vec3 var3, HumanoidArm var4) {
        double var5 = 3.0;
        int var7 = var4 == HumanoidArm.RIGHT ? 1 : -1;
        int var8 = var0.getRandom().nextInt(7, 12);
        BlockParticleOption var9 = new BlockParticleOption(ParticleTypes.BLOCK, var2);
        Direction var10 = var1.getDirection();
        DustParticlesDelta var11 = DustParticlesDelta.fromDirection(var3, var10);
        Vec3 var12 = var1.getLocation();
        for (int var13 = 0; var13 < var8; ++var13) {
            var0.addParticle(var9, var12.x - (double)(var10 == Direction.WEST ? 1.0E-6f : 0.0f), var12.y, var12.z - (double)(var10 == Direction.NORTH ? 1.0E-6f : 0.0f), var11.xd() * (double)var7 * 3.0 * var0.getRandom().nextDouble(), 0.0, var11.zd() * (double)var7 * 3.0 * var0.getRandom().nextDouble());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 var0, Direction var1) {
            double var2 = 0.0;
            return switch (var1) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(var0.z(), 0.0, -var0.x());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
            };
        }
    }
}

