/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;

public record EitherHolder<T>(Either<Holder<T>, ResourceKey<T>> contents) {
    public EitherHolder(Holder<T> var0) {
        this(Either.left(var0));
    }

    public EitherHolder(ResourceKey<T> var0) {
        this(Either.right(var0));
    }

    public static <T> Codec<EitherHolder<T>> codec(ResourceKey<Registry<T>> var02, Codec<Holder<T>> var1) {
        return Codec.either(var1, (Codec)ResourceKey.codec(var02).comapFlatMap(var0 -> DataResult.error(() -> "Cannot parse as key without registry"), Function.identity())).xmap(EitherHolder::new, EitherHolder::contents);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, EitherHolder<T>> streamCodec(ResourceKey<Registry<T>> var0, StreamCodec<RegistryFriendlyByteBuf, Holder<T>> var1) {
        return StreamCodec.composite(ByteBufCodecs.either(var1, ResourceKey.streamCodec(var0)), EitherHolder::contents, EitherHolder::new);
    }

    public Optional<T> unwrap(Registry<T> var02) {
        return (Optional)this.contents.map(var0 -> Optional.of(var0.value()), var02::getOptional);
    }

    public Optional<Holder<T>> unwrap(HolderLookup.Provider var0) {
        return (Optional)this.contents.map(Optional::of, var1 -> var0.get(var1).map(var0 -> var0));
    }

    public Optional<ResourceKey<T>> key() {
        return (Optional)this.contents.map(Holder::unwrapKey, Optional::of);
    }
}

