/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class FoodOnAStickItem<T extends Entity>
extends Item {
    private final EntityType<T> canInteractWith;
    private final int consumeItemDamage;

    public FoodOnAStickItem(EntityType<T> var0, int var1, Item.Properties var2) {
        super(var2);
        this.canInteractWith = var0;
        this.consumeItemDamage = var1;
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var0.isClientSide) {
            return InteractionResult.PASS;
        }
        Entity var4 = var1.getControlledVehicle();
        if (var1.isPassenger() && var4 instanceof ItemSteerable) {
            ItemSteerable var5 = (ItemSteerable)((Object)var4);
            if (var4.getType() == this.canInteractWith && var5.boost()) {
                EquipmentSlot var6 = LivingEntity.getSlotForHand(var2);
                ItemStack var7 = var3.hurtAndConvertOnBreak(this.consumeItemDamage, Items.FISHING_ROD, var1, var6);
                return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(var7);
            }
        }
        var1.awardStat(Stats.ITEM_USED.get(this));
        return InteractionResult.PASS;
    }
}

