/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapItem
extends Item {
    public static final int IMAGE_WIDTH = 128;
    public static final int IMAGE_HEIGHT = 128;

    public MapItem(Item.Properties var0) {
        super(var0);
    }

    public static ItemStack create(ServerLevel var0, int var1, int var2, byte var3, boolean var4, boolean var5) {
        ItemStack var6 = new ItemStack(Items.FILLED_MAP);
        MapId var7 = MapItem.createNewSavedData(var0, var1, var2, var3, var4, var5, var0.dimension());
        var6.set(DataComponents.MAP_ID, var7);
        return var6;
    }

    @Nullable
    public static MapItemSavedData getSavedData(@Nullable MapId var0, Level var1) {
        return var0 == null ? null : var1.getMapData(var0);
    }

    @Nullable
    public static MapItemSavedData getSavedData(ItemStack var0, Level var1) {
        MapId var2 = var0.get(DataComponents.MAP_ID);
        return MapItem.getSavedData(var2, var1);
    }

    public static MapId createNewSavedData(ServerLevel var0, int var1, int var2, int var3, boolean var4, boolean var5, ResourceKey<Level> var6) {
        MapItemSavedData var7 = MapItemSavedData.createFresh(var1, var2, (byte)var3, var4, var5, var6);
        MapId var8 = var0.getFreeMapId();
        var0.setMapData(var8, var7);
        return var8;
    }

    public void update(Level var0, Entity var1, MapItemSavedData var2) {
        if (var0.dimension() != var2.dimension || !(var1 instanceof Player)) {
            return;
        }
        int var3 = 1 << var2.scale;
        int var4 = var2.centerX;
        int var5 = var2.centerZ;
        int var6 = Mth.floor(var1.getX() - (double)var4) / var3 + 64;
        int var7 = Mth.floor(var1.getZ() - (double)var5) / var3 + 64;
        int var8 = 128 / var3;
        if (var0.dimensionType().hasCeiling()) {
            var8 /= 2;
        }
        MapItemSavedData.HoldingPlayer var9 = var2.getHoldingPlayer((Player)var1);
        ++var9.step;
        BlockPos.MutableBlockPos var10 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos var11 = new BlockPos.MutableBlockPos();
        boolean var12 = false;
        for (int var13 = var6 - var8 + 1; var13 < var6 + var8; ++var13) {
            if ((var13 & 0xF) != (var9.step & 0xF) && !var12) continue;
            var12 = false;
            double var14 = 0.0;
            for (int var16 = var7 - var8 - 1; var16 < var7 + var8; ++var16) {
                double var28;
                if (var13 < 0 || var16 < -1 || var13 >= 128 || var16 >= 128) continue;
                int var17 = Mth.square(var13 - var6) + Mth.square(var16 - var7);
                boolean var18 = var17 > (var8 - 2) * (var8 - 2);
                int var19 = (var4 / var3 + var13 - 64) * var3;
                int var20 = (var5 / var3 + var16 - 64) * var3;
                LinkedHashMultiset var21 = LinkedHashMultiset.create();
                LevelChunk var22 = var0.getChunk(SectionPos.blockToSectionCoord(var19), SectionPos.blockToSectionCoord(var20));
                if (var22.isEmpty()) continue;
                int var23 = 0;
                double var24 = 0.0;
                if (var0.dimensionType().hasCeiling()) {
                    var26 = var19 + var20 * 231871;
                    if (((var26 = var26 * var26 * 31287121 + var26 * 11) >> 20 & 1) == 0) {
                        var21.add((Object)Blocks.DIRT.defaultBlockState().getMapColor(var0, BlockPos.ZERO), 10);
                    } else {
                        var21.add((Object)Blocks.STONE.defaultBlockState().getMapColor(var0, BlockPos.ZERO), 100);
                    }
                    var24 = 100.0;
                } else {
                    for (var26 = 0; var26 < var3; ++var26) {
                        for (int var27 = 0; var27 < var3; ++var27) {
                            BlockState var29;
                            var10.set(var19 + var26, 0, var20 + var27);
                            int var282 = var22.getHeight(Heightmap.Types.WORLD_SURFACE, var10.getX(), var10.getZ()) + 1;
                            if (var282 > var0.getMinY()) {
                                do {
                                    var10.setY(--var282);
                                } while ((var29 = var22.getBlockState(var10)).getMapColor(var0, var10) == MapColor.NONE && var282 > var0.getMinY());
                                if (var282 > var0.getMinY() && !var29.getFluidState().isEmpty()) {
                                    BlockState var31;
                                    int var30 = var282 - 1;
                                    var11.set(var10);
                                    do {
                                        var11.setY(var30--);
                                        var31 = var22.getBlockState(var11);
                                        ++var23;
                                    } while (var30 > var0.getMinY() && !var31.getFluidState().isEmpty());
                                    var29 = this.getCorrectStateForFluidBlock(var0, var29, var10);
                                }
                            } else {
                                var29 = Blocks.BEDROCK.defaultBlockState();
                            }
                            var2.checkBanners(var0, var10.getX(), var10.getZ());
                            var24 += (double)var282 / (double)(var3 * var3);
                            var21.add((Object)var29.getMapColor(var0, var10));
                        }
                    }
                }
                MapColor var26 = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)var21), (Object)MapColor.NONE);
                MapColor.Brightness var27 = var26 == MapColor.WATER ? ((var28 = (double)(var23 /= var3 * var3) * 0.1 + (double)(var13 + var16 & 1) * 0.2) < 0.5 ? MapColor.Brightness.HIGH : (var28 > 0.9 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL)) : ((var28 = (var24 - var14) * 4.0 / (double)(var3 + 4) + ((double)(var13 + var16 & 1) - 0.5) * 0.4) > 0.6 ? MapColor.Brightness.HIGH : (var28 < -0.6 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL));
                var14 = var24;
                if (var16 < 0 || var17 >= var8 * var8 || var18 && (var13 + var16 & 1) == 0) continue;
                var12 |= var2.updateColor(var13, var16, var26.getPackedId(var27));
            }
        }
    }

    private BlockState getCorrectStateForFluidBlock(Level var0, BlockState var1, BlockPos var2) {
        FluidState var3 = var1.getFluidState();
        if (!var3.isEmpty() && !var1.isFaceSturdy(var0, var2, Direction.UP)) {
            return var3.createLegacyBlock();
        }
        return var1;
    }

    private static boolean isBiomeWatery(boolean[] var0, int var1, int var2) {
        return var0[var2 * 128 + var1];
    }

    public static void renderBiomePreviewMap(ServerLevel var0, ItemStack var1) {
        int var11;
        int var10;
        MapItemSavedData var2 = MapItem.getSavedData(var1, (Level)var0);
        if (var2 == null) {
            return;
        }
        if (var0.dimension() != var2.dimension) {
            return;
        }
        int var3 = 1 << var2.scale;
        int var4 = var2.centerX;
        int var5 = var2.centerZ;
        boolean[] var6 = new boolean[16384];
        int var7 = var4 / var3 - 64;
        int var8 = var5 / var3 - 64;
        BlockPos.MutableBlockPos var9 = new BlockPos.MutableBlockPos();
        for (var10 = 0; var10 < 128; ++var10) {
            for (var11 = 0; var11 < 128; ++var11) {
                Holder<Biome> var12 = var0.getBiome(var9.set((var7 + var11) * var3, 0, (var8 + var10) * var3));
                var6[var10 * 128 + var11] = var12.is(BiomeTags.WATER_ON_MAP_OUTLINES);
            }
        }
        for (var10 = 1; var10 < 127; ++var10) {
            for (var11 = 1; var11 < 127; ++var11) {
                int var12 = 0;
                for (int var13 = -1; var13 < 2; ++var13) {
                    for (int var14 = -1; var14 < 2; ++var14) {
                        if (var13 == 0 && var14 == 0 || !MapItem.isBiomeWatery(var6, var10 + var13, var11 + var14)) continue;
                        ++var12;
                    }
                }
                MapColor.Brightness var13 = MapColor.Brightness.LOWEST;
                MapColor var14 = MapColor.NONE;
                if (MapItem.isBiomeWatery(var6, var10, var11)) {
                    var14 = MapColor.COLOR_ORANGE;
                    if (var12 > 7 && var11 % 2 == 0) {
                        switch ((var10 + (int)(Mth.sin((float)var11 + 0.0f) * 7.0f)) / 8 % 5) {
                            case 0: 
                            case 4: {
                                var13 = MapColor.Brightness.LOW;
                                break;
                            }
                            case 1: 
                            case 3: {
                                var13 = MapColor.Brightness.NORMAL;
                                break;
                            }
                            case 2: {
                                var13 = MapColor.Brightness.HIGH;
                            }
                        }
                    } else if (var12 > 7) {
                        var14 = MapColor.NONE;
                    } else if (var12 > 5) {
                        var13 = MapColor.Brightness.NORMAL;
                    } else if (var12 > 3) {
                        var13 = MapColor.Brightness.LOW;
                    } else if (var12 > 1) {
                        var13 = MapColor.Brightness.LOW;
                    }
                } else if (var12 > 0) {
                    var14 = MapColor.COLOR_BROWN;
                    var13 = var12 > 3 ? MapColor.Brightness.NORMAL : MapColor.Brightness.LOWEST;
                }
                if (var14 == MapColor.NONE) continue;
                var2.setColor(var10, var11, var14.getPackedId(var13));
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack var0, ServerLevel var1, Entity var2, @Nullable EquipmentSlot var3) {
        MapItemSavedData var4 = MapItem.getSavedData(var0, (Level)var1);
        if (var4 == null) {
            return;
        }
        if (var2 instanceof Player) {
            Player var5 = (Player)var2;
            var4.tickCarriedBy(var5, var0);
        }
        if (!var4.locked && var3 != null && var3.getType() == EquipmentSlot.Type.HAND) {
            this.update(var1, var2, var4);
        }
    }

    @Override
    public void onCraftedPostProcess(ItemStack var0, Level var1) {
        MapPostProcessing var2 = var0.remove(DataComponents.MAP_POST_PROCESSING);
        if (var2 == null) {
            return;
        }
        if (var1 instanceof ServerLevel) {
            ServerLevel var3 = (ServerLevel)var1;
            switch (var2) {
                case LOCK: {
                    MapItem.lockMap(var0, var3);
                    break;
                }
                case SCALE: {
                    MapItem.scaleMap(var0, var3);
                }
            }
        }
    }

    private static void scaleMap(ItemStack var0, ServerLevel var1) {
        MapItemSavedData var2 = MapItem.getSavedData(var0, (Level)var1);
        if (var2 != null) {
            MapId var3 = var1.getFreeMapId();
            var1.setMapData(var3, var2.scaled());
            var0.set(DataComponents.MAP_ID, var3);
        }
    }

    private static void lockMap(ItemStack var0, ServerLevel var1) {
        MapItemSavedData var2 = MapItem.getSavedData(var0, (Level)var1);
        if (var2 != null) {
            MapId var3 = var1.getFreeMapId();
            MapItemSavedData var4 = var2.locked();
            var1.setMapData(var3, var4);
            var0.set(DataComponents.MAP_ID, var3);
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        BlockState var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(BlockTags.BANNERS)) {
            MapItemSavedData var2;
            if (!var0.getLevel().isClientSide && (var2 = MapItem.getSavedData(var0.getItemInHand(), var0.getLevel())) != null && !var2.toggleBanner(var0.getLevel(), var0.getClickedPos())) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(var0);
    }
}

