/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class SolidBucketItem
extends BlockItem
implements DispensibleContainerItem {
    private final SoundEvent placeSound;

    public SolidBucketItem(Block var0, SoundEvent var1, Item.Properties var2) {
        super(var0, var2);
        this.placeSound = var1;
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        InteractionResult var1 = super.useOn(var0);
        Player var2 = var0.getPlayer();
        if (var1.consumesAction() && var2 != null) {
            var2.setItemInHand(var0.getHand(), BucketItem.getEmptySuccessItem(var0.getItemInHand(), var2));
        }
        return var1;
    }

    @Override
    protected SoundEvent getPlaceSound(BlockState var0) {
        return this.placeSound;
    }

    @Override
    public boolean emptyContents(@Nullable LivingEntity var0, Level var1, BlockPos var2, @Nullable BlockHitResult var3) {
        if (var1.isInWorldBounds(var2) && var1.isEmptyBlock(var2)) {
            if (!var1.isClientSide) {
                var1.setBlock(var2, this.getBlock().defaultBlockState(), 3);
            }
            var1.gameEvent((Entity)var0, GameEvent.FLUID_PLACE, var2);
            var1.playSound((Entity)var0, var2, this.placeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

