/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.TooltipProvider;

public record Fireworks(int flightDuration, List<FireworkExplosion> explosions) implements TooltipProvider
{
    public static final int MAX_EXPLOSIONS = 256;
    public static final Codec<Fireworks> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.UNSIGNED_BYTE.optionalFieldOf("flight_duration", (Object)0).forGetter(Fireworks::flightDuration), (App)FireworkExplosion.CODEC.sizeLimitedListOf(256).optionalFieldOf("explosions", List.of()).forGetter(Fireworks::explosions)).apply((Applicative)var0, Fireworks::new));
    public static final StreamCodec<ByteBuf, Fireworks> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, Fireworks::flightDuration, FireworkExplosion.STREAM_CODEC.apply(ByteBufCodecs.list(256)), Fireworks::explosions, Fireworks::new);

    public Fireworks {
        if (var1.size() > 256) {
            throw new IllegalArgumentException("Got " + var1.size() + " explosions, but maximum is 256");
        }
    }

    @Override
    public void addToTooltip(Item.TooltipContext var0, Consumer<Component> var1, TooltipFlag var2, DataComponentGetter var3) {
        if (this.flightDuration > 0) {
            var1.accept(Component.translatable("item.minecraft.firework_rocket.flight").append(CommonComponents.SPACE).append(String.valueOf(this.flightDuration)).withStyle(ChatFormatting.GRAY));
        }
        FireworkExplosion var4 = null;
        int var5 = 0;
        for (FireworkExplosion var7 : this.explosions) {
            if (var4 == null) {
                var4 = var7;
                var5 = 1;
                continue;
            }
            if (var4.equals(var7)) {
                ++var5;
                continue;
            }
            Fireworks.addExplosionTooltip(var1, var4, var5);
            var4 = var7;
            var5 = 1;
        }
        if (var4 != null) {
            Fireworks.addExplosionTooltip(var1, var4, var5);
        }
    }

    private static void addExplosionTooltip(Consumer<Component> var0, FireworkExplosion var12, int var2) {
        MutableComponent var3 = var12.shape().getName();
        if (var2 == 1) {
            var0.accept(Component.translatable("item.minecraft.firework_rocket.single_star", var3).withStyle(ChatFormatting.GRAY));
        } else {
            var0.accept(Component.translatable("item.minecraft.firework_rocket.multiple_stars", var2, var3).withStyle(ChatFormatting.GRAY));
        }
        var12.addAdditionalTooltip(var1 -> var0.accept(Component.literal("  ").append((Component)var1)));
    }
}

