/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapExtendingRecipe
extends ShapedRecipe {
    public MapExtendingRecipe(CraftingBookCategory var0) {
        super("", var0, ShapedRecipePattern.of(Map.of(Character.valueOf('#'), Ingredient.of((ItemLike)Items.PAPER), Character.valueOf('x'), Ingredient.of((ItemLike)Items.FILLED_MAP)), "###", "#x#", "###"), new ItemStack(Items.MAP));
    }

    @Override
    public boolean matches(CraftingInput var0, Level var1) {
        if (!super.matches(var0, var1)) {
            return false;
        }
        ItemStack var2 = MapExtendingRecipe.findFilledMap(var0);
        if (var2.isEmpty()) {
            return false;
        }
        MapItemSavedData var3 = MapItem.getSavedData(var2, var1);
        if (var3 == null) {
            return false;
        }
        if (var3.isExplorationMap()) {
            return false;
        }
        return var3.scale < 4;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.Provider var1) {
        ItemStack var2 = MapExtendingRecipe.findFilledMap(var0).copyWithCount(1);
        var2.set(DataComponents.MAP_POST_PROCESSING, MapPostProcessing.SCALE);
        return var2;
    }

    private static ItemStack findFilledMap(CraftingInput var0) {
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            ItemStack var2 = var0.getItem(var1);
            if (!var2.has(DataComponents.MAP_ID)) continue;
            return var2;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public RecipeSerializer<MapExtendingRecipe> getSerializer() {
        return RecipeSerializer.MAP_EXTENDING;
    }
}

