/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface BlockGetter
extends LevelHeightAccessor {
    public static final int MAX_BLOCK_ITERATIONS_ALONG_TRAVEL = 16;

    @Nullable
    public BlockEntity getBlockEntity(BlockPos var1);

    default public <T extends BlockEntity> Optional<T> getBlockEntity(BlockPos blockposition, BlockEntityType<T> tileentitytypes) {
        BlockEntity tileentity = this.getBlockEntity(blockposition);
        return tileentity != null && tileentity.getType() == tileentitytypes ? Optional.of(tileentity) : Optional.empty();
    }

    public BlockState getBlockState(BlockPos var1);

    public FluidState getFluidState(BlockPos var1);

    default public int getLightEmission(BlockPos blockposition) {
        return this.getBlockState(blockposition).getLightEmission();
    }

    default public Stream<BlockState> getBlockStates(AABB axisalignedbb) {
        return BlockPos.betweenClosedStream(axisalignedbb).map(this::getBlockState);
    }

    default public BlockHitResult isBlockInLine(ClipBlockStateContext clipblockstatecontext) {
        return BlockGetter.traverseBlocks(clipblockstatecontext.getFrom(), clipblockstatecontext.getTo(), clipblockstatecontext, (clipblockstatecontext1, blockposition) -> {
            BlockState iblockdata = this.getBlockState((BlockPos)blockposition);
            Vec3 vec3d = clipblockstatecontext1.getFrom().subtract(clipblockstatecontext1.getTo());
            return clipblockstatecontext1.isTargetBlock().test(iblockdata) ? new BlockHitResult(clipblockstatecontext1.getTo(), Direction.getApproximateNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(clipblockstatecontext1.getTo()), false) : null;
        }, clipblockstatecontext1 -> {
            Vec3 vec3d = clipblockstatecontext1.getFrom().subtract(clipblockstatecontext1.getTo());
            return BlockHitResult.miss(clipblockstatecontext1.getTo(), Direction.getApproximateNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(clipblockstatecontext1.getTo()));
        });
    }

    default public BlockHitResult clip(ClipContext raytrace1, BlockPos blockposition) {
        BlockState iblockdata = this.getBlockState(blockposition);
        FluidState fluid = this.getFluidState(blockposition);
        Vec3 vec3d = raytrace1.getFrom();
        Vec3 vec3d1 = raytrace1.getTo();
        VoxelShape voxelshape = raytrace1.getBlockShape(iblockdata, this, blockposition);
        BlockHitResult movingobjectpositionblock = this.clipWithInteractionOverride(vec3d, vec3d1, blockposition, voxelshape, iblockdata);
        VoxelShape voxelshape1 = raytrace1.getFluidShape(fluid, this, blockposition);
        BlockHitResult movingobjectpositionblock1 = voxelshape1.clip(vec3d, vec3d1, blockposition);
        double d0 = movingobjectpositionblock == null ? Double.MAX_VALUE : raytrace1.getFrom().distanceToSqr(movingobjectpositionblock.getLocation());
        double d1 = movingobjectpositionblock1 == null ? Double.MAX_VALUE : raytrace1.getFrom().distanceToSqr(movingobjectpositionblock1.getLocation());
        return d0 <= d1 ? movingobjectpositionblock : movingobjectpositionblock1;
    }

    default public BlockHitResult clip(ClipContext raytrace) {
        return BlockGetter.traverseBlocks(raytrace.getFrom(), raytrace.getTo(), raytrace, (raytrace1, blockposition) -> this.clip((ClipContext)raytrace1, (BlockPos)blockposition), raytrace1 -> {
            Vec3 vec3d = raytrace1.getFrom().subtract(raytrace1.getTo());
            return BlockHitResult.miss(raytrace1.getTo(), Direction.getApproximateNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(raytrace1.getTo()));
        });
    }

    @Nullable
    default public BlockHitResult clipWithInteractionOverride(Vec3 vec3d, Vec3 vec3d1, BlockPos blockposition, VoxelShape voxelshape, BlockState iblockdata) {
        BlockHitResult movingobjectpositionblock1;
        BlockHitResult movingobjectpositionblock = voxelshape.clip(vec3d, vec3d1, blockposition);
        if (movingobjectpositionblock != null && (movingobjectpositionblock1 = iblockdata.getInteractionShape(this, blockposition).clip(vec3d, vec3d1, blockposition)) != null && movingobjectpositionblock1.getLocation().subtract(vec3d).lengthSqr() < movingobjectpositionblock.getLocation().subtract(vec3d).lengthSqr()) {
            return movingobjectpositionblock.withDirection(movingobjectpositionblock1.getDirection());
        }
        return movingobjectpositionblock;
    }

    default public double getBlockFloorHeight(VoxelShape voxelshape, Supplier<VoxelShape> supplier) {
        if (!voxelshape.isEmpty()) {
            return voxelshape.max(Direction.Axis.Y);
        }
        double d0 = supplier.get().max(Direction.Axis.Y);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double getBlockFloorHeight(BlockPos blockposition) {
        return this.getBlockFloorHeight(this.getBlockState(blockposition).getCollisionShape(this, blockposition), () -> {
            BlockPos blockposition1 = blockposition.below();
            return this.getBlockState(blockposition1).getCollisionShape(this, blockposition1);
        });
    }

    public static <T, C> T traverseBlocks(Vec3 vec3d, Vec3 vec3d1, C c0, BiFunction<C, BlockPos, T> bifunction, Function<C, T> function) {
        int k;
        int j;
        if (vec3d.equals(vec3d1)) {
            return function.apply(c0);
        }
        double d0 = Mth.lerp(-1.0E-7, vec3d1.x, vec3d.x);
        double d1 = Mth.lerp(-1.0E-7, vec3d1.y, vec3d.y);
        double d2 = Mth.lerp(-1.0E-7, vec3d1.z, vec3d.z);
        double d3 = Mth.lerp(-1.0E-7, vec3d.x, vec3d1.x);
        double d4 = Mth.lerp(-1.0E-7, vec3d.y, vec3d1.y);
        double d5 = Mth.lerp(-1.0E-7, vec3d.z, vec3d1.z);
        int i = Mth.floor(d3);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos(i, j = Mth.floor(d4), k = Mth.floor(d5));
        T t0 = bifunction.apply(c0, blockposition_mutableblockposition);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = Mth.sign(d6);
        int i1 = Mth.sign(d7);
        int j1 = Mth.sign(d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.frac(d3) : Mth.frac(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.frac(d4) : Mth.frac(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.frac(d5) : Mth.frac(d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = bifunction.apply(c0, blockposition_mutableblockposition.set(i, j, k))) == null) continue;
            return t1;
        }
        return function.apply(c0);
    }

    public static boolean forEachBlockIntersectedBetween(Vec3 vec3d, Vec3 vec3d1, AABB axisalignedbb, BlockStepVisitor iblockaccess_a) {
        Vec3 vec3d2 = vec3d1.subtract(vec3d);
        if (vec3d2.lengthSqr() < (double)Mth.square(0.99999f)) {
            for (BlockPos blockposition : BlockPos.betweenClosed(axisalignedbb)) {
                if (iblockaccess_a.visit(blockposition, 0)) continue;
                return false;
            }
            return true;
        }
        LongOpenHashSet longset = new LongOpenHashSet();
        Vec3 vec3d3 = axisalignedbb.getMinPosition();
        Vec3 vec3d4 = vec3d3.subtract(vec3d2);
        int i = BlockGetter.addCollisionsAlongTravel((LongSet)longset, vec3d4, vec3d3, axisalignedbb, iblockaccess_a);
        if (i < 0) {
            return false;
        }
        for (BlockPos blockposition1 : BlockPos.betweenClosed(axisalignedbb)) {
            if (longset.contains(blockposition1.asLong()) || iblockaccess_a.visit(blockposition1, i + 1)) continue;
            return false;
        }
        return true;
    }

    private static int addCollisionsAlongTravel(LongSet longset, Vec3 vec3d, Vec3 vec3d1, AABB axisalignedbb, BlockStepVisitor iblockaccess_a) {
        Vec3 vec3d2 = vec3d1.subtract(vec3d);
        int i = Mth.floor(vec3d.x);
        int j = Mth.floor(vec3d.y);
        int k = Mth.floor(vec3d.z);
        int l = Mth.sign(vec3d2.x);
        int i1 = Mth.sign(vec3d2.y);
        int j1 = Mth.sign(vec3d2.z);
        double d0 = l == 0 ? Double.MAX_VALUE : (double)l / vec3d2.x;
        double d1 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / vec3d2.y;
        double d2 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / vec3d2.z;
        double d3 = d0 * (l > 0 ? 1.0 - Mth.frac(vec3d.x) : Mth.frac(vec3d.x));
        double d4 = d1 * (i1 > 0 ? 1.0 - Mth.frac(vec3d.y) : Mth.frac(vec3d.y));
        double d5 = d2 * (j1 > 0 ? 1.0 - Mth.frac(vec3d.z) : Mth.frac(vec3d.z));
        int k1 = 0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        while (d3 <= 1.0 || d4 <= 1.0 || d5 <= 1.0) {
            if (d3 < d4) {
                if (d3 < d5) {
                    i += l;
                    d3 += d0;
                } else {
                    k += j1;
                    d5 += d2;
                }
            } else if (d4 < d5) {
                j += i1;
                d4 += d1;
            } else {
                k += j1;
                d5 += d2;
            }
            if (k1++ > 16) break;
            Optional<Vec3> optional = AABB.clip(i, j, k, i + 1, j + 1, k + 1, vec3d, vec3d1);
            if (optional.isEmpty()) continue;
            Vec3 vec3d3 = optional.get();
            double d6 = Mth.clamp(vec3d3.x, (double)i + (double)1.0E-5f, (double)i + 1.0 - (double)1.0E-5f);
            double d7 = Mth.clamp(vec3d3.y, (double)j + (double)1.0E-5f, (double)j + 1.0 - (double)1.0E-5f);
            double d8 = Mth.clamp(vec3d3.z, (double)k + (double)1.0E-5f, (double)k + 1.0 - (double)1.0E-5f);
            int l1 = Mth.floor(d6 + axisalignedbb.getXsize());
            int i2 = Mth.floor(d7 + axisalignedbb.getYsize());
            int j2 = Mth.floor(d8 + axisalignedbb.getZsize());
            for (int k2 = i; k2 <= l1; ++k2) {
                for (int l2 = j; l2 <= i2; ++l2) {
                    for (int i3 = k; i3 <= j2; ++i3) {
                        if (!longset.add(BlockPos.asLong(k2, l2, i3)) || iblockaccess_a.visit(blockposition_mutableblockposition.set(k2, l2, i3), k1)) continue;
                        return -1;
                    }
                }
            }
        }
        return k1;
    }

    @FunctionalInterface
    public static interface BlockStepVisitor {
        public boolean visit(BlockPos var1, int var2);
    }
}

