/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class MultiNoiseBiomeSourceParameterList {
    public static final Codec<MultiNoiseBiomeSourceParameterList> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Preset.CODEC.fieldOf("preset").forGetter(var0 -> var0.preset), RegistryOps.retrieveGetter(Registries.BIOME)).apply((Applicative)var02, MultiNoiseBiomeSourceParameterList::new));
    public static final Codec<Holder<MultiNoiseBiomeSourceParameterList>> CODEC = RegistryFileCodec.create(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, DIRECT_CODEC);
    private final Preset preset;
    private final Climate.ParameterList<Holder<Biome>> parameters;

    public MultiNoiseBiomeSourceParameterList(Preset var0, HolderGetter<Biome> var1) {
        this.preset = var0;
        this.parameters = var0.provider.apply(var1::getOrThrow);
    }

    public Climate.ParameterList<Holder<Biome>> parameters() {
        return this.parameters;
    }

    public static Map<Preset, Climate.ParameterList<ResourceKey<Biome>>> knownPresets() {
        return Preset.BY_NAME.values().stream().collect(Collectors.toMap(var0 -> var0, var02 -> var02.provider().apply(var0 -> var0)));
    }

    public static final class Preset
    extends Record {
        private final ResourceLocation id;
        final SourceProvider provider;
        public static final Preset NETHER = new Preset(ResourceLocation.withDefaultNamespace("nether"), new SourceProvider(){

            @Override
            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> var0) {
                return new Climate.ParameterList(List.of(Pair.of((Object)Climate.parameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.apply(Biomes.NETHER_WASTES)), Pair.of((Object)Climate.parameters(0.0f, -0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.apply(Biomes.SOUL_SAND_VALLEY)), Pair.of((Object)Climate.parameters(0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.apply(Biomes.CRIMSON_FOREST)), Pair.of((Object)Climate.parameters(0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.375f), var0.apply(Biomes.WARPED_FOREST)), Pair.of((Object)Climate.parameters(-0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.175f), var0.apply(Biomes.BASALT_DELTAS))));
            }
        });
        public static final Preset OVERWORLD = new Preset(ResourceLocation.withDefaultNamespace("overworld"), new SourceProvider(){

            @Override
            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> var0) {
                return Preset.generateOverworldBiomes(var0);
            }
        });
        static final Map<ResourceLocation, Preset> BY_NAME = Stream.of(NETHER, OVERWORLD).collect(Collectors.toMap(Preset::id, var0 -> var0));
        public static final Codec<Preset> CODEC = ResourceLocation.CODEC.flatXmap(var0 -> Optional.ofNullable(BY_NAME.get(var0)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown preset: " + String.valueOf(var0))), var0 -> DataResult.success((Object)var0.id));

        public Preset(ResourceLocation var0, SourceProvider var1) {
            this.id = var0;
            this.provider = var1;
        }

        static <T> Climate.ParameterList<T> generateOverworldBiomes(Function<ResourceKey<Biome>, T> var0) {
            ImmutableList.Builder var1 = ImmutableList.builder();
            new OverworldBiomeBuilder().addBiomes(var2 -> var1.add((Object)var2.mapSecond(var0)));
            return new Climate.ParameterList(var1.build());
        }

        public Stream<ResourceKey<Biome>> usedBiomes() {
            return this.provider.apply(var0 -> var0).values().stream().map(Pair::getSecond).distinct();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Preset.class, "id;provider", "id", "provider"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Preset.class, "id;provider", "id", "provider"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Preset.class, "id;provider", "id", "provider"}, this, var0);
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SourceProvider provider() {
            return this.provider;
        }

        @FunctionalInterface
        static interface SourceProvider {
            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> var1);
        }
    }
}

