/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;

public class TheEndBiomeSource
extends BiomeSource {
    public static final MapCodec<TheEndBiomeSource> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group(RegistryOps.retrieveElement(Biomes.THE_END), RegistryOps.retrieveElement(Biomes.END_HIGHLANDS), RegistryOps.retrieveElement(Biomes.END_MIDLANDS), RegistryOps.retrieveElement(Biomes.SMALL_END_ISLANDS), RegistryOps.retrieveElement(Biomes.END_BARRENS)).apply((Applicative)var0, var0.stable(TheEndBiomeSource::new)));
    private final Holder<Biome> end;
    private final Holder<Biome> highlands;
    private final Holder<Biome> midlands;
    private final Holder<Biome> islands;
    private final Holder<Biome> barrens;

    public static TheEndBiomeSource create(HolderGetter<Biome> var0) {
        return new TheEndBiomeSource(var0.getOrThrow(Biomes.THE_END), var0.getOrThrow(Biomes.END_HIGHLANDS), var0.getOrThrow(Biomes.END_MIDLANDS), var0.getOrThrow(Biomes.SMALL_END_ISLANDS), var0.getOrThrow(Biomes.END_BARRENS));
    }

    private TheEndBiomeSource(Holder<Biome> var0, Holder<Biome> var1, Holder<Biome> var2, Holder<Biome> var3, Holder<Biome> var4) {
        this.end = var0;
        this.highlands = var1;
        this.midlands = var2;
        this.islands = var3;
        this.barrens = var4;
    }

    @Override
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return Stream.of(this.end, this.highlands, this.midlands, this.islands, this.barrens);
    }

    @Override
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    @Override
    public Holder<Biome> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        int var8;
        int var4 = QuartPos.toBlock(var0);
        int var5 = QuartPos.toBlock(var1);
        int var6 = QuartPos.toBlock(var2);
        int var7 = SectionPos.blockToSectionCoord(var4);
        if ((long)var7 * (long)var7 + (long)(var8 = SectionPos.blockToSectionCoord(var6)) * (long)var8 <= 4096L) {
            return this.end;
        }
        int var9 = (SectionPos.blockToSectionCoord(var4) * 2 + 1) * 8;
        int var10 = (SectionPos.blockToSectionCoord(var6) * 2 + 1) * 8;
        double var11 = var3.erosion().compute(new DensityFunction.SinglePointContext(var9, var5, var10));
        if (var11 > 0.25) {
            return this.highlands;
        }
        if (var11 >= -0.0625) {
            return this.midlands;
        }
        if (var11 < -0.21875) {
            return this.islands;
        }
        return this.barrens;
    }
}

