/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class PumpkinBlock
extends Block {
    public static final MapCodec<PumpkinBlock> CODEC = PumpkinBlock.simpleCodec(PumpkinBlock::new);

    public MapCodec<PumpkinBlock> codec() {
        return CODEC;
    }

    protected PumpkinBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        if (!var0.is(Items.SHEARS)) {
            return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
        }
        if (var2.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Direction var7 = var6.getDirection();
        Direction var8 = var7.getAxis() == Direction.Axis.Y ? var4.getDirection().getOpposite() : var7;
        var2.playSound(null, var3, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        var2.setBlock(var3, (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue(CarvedPumpkinBlock.FACING, var8), 11);
        ItemEntity var9 = new ItemEntity(var2, (double)var3.getX() + 0.5 + (double)var8.getStepX() * 0.65, (double)var3.getY() + 0.1, (double)var3.getZ() + 0.5 + (double)var8.getStepZ() * 0.65, new ItemStack(Items.PUMPKIN_SEEDS, 4));
        var9.setDeltaMovement(0.05 * (double)var8.getStepX() + var2.random.nextDouble() * 0.02, 0.05, 0.05 * (double)var8.getStepZ() + var2.random.nextDouble() * 0.02);
        var2.addFreshEntity(var9);
        var0.hurtAndBreak(1, (LivingEntity)var4, LivingEntity.getSlotForHand(var5));
        var2.gameEvent((Entity)var4, GameEvent.SHEAR, var3);
        var4.awardStat(Stats.ITEM_USED.get(Items.SHEARS));
        return InteractionResult.SUCCESS;
    }
}

