/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SculkSensorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SculkSensorBlock> CODEC = SculkSensorBlock.simpleCodec(SculkSensorBlock::new);
    public static final int ACTIVE_TICKS = 30;
    public static final int COOLDOWN_TICKS = 10;
    public static final EnumProperty<SculkSensorPhase> PHASE = BlockStateProperties.SCULK_SENSOR_PHASE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 8.0);
    private static final float[] RESONANCE_PITCH_BEND = Util.make(new float[16], afloat -> {
        int[] aint = new int[]{0, 0, 2, 4, 6, 7, 9, 10, 12, 14, 15, 18, 19, 21, 22, 24};
        for (int i = 0; i < 16; ++i) {
            afloat[i] = NoteBlock.getPitchFromNote(aint[i]);
        }
    });

    public MapCodec<? extends SculkSensorBlock> codec() {
        return CODEC;
    }

    public SculkSensorBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PHASE, SculkSensorPhase.INACTIVE)).setValue(POWER, 0)).setValue(WATERLOGGED, false));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockPos blockposition = blockactioncontext.getClickedPos();
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockposition);
        return (BlockState)this.defaultBlockState().setValue(WATERLOGGED, fluid.getType() == Fluids.WATER);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (SculkSensorBlock.getPhase(iblockdata) != SculkSensorPhase.ACTIVE) {
            if (SculkSensorBlock.getPhase(iblockdata) == SculkSensorPhase.COOLDOWN) {
                worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(PHASE, SculkSensorPhase.INACTIVE), 3);
                if (!iblockdata.getValue(WATERLOGGED).booleanValue()) {
                    worldserver.playSound((net.minecraft.world.entity.Entity)null, blockposition, SoundEvents.SCULK_CLICKING_STOP, SoundSource.BLOCKS, 1.0f, worldserver.random.nextFloat() * 0.2f + 0.8f);
                }
            }
        } else {
            SculkSensorBlock.deactivate(worldserver, blockposition, iblockdata);
        }
    }

    @Override
    public void stepOn(Level world, BlockPos blockposition, BlockState iblockdata, net.minecraft.world.entity.Entity entity) {
        if (!world.isClientSide() && SculkSensorBlock.canActivate(iblockdata) && entity.getType() != EntityType.WARDEN) {
            PlayerInteractEvent cancellable;
            if (entity instanceof Player) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            BlockEntity tileentity = world.getBlockEntity(blockposition);
            if (tileentity instanceof SculkSensorBlockEntity) {
                SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
                if (world instanceof ServerLevel) {
                    ServerLevel worldserver = (ServerLevel)world;
                    if (sculksensorblockentity.getVibrationUser().canReceiveVibration(worldserver, blockposition, GameEvent.STEP, GameEvent.Context.of(iblockdata))) {
                        sculksensorblockentity.getListener().forceScheduleVibration(worldserver, GameEvent.STEP, GameEvent.Context.of(entity), entity.position());
                    }
                }
            }
        }
        super.stepOn(world, blockposition, iblockdata, entity);
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (!(world.isClientSide() || iblockdata.is(iblockdata1.getBlock()) || iblockdata.getValue(POWER) <= 0 || world.getBlockTicks().hasScheduledTick(blockposition, this))) {
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWER, 0), 18);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (SculkSensorBlock.getPhase(iblockdata) == SculkSensorPhase.ACTIVE) {
            SculkSensorBlock.updateNeighbours(worldserver, blockposition, iblockdata);
        }
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    private static void updateNeighbours(Level world, BlockPos blockposition, BlockState iblockdata) {
        Block block = iblockdata.getBlock();
        world.updateNeighborsAt(blockposition, block);
        world.updateNeighborsAt(blockposition.below(), block);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new SculkSensorBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return !world.isClientSide ? SculkSensorBlock.createTickerHelper(tileentitytypes, BlockEntityType.SCULK_SENSOR, (world1, blockposition, iblockdata1, sculksensorblockentity) -> VibrationSystem.Ticker.tick(world1, sculksensorblockentity.getVibrationData(), sculksensorblockentity.getVibrationUser())) : null;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWER);
    }

    @Override
    public int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return enumdirection == Direction.UP ? iblockdata.getSignal(iblockaccess, blockposition, enumdirection) : 0;
    }

    public static SculkSensorPhase getPhase(BlockState iblockdata) {
        return iblockdata.getValue(PHASE);
    }

    public static boolean canActivate(BlockState iblockdata) {
        return SculkSensorBlock.getPhase(iblockdata) == SculkSensorPhase.INACTIVE;
    }

    public static void deactivate(Level world, BlockPos blockposition, BlockState iblockdata) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), iblockdata.getValue(POWER).intValue(), 0);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0) {
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWER, eventRedstone.getNewCurrent()), 3);
            return;
        }
        world.setBlock(blockposition, (BlockState)((BlockState)iblockdata.setValue(PHASE, SculkSensorPhase.COOLDOWN)).setValue(POWER, 0), 3);
        world.scheduleTick(blockposition, iblockdata.getBlock(), 10);
        SculkSensorBlock.updateNeighbours(world, blockposition, iblockdata);
    }

    @VisibleForTesting
    public int getActiveTicks() {
        return 30;
    }

    public void activate(@Nullable net.minecraft.world.entity.Entity entity, Level world, BlockPos blockposition, BlockState iblockdata, int i, int j) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), iblockdata.getValue(POWER).intValue(), i);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        i = eventRedstone.getNewCurrent();
        world.setBlock(blockposition, (BlockState)((BlockState)iblockdata.setValue(PHASE, SculkSensorPhase.ACTIVE)).setValue(POWER, i), 3);
        world.scheduleTick(blockposition, iblockdata.getBlock(), this.getActiveTicks());
        SculkSensorBlock.updateNeighbours(world, blockposition, iblockdata);
        SculkSensorBlock.tryResonateVibration(entity, world, blockposition, j);
        world.gameEvent(entity, GameEvent.SCULK_SENSOR_TENDRILS_CLICKING, blockposition);
        if (!iblockdata.getValue(WATERLOGGED).booleanValue()) {
            world.playSound((net.minecraft.world.entity.Entity)null, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEvents.SCULK_CLICKING, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.2f + 0.8f);
        }
    }

    public static void tryResonateVibration(@Nullable net.minecraft.world.entity.Entity entity, Level world, BlockPos blockposition, int i) {
        for (Direction enumdirection : Direction.values()) {
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            BlockState iblockdata = world.getBlockState(blockposition1);
            if (!iblockdata.is(BlockTags.VIBRATION_RESONATORS)) continue;
            world.gameEvent(VibrationSystem.getResonanceEventByFrequency(i), blockposition1, GameEvent.Context.of(entity, iblockdata));
            float f = RESONANCE_PITCH_BEND[i];
            world.playSound((net.minecraft.world.entity.Entity)null, blockposition1, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 1.0f, f);
        }
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        Direction enumdirection;
        if (SculkSensorBlock.getPhase(iblockdata) == SculkSensorPhase.ACTIVE && (enumdirection = Direction.getRandom(randomsource)) != Direction.UP && enumdirection != Direction.DOWN) {
            double d0 = (double)blockposition.getX() + 0.5 + (enumdirection.getStepX() == 0 ? 0.5 - randomsource.nextDouble() : (double)enumdirection.getStepX() * 0.6);
            double d1 = (double)blockposition.getY() + 0.25;
            double d2 = (double)blockposition.getZ() + 0.5 + (enumdirection.getStepZ() == 0 ? 0.5 - randomsource.nextDouble() : (double)enumdirection.getStepZ() * 0.6);
            double d3 = (double)randomsource.nextFloat() * 0.04;
            world.addParticle(DustColorTransitionOptions.SCULK_TO_REDSTONE, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(PHASE, POWER, WATERLOGGED);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
            return SculkSensorBlock.getPhase(iblockdata) == SculkSensorPhase.ACTIVE ? sculksensorblockentity.getLastVibrationFrequency() : 0;
        }
        return 0;
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState iblockdata) {
        return true;
    }

    @Override
    protected void spawnAfterBreak(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        super.spawnAfterBreak(iblockdata, worldserver, blockposition, itemstack, flag);
    }

    @Override
    public int getExpDrop(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.of(5));
        }
        return 0;
    }
}

