/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShulkerBoxBlock
extends BaseEntityBlock {
    public static final MapCodec<ShulkerBoxBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(var0 -> Optional.ofNullable(var0.color)), ShulkerBoxBlock.propertiesCodec()).apply((Applicative)var02, (var0, var1) -> new ShulkerBoxBlock(var0.orElse(null), (BlockBehaviour.Properties)var1)));
    public static final Map<Direction, VoxelShape> SHAPES_OPEN_SUPPORT = Shapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace("contents");
    @Nullable
    public final DyeColor color;

    public MapCodec<ShulkerBoxBlock> codec() {
        return CODEC;
    }

    public ShulkerBoxBlock(@Nullable DyeColor var0, BlockBehaviour.Properties var1) {
        super(var1);
        this.color = var0;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.UP));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new ShulkerBoxBlockEntity(this.color, var0, var1);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        return ShulkerBoxBlock.createTickerHelper(var2, BlockEntityType.SHULKER_BOX, ShulkerBoxBlockEntity::tick);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        if (var1 instanceof ServerLevel) {
            ShulkerBoxBlockEntity var6;
            ServerLevel var5 = (ServerLevel)var1;
            BlockEntity blockEntity = var1.getBlockEntity(var2);
            if (blockEntity instanceof ShulkerBoxBlockEntity && ShulkerBoxBlock.canOpen(var0, var1, var2, var6 = (ShulkerBoxBlockEntity)blockEntity)) {
                var3.openMenu(var6);
                var3.awardStat(Stats.OPEN_SHULKER_BOX);
                PiglinAi.angerNearbyPiglins(var5, var3, true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean canOpen(BlockState var0, Level var1, BlockPos var2, ShulkerBoxBlockEntity var3) {
        if (var3.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB var4 = Shulker.getProgressDeltaAabb(1.0f, var0.getValue(FACING), 0.0f, 0.5f, var2.getBottomCenter()).deflate(1.0E-6);
        return var1.noCollision(var4);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        return (BlockState)this.defaultBlockState().setValue(FACING, var0.getClickedFace());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING);
    }

    @Override
    public BlockState playerWillDestroy(Level var0, BlockPos var1, BlockState var2, Player var3) {
        BlockEntity var4 = var0.getBlockEntity(var1);
        if (var4 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity var5 = (ShulkerBoxBlockEntity)var4;
            if (!var0.isClientSide && var3.preventsBlockDrops() && !var5.isEmpty()) {
                ItemStack var6 = ShulkerBoxBlock.getColoredItemStack(this.getColor());
                var6.applyComponents(var4.collectComponents());
                ItemEntity var7 = new ItemEntity(var0, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, var6);
                var7.setDefaultPickUpDelay();
                var0.addFreshEntity(var7);
            } else {
                var5.unpackLootTable(var3);
            }
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    protected List<ItemStack> getDrops(BlockState var0, LootParams.Builder var12) {
        BlockEntity var2 = var12.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (var2 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity var3 = (ShulkerBoxBlockEntity)var2;
            var12 = var12.withDynamicDrop(CONTENTS, var1 -> {
                for (int var2 = 0; var2 < var3.getContainerSize(); ++var2) {
                    var1.accept(var3.getItem(var2));
                }
            });
        }
        return super.getDrops(var0, var12);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        Containers.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState var0, BlockGetter var1, BlockPos var2) {
        ShulkerBoxBlockEntity var4;
        BlockEntity var3 = var1.getBlockEntity(var2);
        if (var3 instanceof ShulkerBoxBlockEntity && !(var4 = (ShulkerBoxBlockEntity)var3).isClosed()) {
            return SHAPES_OPEN_SUPPORT.get(var0.getValue(FACING).getOpposite());
        }
        return Shapes.block();
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        BlockEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity var5 = (ShulkerBoxBlockEntity)var4;
            return Shapes.create(var5.getBoundingBox(var0));
        }
        return Shapes.block();
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState var0) {
        return false;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    public static Block getBlockByColor(@Nullable DyeColor var0) {
        if (var0 == null) {
            return Blocks.SHULKER_BOX;
        }
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_SHULKER_BOX;
            case DyeColor.ORANGE -> Blocks.ORANGE_SHULKER_BOX;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_SHULKER_BOX;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_SHULKER_BOX;
            case DyeColor.YELLOW -> Blocks.YELLOW_SHULKER_BOX;
            case DyeColor.LIME -> Blocks.LIME_SHULKER_BOX;
            case DyeColor.PINK -> Blocks.PINK_SHULKER_BOX;
            case DyeColor.GRAY -> Blocks.GRAY_SHULKER_BOX;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_SHULKER_BOX;
            case DyeColor.CYAN -> Blocks.CYAN_SHULKER_BOX;
            case DyeColor.BLUE -> Blocks.BLUE_SHULKER_BOX;
            case DyeColor.BROWN -> Blocks.BROWN_SHULKER_BOX;
            case DyeColor.GREEN -> Blocks.GREEN_SHULKER_BOX;
            case DyeColor.RED -> Blocks.RED_SHULKER_BOX;
            case DyeColor.BLACK -> Blocks.BLACK_SHULKER_BOX;
            case DyeColor.PURPLE -> Blocks.PURPLE_SHULKER_BOX;
        };
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor var0) {
        return new ItemStack(ShulkerBoxBlock.getBlockByColor(var0));
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }
}

