/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.block.TNTPrimeEvent;

public class TntBlock
extends Block {
    public static final MapCodec<TntBlock> CODEC = TntBlock.simpleCodec(TntBlock::new);
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public MapCodec<TntBlock> codec() {
        return CODEC;
    }

    public TntBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(UNSTABLE, false));
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock()) && world.hasNeighborSignal(blockposition) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.REDSTONE, null, null) && TntBlock.prime(world, blockposition)) {
            world.removeBlock(blockposition, false);
        }
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (world.hasNeighborSignal(blockposition) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.REDSTONE, null, null) && TntBlock.prime(world, blockposition)) {
            world.removeBlock(blockposition, false);
        }
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        if (!world.isClientSide() && !entityhuman.getAbilities().instabuild && iblockdata.getValue(UNSTABLE).booleanValue() && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.BLOCK_BREAK, entityhuman, null)) {
            TntBlock.prime(world, blockposition);
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    public void wasExploded(ServerLevel worldserver, BlockPos blockposition, Explosion explosion) {
        if (worldserver.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
            PrimedTnt entitytntprimed = new PrimedTnt(worldserver, (double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, explosion.getIndirectSourceEntity());
            int i = entitytntprimed.getFuse();
            entitytntprimed.setFuse((short)(worldserver.random.nextInt(i / 4) + i / 8));
            worldserver.addFreshEntity(entitytntprimed);
        }
    }

    public static boolean prime(Level world, BlockPos blockposition) {
        return TntBlock.prime(world, blockposition, null);
    }

    private static boolean prime(Level world, BlockPos blockposition, @Nullable LivingEntity entityliving) {
        ServerLevel worldserver;
        if (world instanceof ServerLevel && (worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
            PrimedTnt entitytntprimed = new PrimedTnt(world, (double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, entityliving);
            world.addFreshEntity(entitytntprimed);
            world.playSound((Entity)null, entitytntprimed.getX(), entitytntprimed.getY(), entitytntprimed.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)entityliving, GameEvent.PRIME_FUSE, blockposition);
            return true;
        }
        return false;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        ServerLevel worldserver;
        if (!itemstack.is(Items.FLINT_AND_STEEL) && !itemstack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
        }
        if (!CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PLAYER, entityhuman, null)) {
            return InteractionResult.CONSUME;
        }
        if (TntBlock.prime(world, blockposition, entityhuman)) {
            world.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 11);
            Item item = itemstack.getItem();
            if (itemstack.is(Items.FLINT_AND_STEEL)) {
                itemstack.hurtAndBreak(1, (LivingEntity)entityhuman, LivingEntity.getSlotForHand(enumhand));
            } else {
                itemstack.consume(1, entityhuman);
            }
            entityhuman.awardStat(Stats.ITEM_USED.get(item));
        } else if (world instanceof ServerLevel && !(worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
            entityhuman.displayClientMessage(Component.translatable("block.minecraft.tnt.disabled"), true);
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            Entity entity = iprojectile.getOwner();
            if (iprojectile.isOnFire() && iprojectile.mayInteract(worldserver, blockposition) && CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.AIR.defaultBlockState()) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PROJECTILE, iprojectile, null) && TntBlock.prime(world, blockposition, entity instanceof LivingEntity ? (LivingEntity)entity : null)) {
                world.removeBlock(blockposition, false);
            }
        }
    }

    @Override
    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(UNSTABLE);
    }
}

