/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class TurtleEggBlock
extends Block {
    public static final MapCodec<TurtleEggBlock> CODEC = TurtleEggBlock.simpleCodec(TurtleEggBlock::new);
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final IntegerProperty EGGS = BlockStateProperties.EGGS;
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    private static final VoxelShape SHAPE_SINGLE = Block.box(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape SHAPE_MULTIPLE = Block.column(14.0, 0.0, 7.0);

    public MapCodec<TurtleEggBlock> codec() {
        return CODEC;
    }

    public TurtleEggBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HATCH, 0)).setValue(EGGS, 1));
    }

    @Override
    public void stepOn(Level world, BlockPos blockposition, BlockState iblockdata, net.minecraft.world.entity.Entity entity) {
        if (!entity.isSteppingCarefully()) {
            this.destroyEgg(world, iblockdata, blockposition, entity, 100);
        }
        super.stepOn(world, blockposition, iblockdata, entity);
    }

    @Override
    public void fallOn(Level world, BlockState iblockdata, BlockPos blockposition, net.minecraft.world.entity.Entity entity, double d0) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(world, iblockdata, blockposition, entity, 3);
        }
        super.fallOn(world, iblockdata, blockposition, entity, d0);
    }

    private void destroyEgg(Level world, BlockState iblockdata, BlockPos blockposition, net.minecraft.world.entity.Entity entity, int i) {
        ServerLevel worldserver;
        if (iblockdata.is(Blocks.TURTLE_EGG) && world instanceof ServerLevel && this.canDestroyEgg(worldserver = (ServerLevel)world, entity) && world.random.nextInt(i) == 0) {
            PlayerInteractEvent cancellable;
            if (entity instanceof Player) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(worldserver, blockposition));
                worldserver.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.decreaseEggs(worldserver, blockposition, iblockdata);
        }
    }

    private void decreaseEggs(Level world, BlockPos blockposition, BlockState iblockdata) {
        world.playSound((net.minecraft.world.entity.Entity)null, blockposition, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + world.random.nextFloat() * 0.2f);
        int i = iblockdata.getValue(EGGS);
        if (i <= 1) {
            world.destroyBlock(blockposition, false);
        } else {
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(EGGS, i - 1), 2);
            world.gameEvent(GameEvent.BLOCK_DESTROY, blockposition, GameEvent.Context.of(iblockdata));
            world.levelEvent(2001, blockposition, Block.getId(iblockdata));
        }
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (this.shouldUpdateHatchLevel(worldserver) && TurtleEggBlock.onSand(worldserver, blockposition)) {
            int i = iblockdata.getValue(HATCH);
            if (i < 2) {
                if (!CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(HATCH, i + 1), 2)) {
                    return;
                }
                worldserver.playSound((net.minecraft.world.entity.Entity)null, blockposition, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + randomsource.nextFloat() * 0.2f);
                worldserver.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(iblockdata));
            } else {
                if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, Blocks.AIR.defaultBlockState()).isCancelled()) {
                    return;
                }
                worldserver.playSound((net.minecraft.world.entity.Entity)null, blockposition, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + randomsource.nextFloat() * 0.2f);
                worldserver.removeBlock(blockposition, false);
                worldserver.gameEvent(GameEvent.BLOCK_DESTROY, blockposition, GameEvent.Context.of(iblockdata));
                for (int j = 0; j < iblockdata.getValue(EGGS); ++j) {
                    worldserver.levelEvent(2001, blockposition, Block.getId(iblockdata));
                    Turtle entityturtle = EntityType.TURTLE.create(worldserver, EntitySpawnReason.BREEDING);
                    if (entityturtle == null) continue;
                    entityturtle.setAge(-24000);
                    entityturtle.setHomePos(blockposition);
                    entityturtle.snapTo((double)blockposition.getX() + 0.3 + (double)j * 0.2, blockposition.getY(), (double)blockposition.getZ() + 0.3, 0.0f, 0.0f);
                    worldserver.addFreshEntity(entityturtle, CreatureSpawnEvent.SpawnReason.EGG);
                }
            }
        }
    }

    public static boolean onSand(BlockGetter iblockaccess, BlockPos blockposition) {
        return TurtleEggBlock.isSand(iblockaccess, blockposition.below());
    }

    public static boolean isSand(BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockaccess.getBlockState(blockposition).is(BlockTags.SAND);
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (TurtleEggBlock.onSand(world, blockposition) && !world.isClientSide) {
            world.levelEvent(2012, blockposition, 15);
        }
    }

    private boolean shouldUpdateHatchLevel(Level world) {
        float f = world.getTimeOfDay(1.0f);
        return (double)f < 0.69 && (double)f > 0.65 ? true : world.random.nextInt(500) == 0;
    }

    @Override
    public void playerDestroy(Level world, Player entityhuman, BlockPos blockposition, BlockState iblockdata, @Nullable BlockEntity tileentity, ItemStack itemstack) {
        super.playerDestroy(world, entityhuman, blockposition, iblockdata, tileentity, itemstack);
        this.decreaseEggs(world, blockposition, iblockdata);
    }

    @Override
    protected boolean canBeReplaced(BlockState iblockdata, BlockPlaceContext blockactioncontext) {
        return !blockactioncontext.isSecondaryUseActive() && blockactioncontext.getItemInHand().is(this.asItem()) && iblockdata.getValue(EGGS) < 4 ? true : super.canBeReplaced(iblockdata, blockactioncontext);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos());
        return iblockdata.is(this) ? (BlockState)iblockdata.setValue(EGGS, Math.min(4, iblockdata.getValue(EGGS) + 1)) : super.getStateForPlacement(blockactioncontext);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return iblockdata.getValue(EGGS) == 1 ? SHAPE_SINGLE : SHAPE_MULTIPLE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(HATCH, EGGS);
    }

    private boolean canDestroyEgg(ServerLevel worldserver, net.minecraft.world.entity.Entity entity) {
        return !(entity instanceof Turtle) && !(entity instanceof Bat) ? (!(entity instanceof LivingEntity) ? false : entity instanceof Player || worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) : false;
    }
}

