/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallHangingSignBlock
extends SignBlock {
    public static final MapCodec<WallHangingSignBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(SignBlock::type), WallHangingSignBlock.propertiesCodec()).apply((Applicative)instance, WallHangingSignBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction.Axis, VoxelShape> SHAPES_PLANK = Shapes.rotateHorizontalAxis(Block.column(16.0, 4.0, 14.0, 16.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPES = Shapes.rotateHorizontalAxis(Shapes.or(SHAPES_PLANK.get(Direction.Axis.Z), Block.column(14.0, 2.0, 0.0, 10.0)));

    public MapCodec<WallHangingSignBlock> codec() {
        return CODEC;
    }

    public WallHangingSignBlock(WoodType blockpropertywood, BlockBehaviour.Properties blockbase_info) {
        super(blockpropertywood, blockbase_info.sound(blockpropertywood.hangingSignSoundType()));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        SignBlockEntity tileentitysign;
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof SignBlockEntity && this.shouldTryToChainAnotherHangingSign(iblockdata, entityhuman, movingobjectpositionblock, tileentitysign = (SignBlockEntity)tileentity, itemstack)) {
            return InteractionResult.PASS;
        }
        return super.useItemOn(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
    }

    private boolean shouldTryToChainAnotherHangingSign(BlockState iblockdata, Player entityhuman, BlockHitResult movingobjectpositionblock, SignBlockEntity tileentitysign, ItemStack itemstack) {
        return !tileentitysign.canExecuteClickCommands(tileentitysign.isFacingFrontText(entityhuman), entityhuman) && itemstack.getItem() instanceof HangingSignItem && !this.isHittingEditableSide(movingobjectpositionblock, iblockdata);
    }

    private boolean isHittingEditableSide(BlockHitResult movingobjectpositionblock, BlockState iblockdata) {
        return movingobjectpositionblock.getDirection().getAxis() == iblockdata.getValue(FACING).getAxis();
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES.get(iblockdata.getValue(FACING).getAxis());
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return this.getShape(iblockdata, iblockaccess, blockposition, CollisionContext.empty());
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES_PLANK.get(iblockdata.getValue(FACING).getAxis());
    }

    public boolean canPlace(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        Direction enumdirection = iblockdata.getValue(FACING).getClockWise();
        Direction enumdirection1 = iblockdata.getValue(FACING).getCounterClockWise();
        return this.canAttachTo(iworldreader, iblockdata, blockposition.relative(enumdirection), enumdirection1) || this.canAttachTo(iworldreader, iblockdata, blockposition.relative(enumdirection1), enumdirection);
    }

    public boolean canAttachTo(LevelReader iworldreader, BlockState iblockdata, BlockPos blockposition, Direction enumdirection) {
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition);
        return iblockdata1.is(BlockTags.WALL_HANGING_SIGNS) ? iblockdata1.getValue(FACING).getAxis().test(iblockdata.getValue(FACING)) : iblockdata1.isFaceSturdy(iworldreader, blockposition, enumdirection, SupportType.FULL);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = this.defaultBlockState();
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        Level iworldreader = blockactioncontext.getLevel();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        for (Direction enumdirection : blockactioncontext.getNearestLookingDirections()) {
            Direction enumdirection1;
            if (!enumdirection.getAxis().isHorizontal() || enumdirection.getAxis().test(blockactioncontext.getClickedFace()) || !(iblockdata = (BlockState)iblockdata.setValue(FACING, enumdirection1 = enumdirection.getOpposite())).canSurvive(iworldreader, blockposition) || !this.canPlace(iblockdata, iworldreader, blockposition)) continue;
            return (BlockState)iblockdata.setValue(WATERLOGGED, fluid.getType() == Fluids.WATER);
        }
        return null;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return enumdirection.getAxis() == iblockdata.getValue(FACING).getClockWise().getAxis() && !iblockdata.canSurvive(iworldreader, blockposition) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public float getYRotationDegrees(BlockState iblockdata) {
        return iblockdata.getValue(FACING).toYRot();
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, WATERLOGGED);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new HangingSignBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return null;
    }
}

