/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;

public abstract class BlockEntity {
    public CustomTimingsHandler tickTimer = SpigotTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Codec<BlockEntityType<?>> TYPE_CODEC = BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private net.minecraft.world.level.block.state.BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public BlockEntity(BlockEntityType<?> tileentitytypes, BlockPos blockposition, net.minecraft.world.level.block.state.BlockState iblockdata) {
        this.type = tileentitytypes;
        this.worldPosition = blockposition.immutable();
        this.validateBlockState(iblockdata);
        this.blockState = iblockdata;
    }

    private void validateBlockState(net.minecraft.world.level.block.state.BlockState iblockdata) {
        if (!this.isValidBlockState(iblockdata)) {
            String s = this.getNameForReporting();
            throw new IllegalStateException("Invalid block entity " + s + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(iblockdata));
        }
    }

    public boolean isValidBlockState(net.minecraft.world.level.block.state.BlockState iblockdata) {
        return this.type.isValid(iblockdata);
    }

    public static BlockPos getPosFromTag(ChunkPos chunkcoordintpair, CompoundTag nbttagcompound) {
        int i = nbttagcompound.getIntOr("x", 0);
        int j = nbttagcompound.getIntOr("y", 0);
        int k = nbttagcompound.getIntOr("z", 0);
        int l = SectionPos.blockToSectionCoord(i);
        int i1 = SectionPos.blockToSectionCoord(k);
        if (chunkcoordintpair != null && (l != chunkcoordintpair.x || i1 != chunkcoordintpair.z)) {
            LOGGER.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)nbttagcompound, (Object)chunkcoordintpair);
            i = chunkcoordintpair.getBlockX(SectionPos.sectionRelative(i));
            k = chunkcoordintpair.getBlockZ(SectionPos.sectionRelative(k));
        }
        return new BlockPos(i, j, k);
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level world) {
        this.level = world;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(ValueInput valueinput) {
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
        valueinput.child("PublicBukkitValues").ifPresent(persistentDataTag -> this.persistentDataContainer.putAll((ValueInput)persistentDataTag));
    }

    public final void loadWithComponents(ValueInput valueinput) {
        this.loadAdditional(valueinput);
        this.components = valueinput.read("components", DataComponentMap.CODEC).orElse(DataComponentMap.EMPTY);
    }

    public final void loadCustomOnly(ValueInput valueinput) {
        this.loadAdditional(valueinput);
    }

    protected void saveAdditional(ValueOutput valueoutput) {
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider holderlookup_a) {
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, holderlookup_a);
            this.saveWithFullMetadata(tagvalueoutput);
            CompoundTag compoundTag = tagvalueoutput.buildResult();
            return compoundTag;
        }
    }

    public void saveWithFullMetadata(ValueOutput valueoutput) {
        this.saveWithoutMetadata(valueoutput);
        this.saveMetadata(valueoutput);
    }

    public void saveWithId(ValueOutput valueoutput) {
        this.saveWithoutMetadata(valueoutput);
        this.saveId(valueoutput);
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider holderlookup_a) {
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, holderlookup_a);
            this.saveWithoutMetadata(tagvalueoutput);
            CompoundTag compoundTag = tagvalueoutput.buildResult();
            return compoundTag;
        }
    }

    public void saveWithoutMetadata(ValueOutput valueoutput) {
        this.saveAdditional(valueoutput);
        valueoutput.store("components", DataComponentMap.CODEC, this.components);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            this.persistentDataContainer.store(valueoutput.child("PublicBukkitValues"));
        }
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider holderlookup_a) {
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, holderlookup_a);
            this.saveCustomOnly(tagvalueoutput);
            CompoundTag compoundTag = tagvalueoutput.buildResult();
            return compoundTag;
        }
    }

    public void saveCustomOnly(ValueOutput valueoutput) {
        this.saveAdditional(valueoutput);
    }

    private void saveId(ValueOutput valueoutput) {
        BlockEntity.addEntityType(valueoutput, this.getType());
    }

    public static void addEntityType(ValueOutput valueoutput, BlockEntityType<?> tileentitytypes) {
        valueoutput.store("id", TYPE_CODEC, tileentitytypes);
    }

    private void saveMetadata(ValueOutput valueoutput) {
        this.saveId(valueoutput);
        valueoutput.putInt("x", this.worldPosition.getX());
        valueoutput.putInt("y", this.worldPosition.getY());
        valueoutput.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos blockposition, net.minecraft.world.level.block.state.BlockState iblockdata, CompoundTag nbttagcompound, HolderLookup.Provider holderlookup_a) {
        Object tileentity;
        BlockEntityType tileentitytypes = nbttagcompound.read("id", TYPE_CODEC).orElse(null);
        if (tileentitytypes == null) {
            LOGGER.error("Skipping block entity with invalid type: {}", (Object)nbttagcompound.get("id"));
            return null;
        }
        try {
            tileentity = tileentitytypes.create(blockposition, iblockdata);
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to create block entity {} for block {} at position {} ", new Object[]{tileentitytypes, blockposition, iblockdata, throwable});
            return null;
        }
        ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(((BlockEntity)tileentity).problemPath(), LOGGER);
        try {
            ((BlockEntity)tileentity).loadWithComponents(TagValueInput.create((ProblemReporter)problemreporter_j, holderlookup_a, nbttagcompound));
            Object t = tileentity;
            problemreporter_j.close();
            return t;
        }
        catch (Throwable throwable) {
            try {
                try {
                    problemreporter_j.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable1) {
                LOGGER.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{tileentitytypes, blockposition, iblockdata, throwable1});
                return null;
            }
        }
    }

    public void setChanged() {
        if (this.level != null) {
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level world, BlockPos blockposition, net.minecraft.world.level.block.state.BlockState iblockdata) {
        world.blockEntityChanged(blockposition);
        if (!iblockdata.isAir()) {
            world.updateNeighbourForOutputSignal(blockposition, iblockdata.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public net.minecraft.world.level.block.state.BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public void preRemoveSideEffects(BlockPos blockposition, net.minecraft.world.level.block.state.BlockState iblockdata) {
        BlockEntity blockEntity = this;
        if (blockEntity instanceof Container) {
            Container iinventory = (Container)((Object)blockEntity);
            if (this.level != null) {
                Containers.dropContents(this.level, blockposition, iinventory);
            }
        }
    }

    public boolean triggerEvent(int i, int j) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory crashreportsystemdetails) {
        crashreportsystemdetails.setDetail("Name", this::getNameForReporting);
        net.minecraft.world.level.block.state.BlockState iblockdata = this.getBlockState();
        Objects.requireNonNull(iblockdata);
        crashreportsystemdetails.setDetail("Cached block", iblockdata::toString);
        if (this.level == null) {
            crashreportsystemdetails.setDetail("Block location", () -> String.valueOf(this.worldPosition) + " (world missing)");
        } else {
            iblockdata = this.level.getBlockState(this.worldPosition);
            Objects.requireNonNull(iblockdata);
            crashreportsystemdetails.setDetail("Actual block", iblockdata::toString);
            CrashReportCategory.populateBlockLocationDetails(crashreportsystemdetails, this.level, this.worldPosition);
        }
    }

    public String getNameForReporting() {
        String s = String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType()));
        return s + " // " + this.getClass().getCanonicalName();
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(net.minecraft.world.level.block.state.BlockState iblockdata) {
        this.validateBlockState(iblockdata);
        this.blockState = iblockdata;
    }

    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
    }

    public final void applyComponentsFromItemStack(ItemStack itemstack) {
        this.applyComponents(itemstack.getPrototype(), itemstack.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        this.applyComponentsSet(datacomponentmap, datacomponentpatch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        set.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap datacomponentmap1 = PatchedDataComponentMap.fromPatch(datacomponentmap, datacomponentpatch);
        this.applyImplicitComponents(new DataComponentGetter(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> datacomponenttype) {
                set.add(datacomponenttype);
                return datacomponentmap1.get(datacomponenttype);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> datacomponenttype, T t0) {
                set.add(datacomponenttype);
                return datacomponentmap1.getOrDefault(datacomponenttype, t0);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.forget(set::contains);
        this.components = datacomponentpatch1.split().added();
        set.remove(DataComponents.BLOCK_ENTITY_DATA);
        set.remove(DataComponents.BLOCK_STATE);
        return set;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder datacomponentmap_a) {
    }

    @Deprecated
    public void removeComponentsFromTag(ValueOutput valueoutput) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder datacomponentmap_a = DataComponentMap.builder();
        datacomponentmap_a.addAll(this.components);
        this.collectImplicitComponents(datacomponentmap_a);
        return datacomponentmap_a.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap datacomponentmap) {
        this.components = datacomponentmap;
    }

    @Nullable
    public static Component parseCustomNameSafe(ValueInput valueinput, String s) {
        return valueinput.read(s, ComponentSerialization.CODEC).orElse(null);
    }

    public ProblemReporter.PathElement problemPath() {
        return new BlockEntityPathElement(this);
    }

    public InventoryHolder getOwner() {
        if (this.level == null) {
            return null;
        }
        BlockState state = this.level.getWorld().getBlockAt(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ()).getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    private record BlockEntityPathElement(BlockEntity blockEntity) implements ProblemReporter.PathElement
    {
        @Override
        public String get() {
            String s = this.blockEntity.getNameForReporting();
            return s + "@" + String.valueOf(this.blockEntity.getBlockPos());
        }
    }
}

