/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public interface ChunkIOErrorReporter {
    public void reportChunkLoadFailure(Throwable var1, RegionStorageInfo var2, ChunkPos var3);

    public void reportChunkSaveFailure(Throwable var1, RegionStorageInfo var2, ChunkPos var3);

    public static ReportedException createMisplacedChunkReport(ChunkPos var0, ChunkPos var1) {
        CrashReport var2 = CrashReport.forThrowable(new IllegalStateException("Retrieved chunk position " + String.valueOf(var0) + " does not match requested " + String.valueOf(var1)), "Chunk found in invalid location");
        CrashReportCategory var3 = var2.addCategory("Misplaced Chunk");
        var3.setDetail("Stored Position", var0::toString);
        return new ReportedException(var2);
    }

    default public void reportMisplacedChunk(ChunkPos var0, ChunkPos var1, RegionStorageInfo var2) {
        this.reportChunkLoadFailure(ChunkIOErrorReporter.createMisplacedChunkReport(var0, var1), var2, var1);
    }
}

