/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    final Set<UUID> knownUuids = Sets.newHashSet();
    final LevelCallback<T> callbacks;
    public final EntityPersistentStorage<T> permanentStorage;
    private final EntityLookup<T> visibleEntityStorage = new EntityLookup();
    final EntitySectionStorage<T> sectionStorage;
    private final LevelEntityGetter<T> entityGetter;
    private final Long2ObjectMap<Visibility> chunkVisibility = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<ChunkLoadStatus> chunkLoadStatuses = new Long2ObjectOpenHashMap();
    private final LongSet chunksToUnload = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> loadingInbox = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> oclass, LevelCallback<T> levelcallback, EntityPersistentStorage<T> entitypersistentstorage) {
        this.sectionStorage = new EntitySectionStorage<T>(oclass, (Long2ObjectFunction<Visibility>)this.chunkVisibility);
        this.chunkVisibility.defaultReturnValue((Object)Visibility.HIDDEN);
        this.chunkLoadStatuses.defaultReturnValue((Object)ChunkLoadStatus.FRESH);
        this.callbacks = levelcallback;
        this.permanentStorage = entitypersistentstorage;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.visibleEntityStorage, this.sectionStorage);
    }

    public List<Entity> getEntities(ChunkPos chunkCoordIntPair) {
        return this.sectionStorage.getExistingSectionsInChunk(chunkCoordIntPair.toLong()).flatMap(EntitySection::getEntities).map(entity -> (Entity)entity).collect(Collectors.toList());
    }

    public boolean isPending(long pair) {
        return this.chunkLoadStatuses.get(pair) == ChunkLoadStatus.PENDING;
    }

    void removeSectionIfEmpty(long i, EntitySection<T> entitysection) {
        if (entitysection.isEmpty()) {
            this.sectionStorage.remove(i);
        }
    }

    private boolean addEntityUuid(T t0) {
        if (!this.knownUuids.add(t0.getUUID())) {
            LOGGER.warn("UUID of added entity already exists: {}", t0);
            return false;
        }
        return true;
    }

    public boolean addNewEntity(T t0) {
        return this.addEntity(t0, false);
    }

    private boolean addEntity(T t0, boolean flag) {
        Visibility visibility;
        if (!this.addEntityUuid(t0)) {
            return false;
        }
        long i = SectionPos.asLong(t0.blockPosition());
        EntitySection<T> entitysection = this.sectionStorage.getOrCreateSection(i);
        entitysection.add(t0);
        t0.setLevelCallback(new Callback((EntityAccess)t0, i, entitysection));
        if (!flag) {
            this.callbacks.onCreated(t0);
        }
        if (t0 instanceof Entity) {
            Entity entity = (Entity)t0;
            entity.inWorld = true;
        }
        if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(t0, entitysection.getStatus())).isAccessible()) {
            this.startTracking(t0);
        }
        if (visibility.isTicking()) {
            this.startTicking(t0);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility getEffectiveStatus(T t0, Visibility visibility) {
        return t0.isAlwaysTicking() ? Visibility.TICKING : visibility;
    }

    public boolean isTicking(ChunkPos chunkcoordintpair) {
        return ((Visibility)((Object)this.chunkVisibility.get(chunkcoordintpair.toLong()))).isTicking();
    }

    public void addLegacyChunkEntities(Stream<T> stream) {
        stream.forEach(entityaccess -> this.addEntity(entityaccess, true));
    }

    public void addWorldGenChunkEntities(Stream<T> stream) {
        stream.forEach(entityaccess -> this.addEntity(entityaccess, false));
    }

    void startTicking(T t0) {
        this.callbacks.onTickingStart(t0);
    }

    void stopTicking(T t0) {
        this.callbacks.onTickingEnd(t0);
    }

    void startTracking(T t0) {
        this.visibleEntityStorage.add(t0);
        this.callbacks.onTrackingStart(t0);
    }

    void stopTracking(T t0) {
        this.callbacks.onTrackingEnd(t0);
        this.visibleEntityStorage.remove(t0);
    }

    public void updateChunkStatus(ChunkPos chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        Visibility visibility = Visibility.fromFullChunkStatus(fullchunkstatus);
        this.updateChunkStatus(chunkcoordintpair, visibility);
    }

    public void updateChunkStatus(ChunkPos chunkcoordintpair, Visibility visibility) {
        long i = chunkcoordintpair.toLong();
        if (visibility == Visibility.HIDDEN) {
            this.chunkVisibility.remove(i);
            this.chunksToUnload.add(i);
        } else {
            this.chunkVisibility.put(i, (Object)visibility);
            this.chunksToUnload.remove(i);
            this.ensureChunkQueuedForLoad(i);
        }
        this.sectionStorage.getExistingSectionsInChunk(i).forEach(entitysection -> {
            Visibility visibility1 = entitysection.updateChunkStatus(visibility);
            boolean flag = visibility1.isAccessible();
            boolean flag1 = visibility.isAccessible();
            boolean flag2 = visibility1.isTicking();
            boolean flag3 = visibility.isTicking();
            if (flag2 && !flag3) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::stopTicking);
            }
            if (flag && !flag1) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::stopTracking);
            } else if (!flag && flag1) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::startTracking);
            }
            if (!flag2 && flag3) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::startTicking);
            }
        });
    }

    public void ensureChunkQueuedForLoad(long i) {
        ChunkLoadStatus persistententitysectionmanager_b = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(i));
        if (persistententitysectionmanager_b == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(i);
        }
    }

    private boolean storeChunkSections(long i, Consumer<T> consumer) {
        return this.storeChunkSections(i, consumer, false);
    }

    private boolean storeChunkSections(long i, Consumer<T> consumer, boolean callEvent) {
        ChunkLoadStatus persistententitysectionmanager_b = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(i));
        if (persistententitysectionmanager_b == ChunkLoadStatus.PENDING) {
            return false;
        }
        List<T> list = this.sectionStorage.getExistingSectionsInChunk(i).flatMap(entitysection -> entitysection.getEntities().filter(EntityAccess::shouldBeSaved)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (persistententitysectionmanager_b == ChunkLoadStatus.LOADED) {
                if (callEvent) {
                    CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkPos(i), (List<Entity>)ImmutableList.of());
                }
                this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(i), ImmutableList.of()));
            }
            return true;
        }
        if (persistententitysectionmanager_b == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(i);
            return false;
        }
        if (callEvent) {
            CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkPos(i), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
        this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(i), list));
        list.forEach(consumer);
        return true;
    }

    private void requestChunkLoad(long i) {
        this.chunkLoadStatuses.put(i, (Object)ChunkLoadStatus.PENDING);
        ChunkPos chunkcoordintpair = new ChunkPos(i);
        CompletableFuture<ChunkEntities<T>> completablefuture = this.permanentStorage.loadEntities(chunkcoordintpair);
        Queue<ChunkEntities<T>> queue = this.loadingInbox;
        Objects.requireNonNull(this.loadingInbox);
        ((CompletableFuture)completablefuture.thenAccept(queue::add)).exceptionally(throwable -> {
            LOGGER.error("Failed to read chunk {}", (Object)chunkcoordintpair, throwable);
            return null;
        });
    }

    private boolean processChunkUnload(long i) {
        boolean flag = this.storeChunkSections(i, entityaccess -> entityaccess.getPassengersAndSelf().forEach(this::unloadEntity), true);
        if (!flag) {
            return false;
        }
        this.chunkLoadStatuses.remove(i);
        return true;
    }

    private void unloadEntity(EntityAccess entityaccess) {
        entityaccess.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK, EntityRemoveEvent.Cause.UNLOAD);
        entityaccess.setLevelCallback(EntityInLevelCallback.NULL);
    }

    private void processUnloads() {
        this.chunksToUnload.removeIf(i -> this.chunkVisibility.get(i) != Visibility.HIDDEN ? true : this.processChunkUnload(i));
    }

    public void processPendingLoads() {
        ChunkEntities<T> chunkentities;
        while ((chunkentities = this.loadingInbox.poll()) != null) {
            chunkentities.getEntities().forEach(entityaccess -> this.addEntity(entityaccess, true));
            this.chunkLoadStatuses.put(chunkentities.getPos().toLong(), (Object)ChunkLoadStatus.LOADED);
            List<Entity> entities = this.getEntities(chunkentities.getPos());
            CraftEventFactory.callEntitiesLoadEvent(((EntityStorage)this.permanentStorage).level, chunkentities.getPos(), entities);
        }
    }

    public void tick() {
        this.processPendingLoads();
        this.processUnloads();
    }

    private LongSet getAllChunksToSave() {
        LongSet longset = this.sectionStorage.getAllChunksWithExistingSections();
        for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(this.chunkLoadStatuses)) {
            if (long2objectmap_entry.getValue() != ChunkLoadStatus.LOADED) continue;
            longset.add(long2objectmap_entry.getLongKey());
        }
        return longset;
    }

    public void autoSave() {
        this.getAllChunksToSave().forEach(i -> {
            boolean flag;
            boolean bl = flag = this.chunkVisibility.get(i) == Visibility.HIDDEN;
            if (flag) {
                this.processChunkUnload(i);
            } else {
                this.storeChunkSections(i, entityaccess -> {});
            }
        });
    }

    public void saveAll() {
        LongSet longset = this.getAllChunksToSave();
        while (!longset.isEmpty()) {
            this.permanentStorage.flush(false);
            this.processPendingLoads();
            longset.removeIf(i -> {
                boolean flag = this.chunkVisibility.get(i) == Visibility.HIDDEN;
                return flag ? this.processChunkUnload(i) : this.storeChunkSections(i, entityaccess -> {});
            });
        }
        this.permanentStorage.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.saveAll();
        }
        this.permanentStorage.close();
    }

    public boolean isLoaded(UUID uuid) {
        return this.knownUuids.contains(uuid);
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public boolean canPositionTick(BlockPos blockposition) {
        return ((Visibility)((Object)this.chunkVisibility.get(ChunkPos.asLong(blockposition)))).isTicking();
    }

    public boolean canPositionTick(ChunkPos chunkcoordintpair) {
        return ((Visibility)((Object)this.chunkVisibility.get(chunkcoordintpair.toLong()))).isTicking();
    }

    public boolean areEntitiesLoaded(long i) {
        return this.chunkLoadStatuses.get(i) == ChunkLoadStatus.LOADED;
    }

    public void dumpSections(Writer writer) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("visibility").addColumn("load_status").addColumn("entity_count").build(writer);
        this.sectionStorage.getAllChunksWithExistingSections().forEach(i -> {
            ChunkLoadStatus persistententitysectionmanager_b = (ChunkLoadStatus)((Object)((Object)this.chunkLoadStatuses.get(i)));
            this.sectionStorage.getExistingSectionPositionsInChunk(i).forEach(j -> {
                EntitySection<T> entitysection = this.sectionStorage.getSection(j);
                if (entitysection != null) {
                    try {
                        csvwriter.writeRow(new Object[]{SectionPos.x(j), SectionPos.y(j), SectionPos.z(j), entitysection.getStatus(), persistententitysectionmanager_b, entitysection.size()});
                    }
                    catch (IOException ioexception) {
                        throw new UncheckedIOException(ioexception);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String gatherStats() {
        int i = this.knownUuids.size();
        return i + "," + this.visibleEntityStorage.count() + "," + this.sectionStorage.count() + "," + this.chunkLoadStatuses.size() + "," + this.chunkVisibility.size() + "," + this.loadingInbox.size() + "," + this.chunksToUnload.size();
    }

    @VisibleForDebug
    public int count() {
        return this.visibleEntityStorage.count();
    }

    private static enum ChunkLoadStatus {
        FRESH,
        PENDING,
        LOADED;

    }

    private class Callback
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;

        Callback(EntityAccess entityaccess, long i, EntitySection entitysection) {
            this.entity = entityaccess;
            this.currentSectionKey = i;
            this.currentSection = entitysection;
        }

        @Override
        public void onMove() {
            BlockPos blockposition = this.entity.blockPosition();
            long i = SectionPos.asLong(blockposition);
            if (i != this.currentSectionKey) {
                Visibility visibility = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), i});
                }
                PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection entitysection = PersistentEntitySectionManager.this.sectionStorage.getOrCreateSection(i);
                entitysection.add(this.entity);
                this.currentSection = entitysection;
                this.currentSectionKey = i;
                this.updateStatus(visibility, entitysection.getStatus());
            }
        }

        private void updateStatus(Visibility visibility, Visibility visibility1) {
            Visibility visibility3;
            Visibility visibility2 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, visibility);
            if (visibility2 == (visibility3 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, visibility1))) {
                if (visibility3.isAccessible()) {
                    PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
                }
            } else {
                boolean flag = visibility2.isAccessible();
                boolean flag1 = visibility3.isAccessible();
                if (flag && !flag1) {
                    PersistentEntitySectionManager.this.stopTracking(this.entity);
                } else if (!flag && flag1) {
                    PersistentEntitySectionManager.this.startTracking(this.entity);
                }
                boolean flag2 = visibility2.isTicking();
                boolean flag3 = visibility3.isTicking();
                if (flag2 && !flag3) {
                    PersistentEntitySectionManager.this.stopTicking(this.entity);
                } else if (!flag2 && flag3) {
                    PersistentEntitySectionManager.this.startTicking(this.entity);
                }
                if (flag1) {
                    PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
                }
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason entity_removalreason) {
            Visibility visibility;
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), entity_removalreason});
            }
            if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(this.entity, this.currentSection.getStatus())).isTicking()) {
                PersistentEntitySectionManager.this.stopTicking(this.entity);
            }
            if (visibility.isAccessible()) {
                PersistentEntitySectionManager.this.stopTracking(this.entity);
            }
            if (entity_removalreason.shouldDestroy()) {
                PersistentEntitySectionManager.this.callbacks.onDestroyed(this.entity);
            }
            PersistentEntitySectionManager.this.knownUuids.remove(this.entity.getUUID());
            this.entity.setLevelCallback(NULL);
            PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

