/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;

public class NoiseChunk
implements DensityFunction.ContextProvider,
DensityFunction.FunctionContext {
    private final NoiseSettings noiseSettings;
    final int cellCountXZ;
    final int cellCountY;
    final int cellNoiseMinY;
    private final int firstCellX;
    private final int firstCellZ;
    final int firstNoiseX;
    final int firstNoiseZ;
    final List<NoiseInterpolator> interpolators;
    final List<CacheAllInCell> cellCaches;
    private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
    private final Long2IntMap preliminarySurfaceLevel = new Long2IntOpenHashMap();
    private final Aquifer aquifer;
    private final DensityFunction initialDensityNoJaggedness;
    private final BlockStateFiller blockStateRule;
    private final Blender blender;
    private final FlatCache blendAlpha;
    private final FlatCache blendOffset;
    private final DensityFunctions.BeardifierOrMarker beardifier;
    private long lastBlendingDataPos = ChunkPos.INVALID_CHUNK_POS;
    private Blender.BlendingOutput lastBlendingOutput = new Blender.BlendingOutput(1.0, 0.0);
    final int noiseSizeXZ;
    final int cellWidth;
    final int cellHeight;
    boolean interpolating;
    boolean fillingCell;
    private int cellStartBlockX;
    int cellStartBlockY;
    private int cellStartBlockZ;
    int inCellX;
    int inCellY;
    int inCellZ;
    long interpolationCounter;
    long arrayInterpolationCounter;
    int arrayIndex;
    private final DensityFunction.ContextProvider sliceFillingContextProvider = new DensityFunction.ContextProvider(){

        @Override
        public DensityFunction.FunctionContext forIndex(int var0) {
            NoiseChunk.this.cellStartBlockY = (var0 + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
            ++NoiseChunk.this.interpolationCounter;
            NoiseChunk.this.inCellY = 0;
            NoiseChunk.this.arrayIndex = var0;
            return NoiseChunk.this;
        }

        @Override
        public void fillAllDirectly(double[] var0, DensityFunction var1) {
            for (int var2 = 0; var2 < NoiseChunk.this.cellCountY + 1; ++var2) {
                NoiseChunk.this.cellStartBlockY = (var2 + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
                ++NoiseChunk.this.interpolationCounter;
                NoiseChunk.this.inCellY = 0;
                NoiseChunk.this.arrayIndex = var2;
                var0[var2] = var1.compute(NoiseChunk.this);
            }
        }
    };

    public static NoiseChunk forChunk(ChunkAccess var0, RandomState var1, DensityFunctions.BeardifierOrMarker var2, NoiseGeneratorSettings var3, Aquifer.FluidPicker var4, Blender var5) {
        NoiseSettings var6 = var3.noiseSettings().clampToHeightAccessor(var0);
        ChunkPos var7 = var0.getPos();
        int var8 = 16 / var6.getCellWidth();
        return new NoiseChunk(var8, var1, var7.getMinBlockX(), var7.getMinBlockZ(), var6, var2, var3, var4, var5);
    }

    public NoiseChunk(int var0, RandomState var12, int var2, int var3, NoiseSettings var4, DensityFunctions.BeardifierOrMarker var5, NoiseGeneratorSettings var6, Aquifer.FluidPicker var7, Blender var8) {
        int var122;
        int var11;
        this.noiseSettings = var4;
        this.cellWidth = var4.getCellWidth();
        this.cellHeight = var4.getCellHeight();
        this.cellCountXZ = var0;
        this.cellCountY = Mth.floorDiv(var4.height(), this.cellHeight);
        this.cellNoiseMinY = Mth.floorDiv(var4.minY(), this.cellHeight);
        this.firstCellX = Math.floorDiv(var2, this.cellWidth);
        this.firstCellZ = Math.floorDiv(var3, this.cellWidth);
        this.interpolators = Lists.newArrayList();
        this.cellCaches = Lists.newArrayList();
        this.firstNoiseX = QuartPos.fromBlock(var2);
        this.firstNoiseZ = QuartPos.fromBlock(var3);
        this.noiseSizeXZ = QuartPos.fromBlock(var0 * this.cellWidth);
        this.blender = var8;
        this.beardifier = var5;
        this.blendAlpha = new FlatCache(new BlendAlpha(), false);
        this.blendOffset = new FlatCache(new BlendOffset(), false);
        for (int var9 = 0; var9 <= this.noiseSizeXZ; ++var9) {
            int var10 = this.firstNoiseX + var9;
            var11 = QuartPos.toBlock(var10);
            for (var122 = 0; var122 <= this.noiseSizeXZ; ++var122) {
                int var13 = this.firstNoiseZ + var122;
                int var14 = QuartPos.toBlock(var13);
                Blender.BlendingOutput var15 = var8.blendOffsetAndFactor(var11, var14);
                this.blendAlpha.values[var9][var122] = var15.alpha();
                this.blendOffset.values[var9][var122] = var15.blendingOffset();
            }
        }
        NoiseRouter var9 = var12.router();
        NoiseRouter var10 = var9.mapAll(this::wrap);
        if (!var6.isAquifersEnabled()) {
            this.aquifer = Aquifer.createDisabled(var7);
        } else {
            var11 = SectionPos.blockToSectionCoord(var2);
            var122 = SectionPos.blockToSectionCoord(var3);
            this.aquifer = Aquifer.create(this, new ChunkPos(var11, var122), var10, var12.aquiferRandom(), var4.minY(), var4.height(), var7);
        }
        ArrayList<BlockStateFiller> var112 = new ArrayList<BlockStateFiller>();
        DensityFunction var123 = DensityFunctions.cacheAllInCell(DensityFunctions.add(var10.finalDensity(), DensityFunctions.BeardifierMarker.INSTANCE)).mapAll(this::wrap);
        var112.add(var1 -> this.aquifer.computeSubstance(var1, var123.compute(var1)));
        if (var6.oreVeinsEnabled()) {
            var112.add(OreVeinifier.create(var10.veinToggle(), var10.veinRidged(), var10.veinGap(), var12.oreRandom()));
        }
        this.blockStateRule = new MaterialRuleList(var112.toArray(new BlockStateFiller[0]));
        this.initialDensityNoJaggedness = var10.initialDensityWithoutJaggedness();
    }

    protected Climate.Sampler cachedClimateSampler(NoiseRouter var0, List<Climate.ParameterPoint> var1) {
        return new Climate.Sampler(var0.temperature().mapAll(this::wrap), var0.vegetation().mapAll(this::wrap), var0.continents().mapAll(this::wrap), var0.erosion().mapAll(this::wrap), var0.depth().mapAll(this::wrap), var0.ridges().mapAll(this::wrap), var1);
    }

    @Nullable
    protected BlockState getInterpolatedState() {
        return this.blockStateRule.calculate(this);
    }

    @Override
    public int blockX() {
        return this.cellStartBlockX + this.inCellX;
    }

    @Override
    public int blockY() {
        return this.cellStartBlockY + this.inCellY;
    }

    @Override
    public int blockZ() {
        return this.cellStartBlockZ + this.inCellZ;
    }

    public int preliminarySurfaceLevel(int var0, int var1) {
        int var2 = QuartPos.toBlock(QuartPos.fromBlock(var0));
        int var3 = QuartPos.toBlock(QuartPos.fromBlock(var1));
        return this.preliminarySurfaceLevel.computeIfAbsent(ColumnPos.asLong(var2, var3), this::computePreliminarySurfaceLevel);
    }

    private int computePreliminarySurfaceLevel(long var0) {
        int var2 = ColumnPos.getX(var0);
        int var3 = ColumnPos.getZ(var0);
        int var4 = this.noiseSettings.minY();
        for (int var5 = var4 + this.noiseSettings.height(); var5 >= var4; var5 -= this.cellHeight) {
            DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(var2, var5, var3);
            if (!(this.initialDensityNoJaggedness.compute(singlePointContext) > 0.390625)) continue;
            return var5;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Blender getBlender() {
        return this.blender;
    }

    private void fillSlice(boolean var0, int var1) {
        this.cellStartBlockX = var1 * this.cellWidth;
        this.inCellX = 0;
        for (int var2 = 0; var2 < this.cellCountXZ + 1; ++var2) {
            int var3 = this.firstCellZ + var2;
            this.cellStartBlockZ = var3 * this.cellWidth;
            this.inCellZ = 0;
            ++this.arrayInterpolationCounter;
            for (NoiseInterpolator var5 : this.interpolators) {
                double[] var6 = (var0 ? var5.slice0 : var5.slice1)[var2];
                var5.fillArray(var6, this.sliceFillingContextProvider);
            }
        }
        ++this.arrayInterpolationCounter;
    }

    public void initializeForFirstCellX() {
        if (this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = true;
        this.interpolationCounter = 0L;
        this.fillSlice(true, this.firstCellX);
    }

    public void advanceCellX(int var0) {
        this.fillSlice(false, this.firstCellX + var0 + 1);
        this.cellStartBlockX = (this.firstCellX + var0) * this.cellWidth;
    }

    @Override
    public NoiseChunk forIndex(int var0) {
        int var1 = Math.floorMod(var0, this.cellWidth);
        int var2 = Math.floorDiv(var0, this.cellWidth);
        int var3 = Math.floorMod(var2, this.cellWidth);
        int var4 = this.cellHeight - 1 - Math.floorDiv(var2, this.cellWidth);
        this.inCellX = var3;
        this.inCellY = var4;
        this.inCellZ = var1;
        this.arrayIndex = var0;
        return this;
    }

    @Override
    public void fillAllDirectly(double[] var0, DensityFunction var1) {
        this.arrayIndex = 0;
        for (int var2 = this.cellHeight - 1; var2 >= 0; --var2) {
            this.inCellY = var2;
            for (int var3 = 0; var3 < this.cellWidth; ++var3) {
                this.inCellX = var3;
                int var4 = 0;
                while (var4 < this.cellWidth) {
                    this.inCellZ = var4++;
                    var0[this.arrayIndex++] = var1.compute(this);
                }
            }
        }
    }

    public void selectCellYZ(int var0, int var1) {
        for (NoiseInterpolator noiseInterpolator : this.interpolators) {
            noiseInterpolator.selectCellYZ(var0, var1);
        }
        this.fillingCell = true;
        this.cellStartBlockY = (var0 + this.cellNoiseMinY) * this.cellHeight;
        this.cellStartBlockZ = (this.firstCellZ + var1) * this.cellWidth;
        ++this.arrayInterpolationCounter;
        for (CacheAllInCell cacheAllInCell : this.cellCaches) {
            cacheAllInCell.noiseFiller.fillArray(cacheAllInCell.values, this);
        }
        ++this.arrayInterpolationCounter;
        this.fillingCell = false;
    }

    public void updateForY(int var0, double var1) {
        this.inCellY = var0 - this.cellStartBlockY;
        for (NoiseInterpolator var4 : this.interpolators) {
            var4.updateForY(var1);
        }
    }

    public void updateForX(int var0, double var1) {
        this.inCellX = var0 - this.cellStartBlockX;
        for (NoiseInterpolator var4 : this.interpolators) {
            var4.updateForX(var1);
        }
    }

    public void updateForZ(int var0, double var1) {
        this.inCellZ = var0 - this.cellStartBlockZ;
        ++this.interpolationCounter;
        for (NoiseInterpolator var4 : this.interpolators) {
            var4.updateForZ(var1);
        }
    }

    public void stopInterpolation() {
        if (!this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = false;
    }

    public void swapSlices() {
        this.interpolators.forEach(NoiseInterpolator::swapSlices);
    }

    public Aquifer aquifer() {
        return this.aquifer;
    }

    protected int cellWidth() {
        return this.cellWidth;
    }

    protected int cellHeight() {
        return this.cellHeight;
    }

    Blender.BlendingOutput getOrComputeBlendingOutput(int var0, int var1) {
        Blender.BlendingOutput var4;
        long var2 = ChunkPos.asLong(var0, var1);
        if (this.lastBlendingDataPos == var2) {
            return this.lastBlendingOutput;
        }
        this.lastBlendingDataPos = var2;
        this.lastBlendingOutput = var4 = this.blender.blendOffsetAndFactor(var0, var1);
        return var4;
    }

    protected DensityFunction wrap(DensityFunction var0) {
        return this.wrapped.computeIfAbsent(var0, this::wrapNew);
    }

    private DensityFunction wrapNew(DensityFunction var0) {
        if (var0 instanceof DensityFunctions.Marker) {
            DensityFunctions.Marker var1 = (DensityFunctions.Marker)var0;
            return switch (var1.type()) {
                default -> throw new MatchException(null, null);
                case DensityFunctions.Marker.Type.Interpolated -> new NoiseInterpolator(var1.wrapped());
                case DensityFunctions.Marker.Type.FlatCache -> new FlatCache(var1.wrapped(), true);
                case DensityFunctions.Marker.Type.Cache2D -> new Cache2D(var1.wrapped());
                case DensityFunctions.Marker.Type.CacheOnce -> new CacheOnce(var1.wrapped());
                case DensityFunctions.Marker.Type.CacheAllInCell -> new CacheAllInCell(var1.wrapped());
            };
        }
        if (this.blender != Blender.empty()) {
            if (var0 == DensityFunctions.BlendAlpha.INSTANCE) {
                return this.blendAlpha;
            }
            if (var0 == DensityFunctions.BlendOffset.INSTANCE) {
                return this.blendOffset;
            }
        }
        if (var0 == DensityFunctions.BeardifierMarker.INSTANCE) {
            return this.beardifier;
        }
        if (var0 instanceof DensityFunctions.HolderHolder) {
            DensityFunctions.HolderHolder var1 = (DensityFunctions.HolderHolder)var0;
            return var1.function().value();
        }
        return var0;
    }

    @Override
    public /* synthetic */ DensityFunction.FunctionContext forIndex(int n) {
        return this.forIndex(n);
    }

    class FlatCache
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        private final DensityFunction noiseFiller;
        final double[][] values;

        FlatCache(DensityFunction var1, boolean var2) {
            this.noiseFiller = var1;
            this.values = new double[NoiseChunk.this.noiseSizeXZ + 1][NoiseChunk.this.noiseSizeXZ + 1];
            if (var2) {
                for (int var3 = 0; var3 <= NoiseChunk.this.noiseSizeXZ; ++var3) {
                    int var4 = NoiseChunk.this.firstNoiseX + var3;
                    int var5 = QuartPos.toBlock(var4);
                    for (int var6 = 0; var6 <= NoiseChunk.this.noiseSizeXZ; ++var6) {
                        int var7 = NoiseChunk.this.firstNoiseZ + var6;
                        int var8 = QuartPos.toBlock(var7);
                        this.values[var3][var6] = var1.compute(new DensityFunction.SinglePointContext(var5, 0, var8));
                    }
                }
            }
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            int var1 = QuartPos.fromBlock(var0.blockX());
            int var2 = QuartPos.fromBlock(var0.blockZ());
            int var3 = var1 - NoiseChunk.this.firstNoiseX;
            int var4 = var2 - NoiseChunk.this.firstNoiseZ;
            int var5 = this.values.length;
            if (var3 >= 0 && var4 >= 0 && var3 < var5 && var4 < var5) {
                return this.values[var3][var4];
            }
            return this.noiseFiller.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.FlatCache;
        }
    }

    class BlendAlpha
    implements NoiseChunkDensityFunction {
        BlendAlpha() {
        }

        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.BlendAlpha.INSTANCE;
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return this.wrapped().mapAll(var0);
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return NoiseChunk.this.getOrComputeBlendingOutput(var0.blockX(), var0.blockZ()).alpha();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return DensityFunctions.BlendAlpha.CODEC;
        }
    }

    class BlendOffset
    implements NoiseChunkDensityFunction {
        BlendOffset() {
        }

        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.BlendOffset.INSTANCE;
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return this.wrapped().mapAll(var0);
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return NoiseChunk.this.getOrComputeBlendingOutput(var0.blockX(), var0.blockZ()).blendingOffset();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return DensityFunctions.BlendOffset.CODEC;
        }
    }

    @FunctionalInterface
    public static interface BlockStateFiller {
        @Nullable
        public BlockState calculate(DensityFunction.FunctionContext var1);
    }

    public class NoiseInterpolator
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        double[][] slice0;
        double[][] slice1;
        private final DensityFunction noiseFiller;
        private double noise000;
        private double noise001;
        private double noise100;
        private double noise101;
        private double noise010;
        private double noise011;
        private double noise110;
        private double noise111;
        private double valueXZ00;
        private double valueXZ10;
        private double valueXZ01;
        private double valueXZ11;
        private double valueZ0;
        private double valueZ1;
        private double value;

        NoiseInterpolator(DensityFunction var1) {
            this.noiseFiller = var1;
            this.slice0 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            this.slice1 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            NoiseChunk.this.interpolators.add(this);
        }

        private double[][] allocateSlice(int var0, int var1) {
            int var2 = var1 + 1;
            int var3 = var0 + 1;
            double[][] var4 = new double[var2][var3];
            for (int var5 = 0; var5 < var2; ++var5) {
                var4[var5] = new double[var3];
            }
            return var4;
        }

        void selectCellYZ(int var0, int var1) {
            this.noise000 = this.slice0[var1][var0];
            this.noise001 = this.slice0[var1 + 1][var0];
            this.noise100 = this.slice1[var1][var0];
            this.noise101 = this.slice1[var1 + 1][var0];
            this.noise010 = this.slice0[var1][var0 + 1];
            this.noise011 = this.slice0[var1 + 1][var0 + 1];
            this.noise110 = this.slice1[var1][var0 + 1];
            this.noise111 = this.slice1[var1 + 1][var0 + 1];
        }

        void updateForY(double var0) {
            this.valueXZ00 = Mth.lerp(var0, this.noise000, this.noise010);
            this.valueXZ10 = Mth.lerp(var0, this.noise100, this.noise110);
            this.valueXZ01 = Mth.lerp(var0, this.noise001, this.noise011);
            this.valueXZ11 = Mth.lerp(var0, this.noise101, this.noise111);
        }

        void updateForX(double var0) {
            this.valueZ0 = Mth.lerp(var0, this.valueXZ00, this.valueXZ10);
            this.valueZ1 = Mth.lerp(var0, this.valueXZ01, this.valueXZ11);
        }

        void updateForZ(double var0) {
            this.value = Mth.lerp(var0, this.valueZ0, this.valueZ1);
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            if (var0 != NoiseChunk.this) {
                return this.noiseFiller.compute(var0);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            if (NoiseChunk.this.fillingCell) {
                return Mth.lerp3((double)NoiseChunk.this.inCellX / (double)NoiseChunk.this.cellWidth, (double)NoiseChunk.this.inCellY / (double)NoiseChunk.this.cellHeight, (double)NoiseChunk.this.inCellZ / (double)NoiseChunk.this.cellWidth, this.noise000, this.noise100, this.noise010, this.noise110, this.noise001, this.noise101, this.noise011, this.noise111);
            }
            return this.value;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            if (NoiseChunk.this.fillingCell) {
                var1.fillAllDirectly(var0, this);
                return;
            }
            this.wrapped().fillArray(var0, var1);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        private void swapSlices() {
            double[][] var0 = this.slice0;
            this.slice0 = this.slice1;
            this.slice1 = var0;
        }

        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.Interpolated;
        }
    }

    class CacheAllInCell
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        final DensityFunction noiseFiller;
        final double[] values;

        CacheAllInCell(DensityFunction var1) {
            this.noiseFiller = var1;
            this.values = new double[NoiseChunk.this.cellWidth * NoiseChunk.this.cellWidth * NoiseChunk.this.cellHeight];
            NoiseChunk.this.cellCaches.add(this);
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            if (var0 != NoiseChunk.this) {
                return this.noiseFiller.compute(var0);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            int var1 = NoiseChunk.this.inCellX;
            int var2 = NoiseChunk.this.inCellY;
            int var3 = NoiseChunk.this.inCellZ;
            if (var1 >= 0 && var2 >= 0 && var3 >= 0 && var1 < NoiseChunk.this.cellWidth && var2 < NoiseChunk.this.cellHeight && var3 < NoiseChunk.this.cellWidth) {
                return this.values[((NoiseChunk.this.cellHeight - 1 - var2) * NoiseChunk.this.cellWidth + var1) * NoiseChunk.this.cellWidth + var3];
            }
            return this.noiseFiller.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.CacheAllInCell;
        }
    }

    static class Cache2D
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        private final DensityFunction function;
        private long lastPos2D = ChunkPos.INVALID_CHUNK_POS;
        private double lastValue;

        Cache2D(DensityFunction var0) {
            this.function = var0;
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            double var5;
            int var2;
            int var1 = var0.blockX();
            long var3 = ChunkPos.asLong(var1, var2 = var0.blockZ());
            if (this.lastPos2D == var3) {
                return this.lastValue;
            }
            this.lastPos2D = var3;
            this.lastValue = var5 = this.function.compute(var0);
            return var5;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            this.function.fillArray(var0, var1);
        }

        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.Cache2D;
        }
    }

    class CacheOnce
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        private final DensityFunction function;
        private long lastCounter;
        private long lastArrayCounter;
        private double lastValue;
        @Nullable
        private double[] lastArray;

        CacheOnce(DensityFunction var1) {
            this.function = var1;
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            double var1;
            if (var0 != NoiseChunk.this) {
                return this.function.compute(var0);
            }
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                return this.lastArray[NoiseChunk.this.arrayIndex];
            }
            if (this.lastCounter == NoiseChunk.this.interpolationCounter) {
                return this.lastValue;
            }
            this.lastCounter = NoiseChunk.this.interpolationCounter;
            this.lastValue = var1 = this.function.compute(var0);
            return var1;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                System.arraycopy(this.lastArray, 0, var0, 0, var0.length);
                return;
            }
            this.wrapped().fillArray(var0, var1);
            if (this.lastArray != null && this.lastArray.length == var0.length) {
                System.arraycopy(var0, 0, this.lastArray, 0, var0.length);
            } else {
                this.lastArray = (double[])var0.clone();
            }
            this.lastArrayCounter = NoiseChunk.this.arrayInterpolationCounter;
        }

        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.CacheOnce;
        }
    }

    static interface NoiseChunkDensityFunction
    extends DensityFunction {
        public DensityFunction wrapped();

        @Override
        default public double minValue() {
            return this.wrapped().minValue();
        }

        @Override
        default public double maxValue() {
            return this.wrapped().maxValue();
        }
    }
}

