/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public abstract class CoralFeature
extends Feature<NoneFeatureConfiguration> {
    public CoralFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        RandomSource var1 = var0.random();
        WorldGenLevel var2 = var0.level();
        BlockPos var3 = var0.origin();
        Optional<Block> var4 = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.CORAL_BLOCKS, var1).map(Holder::value);
        if (var4.isEmpty()) {
            return false;
        }
        return this.placeFeature(var2, var1, var3, var4.get().defaultBlockState());
    }

    protected abstract boolean placeFeature(LevelAccessor var1, RandomSource var2, BlockPos var3, BlockState var4);

    protected boolean placeCoralBlock(LevelAccessor var0, RandomSource var1, BlockPos var22, BlockState var32) {
        BlockPos var4 = var22.above();
        BlockState var5 = var0.getBlockState(var22);
        if (!var5.is(Blocks.WATER) && !var5.is(BlockTags.CORALS) || !var0.getBlockState(var4).is(Blocks.WATER)) {
            return false;
        }
        var0.setBlock(var22, var32, 3);
        if (var1.nextFloat() < 0.25f) {
            BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.CORALS, var1).map(Holder::value).ifPresent(var2 -> var0.setBlock(var4, var2.defaultBlockState(), 2));
        } else if (var1.nextFloat() < 0.05f) {
            var0.setBlock(var4, (BlockState)Blocks.SEA_PICKLE.defaultBlockState().setValue(SeaPickleBlock.PICKLES, var1.nextInt(4) + 1), 2);
        }
        for (Direction var7 : Direction.Plane.HORIZONTAL) {
            BlockPos var8;
            if (!(var1.nextFloat() < 0.2f) || !var0.getBlockState(var8 = var22.relative(var7)).is(Blocks.WATER)) continue;
            BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.WALL_CORALS, var1).map(Holder::value).ifPresent(var3 -> {
                BlockState var4 = var3.defaultBlockState();
                if (var4.hasProperty(BaseCoralWallFanBlock.FACING)) {
                    var4 = (BlockState)var4.setValue(BaseCoralWallFanBlock.FACING, var7);
                }
                var0.setBlock(var8, var4, 2);
            });
        }
        return true;
    }
}

