/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableInt;

public class FossilFeature
extends Feature<FossilFeatureConfiguration> {
    public FossilFeature(Codec<FossilFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<FossilFeatureConfiguration> var0) {
        int var16;
        RandomSource var1 = var0.random();
        WorldGenLevel var2 = var0.level();
        BlockPos var3 = var0.origin();
        Rotation var4 = Rotation.getRandom(var1);
        FossilFeatureConfiguration var5 = var0.config();
        int var6 = var1.nextInt(var5.fossilStructures.size());
        StructureTemplateManager var7 = var2.getLevel().getServer().getStructureManager();
        StructureTemplate var8 = var7.getOrCreate(var5.fossilStructures.get(var6));
        StructureTemplate var9 = var7.getOrCreate(var5.overlayStructures.get(var6));
        ChunkPos var10 = new ChunkPos(var3);
        BoundingBox var11 = new BoundingBox(var10.getMinBlockX() - 16, var2.getMinY(), var10.getMinBlockZ() - 16, var10.getMaxBlockX() + 16, var2.getMaxY(), var10.getMaxBlockZ() + 16);
        StructurePlaceSettings var12 = new StructurePlaceSettings().setRotation(var4).setBoundingBox(var11).setRandom(var1);
        Vec3i var13 = var8.getSize(var4);
        BlockPos var14 = var3.offset(-var13.getX() / 2, 0, -var13.getZ() / 2);
        int var15 = var3.getY();
        for (var16 = 0; var16 < var13.getX(); ++var16) {
            for (int var17 = 0; var17 < var13.getZ(); ++var17) {
                var15 = Math.min(var15, var2.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, var14.getX() + var16, var14.getZ() + var17));
            }
        }
        var16 = Math.max(var15 - 15 - var1.nextInt(10), var2.getMinY() + 10);
        BlockPos var17 = var8.getZeroPositionWithTransform(var14.atY(var16), Mirror.NONE, var4);
        if (FossilFeature.countEmptyCorners(var2, var8.getBoundingBox(var12, var17)) > var5.maxEmptyCornersAllowed) {
            return false;
        }
        var12.clearProcessors();
        var5.fossilProcessors.value().list().forEach(var12::addProcessor);
        var8.placeInWorld(var2, var17, var17, var12, var1, 260);
        var12.clearProcessors();
        var5.overlayProcessors.value().list().forEach(var12::addProcessor);
        var9.placeInWorld(var2, var17, var17, var12, var1, 260);
        return true;
    }

    private static int countEmptyCorners(WorldGenLevel var0, BoundingBox var1) {
        MutableInt var22 = new MutableInt(0);
        var1.forAllCorners(var2 -> {
            BlockState var3 = var0.getBlockState((BlockPos)var2);
            if (var3.isAir() || var3.is(Blocks.LAVA) || var3.is(Blocks.WATER)) {
                var22.add(1);
            }
        });
        return var22.getValue();
    }
}

