/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceSphereConfiguration;

public class ReplaceBlobsFeature
extends Feature<ReplaceSphereConfiguration> {
    public ReplaceBlobsFeature(Codec<ReplaceSphereConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<ReplaceSphereConfiguration> var0) {
        ReplaceSphereConfiguration var1 = var0.config();
        WorldGenLevel var2 = var0.level();
        RandomSource var3 = var0.random();
        Block var4 = var1.targetState.getBlock();
        BlockPos var5 = ReplaceBlobsFeature.findTarget(var2, var0.origin().mutable().clamp(Direction.Axis.Y, var2.getMinY() + 1, var2.getMaxY()), var4);
        if (var5 == null) {
            return false;
        }
        int var6 = var1.radius().sample(var3);
        int var7 = var1.radius().sample(var3);
        int var8 = var1.radius().sample(var3);
        int var9 = Math.max(var6, Math.max(var7, var8));
        boolean var10 = false;
        for (BlockPos var12 : BlockPos.withinManhattan(var5, var6, var7, var8)) {
            if (var12.distManhattan(var5) > var9) break;
            BlockState var13 = var2.getBlockState(var12);
            if (!var13.is(var4)) continue;
            this.setBlock(var2, var12, var1.replaceState);
            var10 = true;
        }
        return var10;
    }

    @Nullable
    private static BlockPos findTarget(LevelAccessor var0, BlockPos.MutableBlockPos var1, Block var2) {
        while (var1.getY() > var0.getMinY() + 1) {
            BlockState var3 = var0.getBlockState(var1);
            if (var3.is(var2)) {
                return var1;
            }
            var1.move(Direction.DOWN);
        }
        return null;
    }
}

