/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.VegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class WaterloggedVegetationPatchFeature
extends VegetationPatchFeature {
    public WaterloggedVegetationPatchFeature(Codec<VegetationPatchConfiguration> var0) {
        super(var0);
    }

    @Override
    protected Set<BlockPos> placeGroundPatch(WorldGenLevel var0, VegetationPatchConfiguration var1, RandomSource var2, BlockPos var3, Predicate<BlockState> var4, int var5, int var6) {
        Set<BlockPos> var7 = super.placeGroundPatch(var0, var1, var2, var3, var4, var5, var6);
        HashSet<BlockPos> var8 = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos var9 = new BlockPos.MutableBlockPos();
        for (BlockPos var11 : var7) {
            if (WaterloggedVegetationPatchFeature.isExposed(var0, var7, var11, var9)) continue;
            var8.add(var11);
        }
        for (BlockPos var11 : var8) {
            var0.setBlock(var11, Blocks.WATER.defaultBlockState(), 2);
        }
        return var8;
    }

    private static boolean isExposed(WorldGenLevel var0, Set<BlockPos> var1, BlockPos var2, BlockPos.MutableBlockPos var3) {
        return WaterloggedVegetationPatchFeature.isExposedDirection(var0, var2, var3, Direction.NORTH) || WaterloggedVegetationPatchFeature.isExposedDirection(var0, var2, var3, Direction.EAST) || WaterloggedVegetationPatchFeature.isExposedDirection(var0, var2, var3, Direction.SOUTH) || WaterloggedVegetationPatchFeature.isExposedDirection(var0, var2, var3, Direction.WEST) || WaterloggedVegetationPatchFeature.isExposedDirection(var0, var2, var3, Direction.DOWN);
    }

    private static boolean isExposedDirection(WorldGenLevel var0, BlockPos var1, BlockPos.MutableBlockPos var2, Direction var3) {
        var2.setWithOffset((Vec3i)var1, var3);
        return !var0.getBlockState(var2).isFaceSturdy(var0, var2, var3.getOpposite());
    }

    @Override
    protected boolean placeVegetation(WorldGenLevel var0, VegetationPatchConfiguration var1, ChunkGenerator var2, RandomSource var3, BlockPos var4) {
        if (super.placeVegetation(var0, var1, var2, var3, var4.below())) {
            BlockState var5 = var0.getBlockState(var4);
            if (var5.hasProperty(BlockStateProperties.WATERLOGGED) && !var5.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
                var0.setBlock(var4, (BlockState)var5.setValue(BlockStateProperties.WATERLOGGED, true), 2);
            }
            return true;
        }
        return false;
    }
}

