/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class PlaceOnGroundDecorator
extends TreeDecorator {
    public static final MapCodec<PlaceOnGroundDecorator> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("tries").orElse((Object)128).forGetter(var0 -> var0.tries), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").orElse((Object)2).forGetter(var0 -> var0.radius), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("height").orElse((Object)1).forGetter(var0 -> var0.height), (App)BlockStateProvider.CODEC.fieldOf("block_state_provider").forGetter(var0 -> var0.blockStateProvider)).apply((Applicative)var02, PlaceOnGroundDecorator::new));
    private final int tries;
    private final int radius;
    private final int height;
    private final BlockStateProvider blockStateProvider;

    public PlaceOnGroundDecorator(int var0, int var1, int var2, BlockStateProvider var3) {
        this.tries = var0;
        this.radius = var1;
        this.height = var2;
        this.blockStateProvider = var3;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PLACE_ON_GROUND;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        List<BlockPos> var1 = TreeFeature.getLowestTrunkOrRootOfTree(var0);
        if (var1.isEmpty()) {
            return;
        }
        BlockPos var2 = var1.getFirst();
        int var3 = var2.getY();
        int var4 = var2.getX();
        int var5 = var2.getX();
        int var6 = var2.getZ();
        int var7 = var2.getZ();
        for (BlockPos blockPos : var1) {
            if (blockPos.getY() != var3) continue;
            var4 = Math.min(var4, blockPos.getX());
            var5 = Math.max(var5, blockPos.getX());
            var6 = Math.min(var6, blockPos.getZ());
            var7 = Math.max(var7, blockPos.getZ());
        }
        RandomSource var8 = var0.random();
        BoundingBox boundingBox = new BoundingBox(var4, var3, var6, var5, var3, var7).inflatedBy(this.radius, this.height, this.radius);
        BlockPos.MutableBlockPos var10 = new BlockPos.MutableBlockPos();
        for (int var11 = 0; var11 < this.tries; ++var11) {
            var10.set(var8.nextIntBetweenInclusive(boundingBox.minX(), boundingBox.maxX()), var8.nextIntBetweenInclusive(boundingBox.minY(), boundingBox.maxY()), var8.nextIntBetweenInclusive(boundingBox.minZ(), boundingBox.maxZ()));
            this.attemptToPlaceBlockAbove(var0, var10);
        }
    }

    private void attemptToPlaceBlockAbove(TreeDecorator.Context var02, BlockPos var1) {
        BlockPos var2 = var1.above();
        if (var02.level().isStateAtPosition(var2, var0 -> var0.isAir() || var0.is(Blocks.VINE)) && var02.checkBlock(var1, BlockBehaviour.BlockStateBase::isSolidRender) && var02.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, var1).getY() <= var2.getY()) {
            var02.setBlock(var2, this.blockStateProvider.getState(var02.random(), var2));
        }
    }
}

