/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ForkingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<ForkingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(var0 -> ForkingTrunkPlacer.trunkPlacerParts(var0).apply((Applicative)var0, ForkingTrunkPlacer::new));

    public ForkingTrunkPlacer(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.FORKING_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, BlockPos var4, TreeConfiguration var5) {
        int var15;
        ForkingTrunkPlacer.setDirtAt(var0, var1, var2, var4.below(), var5);
        ArrayList var6 = Lists.newArrayList();
        Direction var7 = Direction.Plane.HORIZONTAL.getRandomDirection(var2);
        int var8 = var3 - var2.nextInt(4) - 1;
        int var9 = 3 - var2.nextInt(3);
        BlockPos.MutableBlockPos var10 = new BlockPos.MutableBlockPos();
        int var11 = var4.getX();
        int var12 = var4.getZ();
        OptionalInt var13 = OptionalInt.empty();
        for (int var14 = 0; var14 < var3; ++var14) {
            var15 = var4.getY() + var14;
            if (var14 >= var8 && var9 > 0) {
                var11 += var7.getStepX();
                var12 += var7.getStepZ();
                --var9;
            }
            if (!this.placeLog(var0, var1, var2, var10.set(var11, var15, var12), var5)) continue;
            var13 = OptionalInt.of(var15 + 1);
        }
        if (var13.isPresent()) {
            var6.add(new FoliagePlacer.FoliageAttachment(new BlockPos(var11, var13.getAsInt(), var12), 1, false));
        }
        var11 = var4.getX();
        var12 = var4.getZ();
        Direction var14 = Direction.Plane.HORIZONTAL.getRandomDirection(var2);
        if (var14 != var7) {
            var15 = var8 - var2.nextInt(2) - 1;
            int var16 = 1 + var2.nextInt(3);
            var13 = OptionalInt.empty();
            for (int var17 = var15; var17 < var3 && var16 > 0; ++var17, --var16) {
                if (var17 < 1) continue;
                int var18 = var4.getY() + var17;
                if (!this.placeLog(var0, var1, var2, var10.set(var11 += var14.getStepX(), var18, var12 += var14.getStepZ()), var5)) continue;
                var13 = OptionalInt.of(var18 + 1);
            }
            if (var13.isPresent()) {
                var6.add(new FoliagePlacer.FoliageAttachment(new BlockPos(var11, var13.getAsInt(), var12), 0, false));
            }
        }
        return var6;
    }
}

