/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class EndCityPieces {
    private static final int MAX_GEN_DEPTH = 8;
    static final SectionGenerator HOUSE_TOWER_GENERATOR = new SectionGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i, EndCityPiece endcitypieces_a, BlockPos blockposition, List<StructurePiece> list, RandomSource randomsource) {
            if (i > 8) {
                return false;
            }
            Rotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            EndCityPiece endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, blockposition, "base_floor", enumblockrotation, true));
            int j = randomsource.nextInt(3);
            if (j == 0) {
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 4, -1), "base_roof", enumblockrotation, true));
            } else if (j == 1) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 0, -1), "second_floor_2", enumblockrotation, false));
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 8, -1), "second_roof", enumblockrotation, false));
                EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_GENERATOR, i + 1, endcitypieces_a1, null, list, randomsource);
            } else if (j == 2) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 0, -1), "second_floor_2", enumblockrotation, false));
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 4, -1), "third_floor_2", enumblockrotation, false));
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 8, -1), "third_roof", enumblockrotation, true));
                EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_GENERATOR, i + 1, endcitypieces_a1, null, list, randomsource);
            }
            return true;
        }
    };
    static final List<Tuple<Rotation, BlockPos>> TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(1, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(6, -1, 1)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 5)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(5, -1, 6))});
    static final SectionGenerator TOWER_GENERATOR = new SectionGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i, EndCityPiece endcitypieces_a, BlockPos blockposition, List<StructurePiece> list, RandomSource randomsource) {
            Rotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            EndCityPiece endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPos(3 + randomsource.nextInt(2), -3, 3 + randomsource.nextInt(2)), "tower_base", enumblockrotation, true));
            endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(0, 7, 0), "tower_piece", enumblockrotation, true));
            EndCityPiece endcitypieces_a2 = randomsource.nextInt(3) == 0 ? endcitypieces_a1 : null;
            int j = 1 + randomsource.nextInt(3);
            for (int k = 0; k < j; ++k) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(0, 4, 0), "tower_piece", enumblockrotation, true));
                if (k >= j - 1 || !randomsource.nextBoolean()) continue;
                endcitypieces_a2 = endcitypieces_a1;
            }
            if (endcitypieces_a2 != null) {
                for (Tuple<Rotation, BlockPos> tuple : TOWER_BRIDGES) {
                    if (!randomsource.nextBoolean()) continue;
                    EndCityPiece endcitypieces_a3 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a2, tuple.getB(), "bridge_end", enumblockrotation.getRotated(tuple.getA()), true));
                    EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_BRIDGE_GENERATOR, i + 1, endcitypieces_a3, null, list, randomsource);
                }
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 4, -1), "tower_top", enumblockrotation, true));
            } else {
                if (i != 7) {
                    return EndCityPieces.recursiveChildren(structuretemplatemanager, FAT_TOWER_GENERATOR, i + 1, endcitypieces_a1, null, list, randomsource);
                }
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-1, 4, -1), "tower_top", enumblockrotation, true));
            }
            return true;
        }
    };
    static final SectionGenerator TOWER_BRIDGE_GENERATOR = new SectionGenerator(){
        public boolean shipCreated;

        @Override
        public void init() {
            this.shipCreated = false;
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i, EndCityPiece endcitypieces_a, BlockPos blockposition, List<StructurePiece> list, RandomSource randomsource) {
            Rotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            int j = randomsource.nextInt(4) + 1;
            EndCityPiece endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPos(0, 0, -4), "bridge_piece", enumblockrotation, true));
            endcitypieces_a1.setGenDepth(-1);
            int k = 0;
            for (int l = 0; l < j; ++l) {
                if (randomsource.nextBoolean()) {
                    endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(0, k, -4), "bridge_piece", enumblockrotation, true));
                    k = 0;
                    continue;
                }
                endcitypieces_a1 = randomsource.nextBoolean() ? EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(0, k, -4), "bridge_steep_stairs", enumblockrotation, true)) : EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(0, k, -8), "bridge_gentle_stairs", enumblockrotation, true));
                k = 4;
            }
            if (!this.shipCreated && randomsource.nextInt(10 - i) == 0) {
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-8 + randomsource.nextInt(8), k, -70 + randomsource.nextInt(10)), "ship", enumblockrotation, true));
                this.shipCreated = true;
            } else if (!EndCityPieces.recursiveChildren(structuretemplatemanager, HOUSE_TOWER_GENERATOR, i + 1, endcitypieces_a1, new BlockPos(-3, k + 1, -11), list, randomsource)) {
                return false;
            }
            endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(4, k, 0), "bridge_end", enumblockrotation.getRotated(Rotation.CLOCKWISE_180), true));
            endcitypieces_a1.setGenDepth(-1);
            return true;
        }
    };
    static final List<Tuple<Rotation, BlockPos>> FAT_TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(4, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(12, -1, 4)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 8)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(8, -1, 12))});
    static final SectionGenerator FAT_TOWER_GENERATOR = new SectionGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i, EndCityPiece endcitypieces_a, BlockPos blockposition, List<StructurePiece> list, RandomSource randomsource) {
            Rotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            EndCityPiece endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPos(-3, 4, -3), "fat_tower_base", enumblockrotation, true));
            endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(0, 4, 0), "fat_tower_middle", enumblockrotation, true));
            for (int j = 0; j < 2 && randomsource.nextInt(3) != 0; ++j) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(0, 8, 0), "fat_tower_middle", enumblockrotation, true));
                for (Tuple<Rotation, BlockPos> tuple : FAT_TOWER_BRIDGES) {
                    if (!randomsource.nextBoolean()) continue;
                    EndCityPiece endcitypieces_a2 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, tuple.getB(), "bridge_end", enumblockrotation.getRotated(tuple.getA()), true));
                    EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_BRIDGE_GENERATOR, i + 1, endcitypieces_a2, null, list, randomsource);
                }
            }
            EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPos(-2, 8, -2), "fat_tower_top", enumblockrotation, true));
            return true;
        }
    };

    static EndCityPiece addPiece(StructureTemplateManager structuretemplatemanager, EndCityPiece endcitypieces_a, BlockPos blockposition, String s, Rotation enumblockrotation, boolean flag) {
        EndCityPiece endcitypieces_a1 = new EndCityPiece(structuretemplatemanager, s, endcitypieces_a.templatePosition(), enumblockrotation, flag);
        BlockPos blockposition1 = endcitypieces_a.template().calculateConnectedPosition(endcitypieces_a.placeSettings(), blockposition, endcitypieces_a1.placeSettings(), BlockPos.ZERO);
        endcitypieces_a1.move(blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
        return endcitypieces_a1;
    }

    public static void startHouseTower(StructureTemplateManager structuretemplatemanager, BlockPos blockposition, Rotation enumblockrotation, List<StructurePiece> list, RandomSource randomsource) {
        FAT_TOWER_GENERATOR.init();
        HOUSE_TOWER_GENERATOR.init();
        TOWER_BRIDGE_GENERATOR.init();
        TOWER_GENERATOR.init();
        EndCityPiece endcitypieces_a = EndCityPieces.addHelper(list, new EndCityPiece(structuretemplatemanager, "base_floor", blockposition, enumblockrotation, true));
        endcitypieces_a = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPos(-1, 0, -1), "second_floor_1", enumblockrotation, false));
        endcitypieces_a = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPos(-1, 4, -1), "third_floor_1", enumblockrotation, false));
        endcitypieces_a = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPos(-1, 8, -1), "third_roof", enumblockrotation, true));
        EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_GENERATOR, 1, endcitypieces_a, null, list, randomsource);
    }

    static EndCityPiece addHelper(List<StructurePiece> list, EndCityPiece endcitypieces_a) {
        list.add(endcitypieces_a);
        return endcitypieces_a;
    }

    static boolean recursiveChildren(StructureTemplateManager structuretemplatemanager, SectionGenerator endcitypieces_b, int i, EndCityPiece endcitypieces_a, BlockPos blockposition, List<StructurePiece> list, RandomSource randomsource) {
        if (i > 8) {
            return false;
        }
        ArrayList list1 = Lists.newArrayList();
        if (endcitypieces_b.generate(structuretemplatemanager, i, endcitypieces_a, blockposition, list1, randomsource)) {
            boolean flag = false;
            int j = randomsource.nextInt();
            for (StructurePiece structurepiece : list1) {
                structurepiece.setGenDepth(j);
                StructurePiece structurepiece1 = StructurePiece.findCollisionPiece(list, structurepiece.getBoundingBox());
                if (structurepiece1 == null || structurepiece1.getGenDepth() == endcitypieces_a.getGenDepth()) continue;
                flag = true;
                break;
            }
            if (!flag) {
                list.addAll(list1);
                return true;
            }
        }
        return false;
    }

    public static class EndCityPiece
    extends TemplateStructurePiece {
        public EndCityPiece(StructureTemplateManager structuretemplatemanager, String s, BlockPos blockposition, Rotation enumblockrotation, boolean flag) {
            super(StructurePieceType.END_CITY_PIECE, 0, structuretemplatemanager, EndCityPiece.makeResourceLocation(s), s, EndCityPiece.makeSettings(flag, enumblockrotation), blockposition);
        }

        public EndCityPiece(StructureTemplateManager structuretemplatemanager, CompoundTag nbttagcompound) {
            super(StructurePieceType.END_CITY_PIECE, nbttagcompound, structuretemplatemanager, minecraftkey -> EndCityPiece.makeSettings(nbttagcompound.getBooleanOr("OW", false), nbttagcompound.read("Rot", Rotation.LEGACY_CODEC).orElseThrow()));
        }

        private static StructurePlaceSettings makeSettings(boolean flag, Rotation enumblockrotation) {
            BlockIgnoreProcessor definedstructureprocessorblockignore = flag ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR;
            return new StructurePlaceSettings().setIgnoreEntities(true).addProcessor(definedstructureprocessorblockignore).setRotation(enumblockrotation);
        }

        @Override
        protected ResourceLocation makeTemplateLocation() {
            return EndCityPiece.makeResourceLocation(this.templateName);
        }

        private static ResourceLocation makeResourceLocation(String s) {
            return ResourceLocation.withDefaultNamespace("end_city/" + s);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.store("Rot", Rotation.LEGACY_CODEC, this.placeSettings.getRotation());
            nbttagcompound.putBoolean("OW", this.placeSettings.getProcessors().get(0) == BlockIgnoreProcessor.STRUCTURE_BLOCK);
        }

        @Override
        protected void handleDataMarker(String s, BlockPos blockposition, ServerLevelAccessor worldaccess, RandomSource randomsource, BoundingBox structureboundingbox) {
            if (s.startsWith("Chest")) {
                BlockPos blockposition1 = blockposition.below();
                if (structureboundingbox.isInside(blockposition1)) {
                    this.setCraftLootTable(worldaccess, blockposition1, randomsource, BuiltInLootTables.END_CITY_TREASURE);
                }
            } else if (structureboundingbox.isInside(blockposition) && Level.isInSpawnableBounds(blockposition)) {
                if (s.startsWith("Sentry")) {
                    Shulker entityshulker = EntityType.SHULKER.create(worldaccess.getLevel(), EntitySpawnReason.STRUCTURE);
                    if (entityshulker != null) {
                        entityshulker.setPos((double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5);
                        worldaccess.addFreshEntity(entityshulker);
                    }
                } else if (s.startsWith("Elytra")) {
                    ItemFrame entityitemframe = new ItemFrame(worldaccess.getLevel(), blockposition, this.placeSettings.getRotation().rotate(Direction.SOUTH));
                    entityitemframe.setItem(new ItemStack(Items.ELYTRA), false);
                    worldaccess.addFreshEntity(entityitemframe);
                }
            }
        }
    }

    private static interface SectionGenerator {
        public void init();

        public boolean generate(StructureTemplateManager var1, int var2, EndCityPiece var3, BlockPos var4, List<StructurePiece> var5, RandomSource var6);
    }
}

