/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;

public class PathFinder {
    private static final float FUDGING = 1.5f;
    private final Node[] neighbors = new Node[32];
    private int maxVisitedNodes;
    private final NodeEvaluator nodeEvaluator;
    private static final boolean DEBUG = false;
    private final BinaryHeap openSet = new BinaryHeap();

    public PathFinder(NodeEvaluator var0, int var1) {
        this.nodeEvaluator = var0;
        this.maxVisitedNodes = var1;
    }

    public void setMaxVisitedNodes(int var0) {
        this.maxVisitedNodes = var0;
    }

    @Nullable
    public Path findPath(PathNavigationRegion var02, Mob var1, Set<BlockPos> var2, float var3, int var4, float var5) {
        this.openSet.clear();
        this.nodeEvaluator.prepare(var02, var1);
        Node var6 = this.nodeEvaluator.getStart();
        if (var6 == null) {
            return null;
        }
        Map<Target, BlockPos> var7 = var2.stream().collect(Collectors.toMap(var0 -> this.nodeEvaluator.getTarget(var0.getX(), var0.getY(), var0.getZ()), Function.identity()));
        Path var8 = this.findPath(var6, var7, var3, var4, var5);
        this.nodeEvaluator.done();
        return var8;
    }

    @Nullable
    private Path findPath(Node var0, Map<Target, BlockPos> var12, float var2, int var3, float var4) {
        Object var11;
        ProfilerFiller var5 = Profiler.get();
        var5.push("find_path");
        var5.markForCharting(MetricCategory.PATH_FINDING);
        Set<Target> var6 = var12.keySet();
        var0.g = 0.0f;
        var0.f = var0.h = this.getBestH(var0, var6);
        this.openSet.clear();
        this.openSet.insert(var0);
        ImmutableSet var7 = ImmutableSet.of();
        int var8 = 0;
        HashSet var9 = Sets.newHashSetWithExpectedSize((int)var6.size());
        int var10 = (int)((float)this.maxVisitedNodes * var4);
        while (!this.openSet.isEmpty() && ++var8 < var10) {
            var11 = this.openSet.pop();
            ((Node)var11).closed = true;
            for (Target var13 : var6) {
                if (!(((Node)var11).distanceManhattan(var13) <= (float)var3)) continue;
                var13.setReached();
                var9.add(var13);
            }
            if (!var9.isEmpty()) break;
            if (((Node)var11).distanceTo(var0) >= var2) continue;
            int var122 = this.nodeEvaluator.getNeighbors(this.neighbors, (Node)var11);
            for (int var13 = 0; var13 < var122; ++var13) {
                Node var14 = this.neighbors[var13];
                float var15 = this.distance((Node)var11, var14);
                var14.walkedDistance = ((Node)var11).walkedDistance + var15;
                float var16 = ((Node)var11).g + var15 + var14.costMalus;
                if (!(var14.walkedDistance < var2) || var14.inOpenSet() && !(var16 < var14.g)) continue;
                var14.cameFrom = var11;
                var14.g = var16;
                var14.h = this.getBestH(var14, var6) * 1.5f;
                if (var14.inOpenSet()) {
                    this.openSet.changeCost(var14, var14.g + var14.h);
                    continue;
                }
                var14.f = var14.g + var14.h;
                this.openSet.insert(var14);
            }
        }
        var11 = !var9.isEmpty() ? var9.stream().map(var1 -> this.reconstructPath(var1.getBestNode(), (BlockPos)var12.get(var1), true)).min(Comparator.comparingInt(Path::getNodeCount)) : var6.stream().map(var1 -> this.reconstructPath(var1.getBestNode(), (BlockPos)var12.get(var1), false)).min(Comparator.comparingDouble(Path::getDistToTarget).thenComparingInt(Path::getNodeCount));
        var5.pop();
        if (((Optional)var11).isEmpty()) {
            return null;
        }
        Path var123 = (Path)((Optional)var11).get();
        return var123;
    }

    protected float distance(Node var0, Node var1) {
        return var0.distanceTo(var1);
    }

    private float getBestH(Node var0, Set<Target> var1) {
        float var2 = Float.MAX_VALUE;
        for (Target var4 : var1) {
            float var5 = var0.distanceTo(var4);
            var4.updateBest(var5, var0);
            var2 = Math.min(var5, var2);
        }
        return var2;
    }

    private Path reconstructPath(Node var0, BlockPos var1, boolean var2) {
        ArrayList var3 = Lists.newArrayList();
        Node var4 = var0;
        var3.add(0, var4);
        while (var4.cameFrom != null) {
            var4 = var4.cameFrom;
            var3.add(0, var4);
        }
        return new Path(var3, var1, var2);
    }

    private static /* synthetic */ Node[] lambda$findPath$3(int var0) {
        return new Node[var0];
    }
}

