/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public record MapId(int id) implements TooltipProvider
{
    public static final Codec<MapId> CODEC = Codec.INT.xmap(MapId::new, MapId::id);
    public static final StreamCodec<ByteBuf, MapId> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(MapId::new, MapId::id);
    private static final Component LOCKED_TEXT = Component.translatable("filled_map.locked").withStyle(ChatFormatting.GRAY);

    public String key() {
        return "map_" + this.id;
    }

    @Override
    public void addToTooltip(Item.TooltipContext var0, Consumer<Component> var1, TooltipFlag var2, DataComponentGetter var3) {
        MapItemSavedData var4 = var0.mapData(this);
        if (var4 == null) {
            var1.accept(Component.translatable("filled_map.unknown").withStyle(ChatFormatting.GRAY));
            return;
        }
        MapPostProcessing var5 = var3.get(DataComponents.MAP_POST_PROCESSING);
        if (var3.get(DataComponents.CUSTOM_NAME) == null && var5 == null) {
            var1.accept(Component.translatable("filled_map.id", this.id).withStyle(ChatFormatting.GRAY));
        }
        if (var4.locked || var5 == MapPostProcessing.LOCK) {
            var1.accept(LOCKED_TEXT);
        }
        if (var2.isAdvanced()) {
            byte var6 = var5 == MapPostProcessing.SCALE ? (byte)1 : 0;
            int var7 = Math.min(var4.scale + var6, 4);
            var1.accept(Component.translatable("filled_map.scale", 1 << var7).withStyle(ChatFormatting.GRAY));
            var1.accept(Component.translatable("filled_map.level", var7, 4).withStyle(ChatFormatting.GRAY));
        }
    }
}

